/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.internal.core.IModel;
import org.eclipse.mtj.internal.core.text.DocumentObject;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.IL10nConstants;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class L10nObject
extends DocumentObject
implements IL10nConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private IStatus status = new Status(0, "org.eclipse.mtj.core", "");

    public L10nObject(L10nModel l10nModel, String string) {
        super(l10nModel, string);
    }

    public void addChild(L10nObject l10nObject) {
        this.addChildNode((IDocumentElementNode)l10nObject, true);
    }

    public void addChild(L10nObject l10nObject, L10nObject l10nObject2, boolean bl) {
        int n = this.indexOf(l10nObject2);
        if (!bl) {
            ++n;
        }
        this.addChildNode(l10nObject, n, true);
    }

    public abstract boolean canBeParent();

    public boolean canBeRemoved() {
        if (this.getType() == 0) {
            return false;
        }
        L10nObject l10nObject = this.getParent();
        return l10nObject != null;
    }

    public boolean descendsFrom(L10nObject l10nObject) {
        if (this.equals(l10nObject)) {
            return true;
        }
        if (this.getParent() != null && l10nObject.canBeParent()) {
            return this.getParent().descendsFrom(l10nObject);
        }
        return false;
    }

    public List<IDocumentElementNode> getChildren() {
        ArrayList<IDocumentElementNode> arrayList = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
        if (iDocumentElementNodeArray.length > 0) {
            int n = 0;
            while (n < iDocumentElementNodeArray.length) {
                if (iDocumentElementNodeArray[n] instanceof L10nObject) {
                    arrayList.add(iDocumentElementNodeArray[n]);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public L10nLocales getLocales() {
        L10nModel l10nModel = this.getModel();
        if (l10nModel != null) {
            return l10nModel.getLocales();
        }
        return null;
    }

    public L10nModel getModel() {
        IModel iModel = this.getSharedModel();
        if (iModel instanceof L10nModel) {
            return (L10nModel)iModel;
        }
        return null;
    }

    public abstract String getName();

    public L10nObject getNextSibling(L10nObject l10nObject) {
        return (L10nObject)this.getNextSibling(l10nObject, L10nObject.class);
    }

    public L10nObject getParent() {
        IDocumentElementNode iDocumentElementNode = this.getParentNode();
        return iDocumentElementNode instanceof L10nObject ? (L10nObject)iDocumentElementNode : null;
    }

    public L10nObject getPreviousSibling(L10nObject l10nObject) {
        return (L10nObject)this.getPreviousSibling(l10nObject, L10nObject.class);
    }

    public IStatus getStatus() {
        return this.status;
    }

    public abstract int getType();

    @Override
    public boolean isLeafNode() {
        return !this.canBeParent();
    }

    public void setStatus(IStatus iStatus) {
        this.status = iStatus;
    }

    @Override
    public abstract void validate();

    @Override
    protected String getAttributeIndent() {
        return " ";
    }
}

