/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.mtj.internal.core.util.AbstractSearchScope;

public abstract class AbstractSuperClassSearchScope
extends AbstractSearchScope {
    private IJavaSearchScope[] scopes;

    public IJavaSearchScope[] getScopes() {
        return this.scopes;
    }

    public void setScopes(IJavaSearchScope[] iJavaSearchScopeArray) {
        this.scopes = iJavaSearchScopeArray;
    }

    public AbstractSuperClassSearchScope() {
    }

    public AbstractSuperClassSearchScope(IJavaProject iJavaProject) throws JavaModelException {
    }

    public boolean encloses(String string) {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.scopes.length) {
            bl = this.scopes[n].encloses(string);
            ++n;
        }
        return bl;
    }

    public boolean encloses(IJavaElement iJavaElement) {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.scopes.length) {
            bl = this.scopes[n].encloses(iJavaElement);
            ++n;
        }
        return bl;
    }

    public IPath[] enclosingProjectsAndJars() {
        HashSet<IPath> hashSet = new HashSet<IPath>();
        int n = 0;
        while (n < this.scopes.length) {
            IJavaSearchScope iJavaSearchScope = this.scopes[n];
            IPath[] iPathArray = iJavaSearchScope.enclosingProjectsAndJars();
            int n2 = 0;
            while (n2 < iPathArray.length) {
                hashSet.add(iPathArray[n2]);
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    public IJavaSearchScope[] createSearchScopes(IJavaProject iJavaProject, String string, String string2) throws JavaModelException {
        IJavaSearchScope[] iJavaSearchScopeArray = null;
        if (iJavaProject == null || !iJavaProject.exists()) {
            IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
            iJavaSearchScopeArray = new IJavaSearchScope[]{iJavaSearchScope};
        } else {
            IJavaElement[] iJavaElementArray;
            ArrayList<IJavaElement[]> arrayList = new ArrayList<IJavaElement[]>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                iJavaElementArray = iPackageFragmentRootArray[n2];
                if (iJavaElementArray.getKind() == 1) {
                    arrayList.add(iJavaElementArray);
                }
                ++n2;
            }
            iJavaElementArray = arrayList.toArray(new IJavaElement[arrayList.size()]);
            IType iType = iJavaProject.findType(string2);
            iJavaSearchScopeArray = iType != null ? new IJavaSearchScope[]{SearchEngine.createHierarchyScope((IType)iType), SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray), new MidletMidletExclusionScope(string)} : new IJavaSearchScope[]{};
        }
        return iJavaSearchScopeArray;
    }

    private static class MidletMidletExclusionScope
    extends AbstractSearchScope {
        String searchClassName;

        public MidletMidletExclusionScope(String string) {
            this.searchClassName = string;
        }

        public boolean encloses(String string) {
            boolean bl = string.endsWith("java/lang/Object.class") || string.endsWith(this.searchClassName);
            return !bl;
        }

        public boolean encloses(IJavaElement iJavaElement) {
            return true;
        }

        public IPath[] enclosingProjectsAndJars() {
            return new IPath[0];
        }
    }
}

