/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.PrintWriter;
import java.util.Enumeration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String createEscapedValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\' || c == '\t' || c == '\r' || c == '\n' || c == '\f') {
                stringBuffer.append('\\');
                stringBuffer.append(c);
            } else if (c < ' ' || c > '~') {
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(HEX[c >> 12 & 0xF]);
                stringBuffer.append(HEX[c >> 8 & 0xF]);
                stringBuffer.append(HEX[c >> 4 & 0xF]);
                stringBuffer.append(HEX[c & 0xF]);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String createWritableName(String string) {
        if (string.indexOf(32) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == ' ') {
                    stringBuffer.append("\\ ");
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        return PropertiesUtil.createEscapedValue(string);
    }

    public static int getInsertOffset(IDocument iDocument) {
        int n = iDocument.getLength();
        int n2 = iDocument.getNumberOfLines() - 1;
        while (n2 >= 0) {
            try {
                if (iDocument.get(iDocument.getLineOffset(n2), iDocument.getLineLength(n2)).trim().length() > 0) break;
                n = iDocument.getLineOffset(n2);
            }
            catch (BadLocationException badLocationException) {}
            --n2;
        }
        return n;
    }

    public static boolean isNewlineNeeded(IDocument iDocument) throws BadLocationException {
        int n = iDocument.getLineOfOffset(PropertiesUtil.getInsertOffset(iDocument));
        return iDocument.get(iDocument.getLineOffset(n), iDocument.getLineLength(n)).trim().length() > 0;
    }

    public static String windEscapeChars(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\') {
                if (n2 >= n) break;
                if ((c = string.charAt(n2++)) == 'u') {
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < 4) {
                        if (n2 >= n) break;
                        c = string.charAt(n2++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n3 = (n3 << 4) + c - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n3 = (n3 << 4) + 10 + c - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n3 = (n3 << 4) + 10 + c - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n4;
                    }
                    stringBuffer.append((char)n3);
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'f') {
                    stringBuffer.append('\f');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void writeKeyValuePair(String string, String string2, Enumeration<?> enumeration, PrintWriter printWriter) {
        String string3 = PropertiesUtil.createWritableName(string2);
        printWriter.print(String.valueOf(string3) + " = ");
        if (!enumeration.hasMoreElements()) {
            printWriter.println();
            return;
        }
        int n = string2.length() + 3;
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement().toString();
            printWriter.print(PropertiesUtil.createEscapedValue(string4));
            if (enumeration.hasMoreElements()) {
                printWriter.println(",\\");
                int n2 = 0;
                while (n2 < n) {
                    printWriter.print(" ");
                    ++n2;
                }
                continue;
            }
            printWriter.println("");
        }
    }

    public static void writeKeyValuePair(String string, String string2, String string3, PrintWriter printWriter) {
        String string4 = PropertiesUtil.createWritableName(string2);
        printWriter.print(String.valueOf(string4) + " = ");
        printWriter.println(PropertiesUtil.createEscapedValue(string3));
    }
}

