/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final String ATTR_VERSION = "version";
    private static final String PROP_LOG_XMLUTILS = "mtj.log.xmlutils";
    private static final boolean DO_LOG = System.getProperty("mtj.log.xmlutils", Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
    private static final String XSLT_TEMPLATE = "<xsl:stylesheet version=\"1.0\"\r\n      xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n   <xsl:output method=\"xml\"/>\r\n   <xsl:param name=\"indent-increment\" select=\"'   '\" />\r\n\r\n   <xsl:template match=\"*\">\r\n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>\r\n\r\n      <xsl:value-of select=\"$indent\"/>\r\n      <xsl:copy>\r\n        <xsl:copy-of select=\"@*\" />\r\n        <xsl:apply-templates>\r\n          <xsl:with-param name=\"indent\"\r\n               select=\"concat($indent, $indent-increment)\"/>\r\n        </xsl:apply-templates>\r\n        <xsl:if test=\"*\">\r\n          <xsl:value-of select=\"$indent\"/>\r\n        </xsl:if>\r\n      </xsl:copy>\r\n   </xsl:template>\r\n\r\n   <xsl:template match=\"comment()|processing-instruction()\">\r\n      <xsl:copy />\r\n   </xsl:template>\r\n\r\n   <!-- WARNING: this is dangerous. Handle with care -->\r\n   <xsl:template match=\"text()[normalize-space(.)='']\"/>\r\n\r\n</xsl:stylesheet>";

    public static Element createChild(Element element, String string) throws DOMException {
        Element element2 = null;
        if (element != null && string != null && !string.equals("")) {
            Document document;
            if (DO_LOG) {
                System.out.println(NLS.bind((String)"createChild: parent = {0}; name = {1}", (Object[])new String[]{element.getTagName(), string}));
            }
            if ((document = element.getOwnerDocument()) != null) {
                element2 = document.createElement(string);
                element.appendChild(element2);
            }
        }
        return element2;
    }

    public static Element createRootElement(String string, Version version) throws ParserConfigurationException {
        if (DO_LOG) {
            System.out.println(NLS.bind((String)"createRootElement: elementName = {0}; version = {1}", (Object[])new String[]{string, version.toString()}));
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(string);
        document.appendChild(element);
        element.setAttribute(ATTR_VERSION, version.toString());
        return element;
    }

    public static void createTextElement(Element element, String string, String string2) {
        if (DO_LOG) {
            System.out.println("createTextElement: parent = " + element.getTagName() + "; name = " + string + "; text = " + string2);
        }
        Element element2 = XMLUtils.createChild(element, string);
        if (string2 != null) {
            Text text = element.getOwnerDocument().createTextNode(string2);
            element2.appendChild(text);
        }
    }

    public static String getElementText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                stringBuffer.append(((Text)node).getData());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Element getFirstElementWithTagName(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    public static Version getVersion(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getAttribute(ATTR_VERSION);
        if (string.length() == 0) {
            string = Version.emptyVersion.toString();
        }
        return new Version(string);
    }

    public static Document readDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (file != null && file.exists()) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        return document;
    }

    public static Document readDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (inputStream != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        return document;
    }

    public static void writeDocument(File file, Document document) throws TransformerException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        try {
            XMLUtils.writeDocument(outputStreamWriter, document);
        }
        finally {
            outputStreamWriter.close();
        }
    }

    public static void writeDocument(Writer writer, Document document) throws TransformerException, IOException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource dOMSource = new DOMSource(document);
        StringReader stringReader = new StringReader(XSLT_TEMPLATE);
        StreamSource streamSource = new StreamSource(stringReader);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.transform(dOMSource, streamResult);
    }

    public static Element createTargetElement(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement("target");
        element.appendChild(element2);
        element2.setAttribute("name", string);
        element2.setAttribute("depends", string2);
        return element2;
    }

    private XMLUtils() {
    }
}

