/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.java.tasks.JavaStackTraceFileHyperlink;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaStackTraceHyperlinkDetector
extends AbstractTaskHyperlinkDetector {
    private static final Pattern stackTracePattern = Pattern.compile("\\S*\\(([\\w\\$]*\\.java:\\d*)\\)", 2);

    private static IRegion determineRegion(int textOffset, Matcher m, int group) {
        return new Region(textOffset + m.start(group), m.end(group) - m.start(group));
    }

    private static boolean isInRegion(int offsetInText, Matcher m) {
        return offsetInText == -1 || offsetInText >= m.start() && offsetInText <= m.end();
    }

    protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int offsetInContent, int contentOffset) {
        ArrayList<JavaStackTraceFileHyperlink> links = null;
        Matcher m = stackTracePattern.matcher(content);
        while (m.find()) {
            if (!JavaStackTraceHyperlinkDetector.isInRegion(offsetInContent, m)) continue;
            if (links == null) {
                links = new ArrayList<JavaStackTraceFileHyperlink>();
            }
            links.add(new JavaStackTraceFileHyperlink(JavaStackTraceHyperlinkDetector.determineRegion(contentOffset, m, 0), m.group(), JavaStackTraceHyperlinkDetector.determineRegion(contentOffset, m, 1)));
        }
        return links;
    }
}

