/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class ChangeMethodSignatureProposal
extends LinkedCorrectionProposal {
    private ASTNode fInvocationNode;
    private IFunctionBinding fSenderBinding;
    private ChangeDescription[] fParameterChanges;
    private ChangeDescription[] fExceptionChanges;

    public ChangeMethodSignatureProposal(String label, IJavaScriptUnit targetCU, ASTNode invocationNode, IFunctionBinding binding, ChangeDescription[] paramChanges, ChangeDescription[] exceptionChanges, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
        this.fParameterChanges = paramChanges;
        this.fExceptionChanges = exceptionChanges;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        JavaScriptUnit astRoot = (JavaScriptUnit)this.fInvocationNode.getRoot();
        ASTNode methodDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newMethodDecl = null;
        if (methodDecl != null) {
            isInDifferentCU = false;
            newMethodDecl = methodDecl;
        } else {
            isInDifferentCU = true;
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newMethodDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        if (newMethodDecl instanceof FunctionDeclaration) {
            FunctionDeclaration decl = (FunctionDeclaration)newMethodDecl;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            if (this.fParameterChanges != null) {
                this.modifyParameters(rewrite, decl, isInDifferentCU);
            }
            if (this.fExceptionChanges != null) {
                this.modifyExceptions(rewrite, decl);
            }
            return rewrite;
        }
        return null;
    }

    private void modifyParameters(ASTRewrite rewrite, FunctionDeclaration methodDecl, boolean isInDifferentCU) throws CoreException {
        AST ast = methodDecl.getAST();
        ArrayList<String> usedNames = new ArrayList<String>();
        boolean hasCreatedVariables = false;
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaringClass().getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            usedNames.add(declaredFields[i].getName());
            ++i;
        }
        ImportRewrite imports = this.getImportRewrite();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        List parameters = methodDecl.parameters();
        int k = 0;
        int i2 = 0;
        while (i2 < this.fParameterChanges.length) {
            ModifyDescription desc;
            ChangeDescription curr = this.fParameterChanges[i2];
            if (curr == null) {
                SingleVariableDeclaration oldParam = (SingleVariableDeclaration)parameters.get(k);
                usedNames.add(oldParam.getName().getIdentifier());
                ++k;
            } else if (curr instanceof InsertDescription) {
                desc = (InsertDescription)curr;
                SingleVariableDeclaration newNode = ast.newSingleVariableDeclaration();
                newNode.setType(imports.addImport(desc.type, ast));
                newNode.setName(ast.newSimpleName("x"));
                desc.resultingParamName = new SimpleName[]{newNode.getName()};
                desc.resultingParamType = newNode.getType();
                hasCreatedVariables = true;
                listRewrite.insertAt((ASTNode)newNode, i2, null);
                JSdoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null) {
                    TagElement newTagElement = ast.newTagElement();
                    newTagElement.setTagName("@param");
                    SimpleName arg = ast.newSimpleName("x");
                    newTagElement.fragments().add(arg);
                    this.insertTabStop(rewrite, newTagElement.fragments(), "param_tagcomment" + i2);
                    this.insertParamTag(rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY), parameters, k, newTagElement);
                    desc.resultingTagArg = arg;
                } else {
                    desc.resultingTagArg = null;
                }
            } else if (curr instanceof RemoveDescription) {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)parameters.get(k);
                listRewrite.remove((ASTNode)decl, null);
                ++k;
                TagElement tagNode = this.findParamTag(methodDecl, decl);
                if (tagNode != null) {
                    rewrite.remove((ASTNode)tagNode, null);
                }
            } else if (curr instanceof EditDescription) {
                List fragments;
                desc = (EditDescription)curr;
                ITypeBinding newTypeBinding = ((EditDescription)desc).type;
                SingleVariableDeclaration decl = (SingleVariableDeclaration)parameters.get(k);
                if (k == parameters.size() - 1 && i2 == this.fParameterChanges.length - 1 && decl.isVarargs() && newTypeBinding.isArray()) {
                    newTypeBinding = newTypeBinding.getElementType();
                } else {
                    rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)Boolean.FALSE, null);
                }
                Type newType = imports.addImport(newTypeBinding, ast);
                rewrite.replace((ASTNode)decl.getType(), (ASTNode)newType, null);
                rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                IBinding binding = decl.getName().resolveBinding();
                if (binding != null) {
                    SimpleName[] names = LinkedNodeFinder.findByBinding(decl.getRoot(), binding);
                    SimpleName[] newNames = new SimpleName[names.length];
                    int j = 0;
                    while (j < names.length) {
                        SimpleName newName;
                        newNames[j] = newName = ast.newSimpleName("x");
                        rewrite.replace((ASTNode)names[j], (ASTNode)newName, null);
                        ++j;
                    }
                    ((EditDescription)desc).resultingParamName = newNames;
                } else {
                    SimpleName newName = ast.newSimpleName("x");
                    rewrite.replace((ASTNode)decl.getName(), (ASTNode)newName, null);
                    ((EditDescription)desc).resultingParamName = new SimpleName[]{newName};
                }
                ((EditDescription)desc).resultingParamType = newType;
                ((EditDescription)desc).orginalName = decl.getName().getIdentifier();
                hasCreatedVariables = true;
                ++k;
                TagElement tagNode = this.findParamTag(methodDecl, decl);
                if (tagNode != null && !(fragments = tagNode.fragments()).isEmpty()) {
                    SimpleName arg = ast.newSimpleName("x");
                    rewrite.replace((ASTNode)fragments.get(0), (ASTNode)arg, null);
                    ((EditDescription)desc).resultingTagArg = arg;
                }
            } else if (curr instanceof SwapDescription) {
                SingleVariableDeclaration decl1 = (SingleVariableDeclaration)parameters.get(k);
                SingleVariableDeclaration decl2 = (SingleVariableDeclaration)parameters.get(((SwapDescription)curr).index);
                rewrite.replace((ASTNode)decl1, rewrite.createCopyTarget((ASTNode)decl2), null);
                rewrite.replace((ASTNode)decl2, rewrite.createCopyTarget((ASTNode)decl1), null);
                usedNames.add(decl1.getName().getIdentifier());
                ++k;
                TagElement tagNode1 = this.findParamTag(methodDecl, decl1);
                TagElement tagNode2 = this.findParamTag(methodDecl, decl2);
                if (tagNode1 != null && tagNode2 != null) {
                    rewrite.replace((ASTNode)tagNode1, rewrite.createCopyTarget((ASTNode)tagNode2), null);
                    rewrite.replace((ASTNode)tagNode2, rewrite.createCopyTarget((ASTNode)tagNode1), null);
                }
            }
            ++i2;
        }
        if (!hasCreatedVariables) {
            return;
        }
        if (methodDecl.getBody() != null) {
            JavaScriptUnit root = (JavaScriptUnit)methodDecl.getRoot();
            IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsAfter(methodDecl.getBody().getStartPosition(), 2);
            int i3 = 0;
            while (i3 < bindings.length) {
                usedNames.add(bindings[i3].getName());
                ++i3;
            }
        }
        this.fixupNames(rewrite, usedNames, methodDecl, isInDifferentCU);
    }

    private void fixupNames(ASTRewrite rewrite, ArrayList usedNames, FunctionDeclaration methodDecl, boolean isInDifferentCU) {
        AST ast = rewrite.getAST();
        int i = 0;
        while (i < this.fParameterChanges.length) {
            ChangeDescription curr = this.fParameterChanges[i];
            if (curr instanceof ModifyDescription) {
                ModifyDescription desc = (ModifyDescription)curr;
                String typeKey = this.getParamTypeGroupId(i);
                String nameKey = this.getParamNameGroupId(i);
                String favourite = null;
                String[] excludedNames = usedNames.toArray(new String[usedNames.size()]);
                String suggestedName = desc.name;
                if (suggestedName != null) {
                    favourite = StubUtility.suggestArgumentName(this.getCompilationUnit().getJavaScriptProject(), suggestedName, excludedNames);
                    this.addLinkedPositionProposal(nameKey, favourite, null);
                }
                if (desc instanceof EditDescription) {
                    this.addLinkedPositionProposal(nameKey, ((EditDescription)desc).orginalName, null);
                }
                Type type = desc.resultingParamType;
                String[] suggestedNames = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaScriptProject(), type, excludedNames);
                int k = 0;
                while (k < suggestedNames.length) {
                    this.addLinkedPositionProposal(nameKey, suggestedNames[k], null);
                    ++k;
                }
                if (favourite == null) {
                    favourite = suggestedNames[0];
                }
                usedNames.add(favourite);
                SimpleName[] names = desc.resultingParamName;
                int j = 0;
                while (j < names.length) {
                    names[j].setIdentifier(favourite);
                    this.addLinkedPosition(rewrite.track((ASTNode)names[j]), false, nameKey);
                    ++j;
                }
                this.addLinkedPosition(rewrite.track((ASTNode)desc.resultingParamType), true, typeKey);
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, desc.type);
                int k2 = 0;
                while (k2 < bindings.length) {
                    this.addLinkedPositionProposal(typeKey, bindings[k2]);
                    ++k2;
                }
                SimpleName tagArg = desc.resultingTagArg;
                if (tagArg != null) {
                    tagArg.setIdentifier(favourite);
                    this.addLinkedPosition(rewrite.track((ASTNode)tagArg), false, nameKey);
                }
            }
            ++i;
        }
    }

    private TagElement findParamTag(FunctionDeclaration decl, SingleVariableDeclaration param) {
        JSdoc javadoc = decl.getJavadoc();
        if (javadoc != null) {
            return JavadocTagsSubProcessor.findParamTag(javadoc, param.getName().getIdentifier());
        }
        return null;
    }

    private TagElement insertParamTag(ListRewrite tagRewriter, List parameters, int currentIndex, TagElement newTagElement) {
        HashSet<String> previousNames = new HashSet<String>();
        int n = 0;
        while (n < currentIndex) {
            SingleVariableDeclaration var = (SingleVariableDeclaration)parameters.get(n);
            previousNames.add(var.getName().getIdentifier());
            ++n;
        }
        JavadocTagsSubProcessor.insertTag(tagRewriter, newTagElement, previousNames);
        return newTagElement;
    }

    private void modifyExceptions(ASTRewrite rewrite, FunctionDeclaration methodDecl) throws CoreException {
        AST ast = methodDecl.getAST();
        ImportRewrite imports = this.getImportRewrite();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        List exceptions = methodDecl.thrownExceptions();
        int k = 0;
        int i = 0;
        while (i < this.fExceptionChanges.length) {
            Name newRef;
            ModifyDescription desc;
            ChangeDescription curr = this.fExceptionChanges[i];
            if (curr == null) {
                ++k;
            } else if (curr instanceof InsertDescription) {
                desc = (InsertDescription)curr;
                String type = imports.addImport(desc.type);
                Name newNode = ASTNodeFactory.newName(ast, type);
                listRewrite.insertAt((ASTNode)newNode, i, null);
                String key = this.getExceptionTypeGroupId(i);
                this.addLinkedPosition(rewrite.track((ASTNode)newNode), false, key);
                JSdoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null) {
                    TagElement newTagElement = ast.newTagElement();
                    newTagElement.setTagName("@throws");
                    newRef = ASTNodeFactory.newName(ast, type);
                    newTagElement.fragments().add(newRef);
                    this.insertTabStop(rewrite, newTagElement.fragments(), "throws_tagcomment" + i);
                    this.insertThrowsTag(rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY), exceptions, k, newTagElement);
                    this.addLinkedPosition(rewrite.track((ASTNode)newRef), false, key);
                }
            } else if (curr instanceof RemoveDescription) {
                Name node = (Name)exceptions.get(k);
                listRewrite.remove((ASTNode)node, null);
                ++k;
                TagElement tagNode = this.findThrowsTag(methodDecl, node);
                if (tagNode != null) {
                    rewrite.remove((ASTNode)tagNode, null);
                }
            } else if (curr instanceof EditDescription) {
                desc = (EditDescription)curr;
                Name oldNode = (Name)exceptions.get(k);
                String type = imports.addImport(((EditDescription)desc).type);
                Name newNode = ASTNodeFactory.newName(ast, type);
                listRewrite.replace((ASTNode)oldNode, (ASTNode)newNode, null);
                String key = this.getExceptionTypeGroupId(i);
                this.addLinkedPosition(rewrite.track((ASTNode)newNode), false, key);
                ++k;
                TagElement tagNode = this.findThrowsTag(methodDecl, oldNode);
                if (tagNode != null) {
                    newRef = ASTNodeFactory.newName(ast, type);
                    rewrite.replace((ASTNode)tagNode.fragments().get(0), (ASTNode)newRef, null);
                    this.addLinkedPosition(rewrite.track((ASTNode)newRef), false, key);
                }
            } else if (curr instanceof SwapDescription) {
                Name decl1 = (Name)exceptions.get(k);
                Name decl2 = (Name)exceptions.get(((SwapDescription)curr).index);
                rewrite.replace((ASTNode)decl1, rewrite.createCopyTarget((ASTNode)decl2), null);
                rewrite.replace((ASTNode)decl2, rewrite.createCopyTarget((ASTNode)decl1), null);
                ++k;
                TagElement tagNode1 = this.findThrowsTag(methodDecl, decl1);
                TagElement tagNode2 = this.findThrowsTag(methodDecl, decl2);
                if (tagNode1 != null && tagNode2 != null) {
                    rewrite.replace((ASTNode)tagNode1, rewrite.createCopyTarget((ASTNode)tagNode2), null);
                    rewrite.replace((ASTNode)tagNode2, rewrite.createCopyTarget((ASTNode)tagNode1), null);
                }
            }
            ++i;
        }
    }

    private void insertTabStop(ASTRewrite rewriter, List fragments, String linkedName) {
        TextElement textElement = rewriter.getAST().newTextElement();
        textElement.setText("");
        fragments.add(textElement);
        this.addLinkedPosition(rewriter.track((ASTNode)textElement), false, linkedName);
    }

    private TagElement findThrowsTag(FunctionDeclaration decl, Name exception) {
        JSdoc javadoc = decl.getJavadoc();
        if (javadoc != null) {
            String name = ASTNodes.getSimpleNameIdentifier(exception);
            return JavadocTagsSubProcessor.findThrowsTag(javadoc, name);
        }
        return null;
    }

    private TagElement insertThrowsTag(ListRewrite tagRewriter, List exceptions, int currentIndex, TagElement newTagElement) {
        HashSet<String> previousNames = new HashSet<String>();
        int n = 0;
        while (n < currentIndex) {
            Name curr = (Name)exceptions.get(n);
            previousNames.add(ASTNodes.getSimpleNameIdentifier(curr));
            ++n;
        }
        JavadocTagsSubProcessor.insertTag(tagRewriter, newTagElement, previousNames);
        return newTagElement;
    }

    public String getParamNameGroupId(int idx) {
        return "param_name_" + idx;
    }

    public String getParamTypeGroupId(int idx) {
        return "param_type_" + idx;
    }

    public String getExceptionTypeGroupId(int idx) {
        return "exc_type_" + idx;
    }

    public static interface ChangeDescription {
    }

    public static class EditDescription
    extends ModifyDescription {
        String orginalName;

        public EditDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }

    public static class InsertDescription
    extends ModifyDescription {
        public InsertDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }

    static class ModifyDescription
    implements ChangeDescription {
        public final String name;
        public final ITypeBinding type;
        Type resultingParamType;
        SimpleName[] resultingParamName;
        SimpleName resultingTagArg;

        private ModifyDescription(ITypeBinding type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class RemoveDescription
    implements ChangeDescription {
    }

    public static class SwapDescription
    implements ChangeDescription {
        final int index;

        public SwapDescription(int index) {
            this.index = index;
        }
    }
}

