/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.ui.util.DiscoveryUiUtil;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.mylyn.internal.discovery.ui.wizards.PrepareInstallProfileJob;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiscoveryUi {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.discovery.ui";

    private DiscoveryUi() {
    }

    public static boolean install(List<ConnectorDescriptor> descriptors, IRunnableContext context) {
        try {
            final PrepareInstallProfileJob job = new PrepareInstallProfileJob(descriptors);
            context.run(true, true, (IRunnableWithProgress)job);
            if (job.getPlannerResolutionOperation() != null && job.getPlannerResolutionOperation().getProvisioningPlan() != null) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(Policy.getDefault(), job.getProfileId(), job.getIUs(), job.getPlannerResolutionOperation(), new QueryableMetadataRepositoryManager(Policy.getDefault().getQueryContext(), false));
                        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(DiscoveryUiUtil.getShell(), (ProvisioningOperationWizard)wizard);
                        dialog.create();
                        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
                        dialog.open();
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, ID_PLUGIN, NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            DiscoveryUiUtil.logAndDisplayStatus(Messages.ConnectorDiscoveryWizard_cannotInstall, (IStatus)status);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

