/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.ui.util.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class DiscoveryUiUtil {
    private DiscoveryUiUtil() {
    }

    public static void logAndDisplayStatus(String title, IStatus status) {
        DiscoveryUiUtil.logAndDisplayStatus(null, title, status);
    }

    public static void logAndDisplayStatus(Shell shell, String title, IStatus status) {
        StatusHandler.log((IStatus)status);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            if (shell == null) {
                shell = DiscoveryUiUtil.getShell();
            }
            DiscoveryUiUtil.displayStatus(shell, title, status, true);
        }
    }

    public static void displayStatus(String title, IStatus status) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            DiscoveryUiUtil.displayStatus(DiscoveryUiUtil.getShell(), title, status, false);
        } else {
            StatusHandler.log((IStatus)status);
        }
    }

    public static Shell getShell() {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        Shell modal = DiscoveryUiUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return DiscoveryUiUtil.getNonModalShell();
    }

    public static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Shell shell2 = shellArray[n2];
            if (shell2.equals(shell)) break;
            if (shell2.isVisible() && ((style = shell2.getStyle()) & modal) != 0) {
                return shell2;
            }
            ++n2;
        }
        return null;
    }

    public static void displayStatus(Shell shell, String title, IStatus status, boolean showLinkToErrorLog) {
        if (CoreUtil.TEST_MODE) {
            StatusHandler.log((IStatus)status);
            return;
        }
        String message = status.getMessage();
        if (showLinkToErrorLog) {
            message = String.valueOf(message) + Messages.DiscoveryUi_seeErrorLog;
        }
        switch (status.getSeverity()) {
            case 1: 
            case 8: {
                DiscoveryUiUtil.createDialog(shell, title, message, 2).open();
                break;
            }
            case 2: {
                DiscoveryUiUtil.createDialog(shell, title, message, 4).open();
                break;
            }
            default: {
                DiscoveryUiUtil.createDialog(shell, title, message, 1).open();
            }
        }
    }

    public static MessageDialog createDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }
}

