/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class FileTaskScannerRegistryReader {
    private static FileTaskScannerRegistryReader _instance = null;
    private String ATT_CLASS = "class";
    private String ATT_CONTENT_TYPES = "contentTypeIds";
    private String ATT_ID = "id";
    private IConfigurationElement[] fScannerElements;
    private Map fScannerInfos = null;
    private String NAME_SCANNER = "scanner";
    private String SCANNER_EXTENSION_POINT_ID = "org.eclipse.wst.sse.core.taskscanner";

    public static FileTaskScannerRegistryReader getInstance() {
        if (_instance == null) {
            _instance = new FileTaskScannerRegistryReader();
        }
        return _instance;
    }

    private FileTaskScannerRegistryReader() {
    }

    IFileTaskScanner[] getFileTaskScanners(IContentType[] contentTypes) {
        if (this.fScannerElements == null) {
            this.readRegistry();
        }
        ArrayList<ScannerInfo> scannerInfos = new ArrayList<ScannerInfo>(1);
        int i = 0;
        while (i < contentTypes.length) {
            ScannerInfo[] scannerInfosForContentType = (ScannerInfo[])this.fScannerInfos.get(contentTypes[i].getId());
            if (scannerInfosForContentType == null) {
                scannerInfosForContentType = this.loadScanners(contentTypes[i]);
            }
            int j = 0;
            while (j < scannerInfosForContentType.length) {
                if (!scannerInfos.contains(scannerInfosForContentType[j])) {
                    scannerInfos.add(scannerInfosForContentType[j]);
                }
                ++j;
            }
            ++i;
        }
        IFileTaskScanner[] scanners = new IFileTaskScanner[scannerInfos.size()];
        int i2 = 0;
        while (i2 < scanners.length) {
            scanners[i2] = ((ScannerInfo)scannerInfos.get(i2)).getScanner();
            ++i2;
        }
        return scanners;
    }

    public String[] getSupportedContentTypeIds() {
        if (this.fScannerElements == null) {
            this.readRegistry();
        }
        ArrayList<String> types = new ArrayList<String>(0);
        IConfigurationElement[] scannerElements = this.fScannerElements;
        int j = 0;
        while (j < scannerElements.length) {
            if (scannerElements[j].getName().equals(this.NAME_SCANNER)) {
                String[] contentTypeIds = StringUtils.unpack(scannerElements[j].getAttribute(this.ATT_CONTENT_TYPES));
                int i = 0;
                while (i < contentTypeIds.length) {
                    if (!types.contains(contentTypeIds[i])) {
                        types.add(contentTypeIds[i]);
                    }
                    ++i;
                }
            }
            ++j;
        }
        return types.toArray(new String[types.size()]);
    }

    private ScannerInfo[] loadScanners(IContentType contentType) {
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(0);
        ScannerInfo[] scannerInfos = null;
        IConfigurationElement[] delegateElements = this.fScannerElements;
        if (contentType != null) {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            int j = 0;
            while (j < delegateElements.length) {
                if (delegateElements[j].getName().equals(this.NAME_SCANNER)) {
                    String[] supportedContentTypeIds = StringUtils.unpack(delegateElements[j].getAttribute(this.ATT_CONTENT_TYPES));
                    IContentType[] supportedContentTypes = new IContentType[supportedContentTypeIds.length];
                    int k = 0;
                    while (k < supportedContentTypeIds.length) {
                        supportedContentTypes[k] = contentTypeManager.getContentType(supportedContentTypeIds[k].trim());
                        ++k;
                    }
                    k = 0;
                    while (k < supportedContentTypeIds.length) {
                        if (supportedContentTypes[k] != null && contentType.isKindOf(supportedContentTypes[k])) {
                            elements.add(delegateElements[j]);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ArrayList<ScannerInfo> scannerInfoList = new ArrayList<ScannerInfo>(elements.size());
            int i = 0;
            while (i < elements.size()) {
                try {
                    IFileTaskScanner scanner = (IFileTaskScanner)((IConfigurationElement)elements.get(i)).createExecutableExtension(this.ATT_CLASS);
                    if (scanner != null) {
                        scannerInfoList.add(new ScannerInfo(((IConfigurationElement)elements.get(i)).getAttribute(this.ATT_ID), scanner));
                    }
                }
                catch (CoreException e) {
                    Logger.logException("Non-fatal exception creating task scanner for " + contentType.getId(), e);
                }
                ++i;
            }
            scannerInfos = scannerInfoList.toArray(new ScannerInfo[scannerInfoList.size()]);
            this.fScannerInfos.put(contentType.getId(), scannerInfos);
            if (Logger.DEBUG_TASKSREGISTRY) {
                System.out.println("Created " + scannerInfos.length + " task scanner for " + contentType.getId());
            }
        }
        return scannerInfos;
    }

    private void readRegistry() {
        this.fScannerInfos = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.SCANNER_EXTENSION_POINT_ID);
        if (point != null) {
            this.fScannerElements = point.getConfigurationElements();
        }
    }

    private class ScannerInfo {
        String fId;
        IFileTaskScanner fScanner;

        ScannerInfo(String id, IFileTaskScanner scanner) {
            this.fId = id;
            this.fScanner = scanner;
        }

        public boolean equals(Object obj) {
            return obj instanceof ScannerInfo && this.fId.equals(((ScannerInfo)obj).fId);
        }

        public IFileTaskScanner getScanner() {
            return this.fScanner;
        }
    }
}

