/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASABaseCatalog;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.SybaseASABaseDatabaseLoader;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalog;
import org.eclipse.datatools.enablement.sybase.asa.loaders.SybaseASADatabaseLoader;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EncryptionInfo;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.JavaSupportType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.impl.SybaseASADatabaseImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogDatabase
extends SybaseASADatabaseImpl
implements ICatalogObject,
IAdaptable,
SybaseASABaseCatalog.ISybaseASABaseCatalogDatabase {
    private static final long serialVersionUID = 3257562914901669687L;
    protected Connection connection = null;
    protected String dbName = null;
    protected Boolean schemasLoaded = Boolean.FALSE;
    protected Boolean webServicesLoaded = Boolean.FALSE;
    protected Boolean dataTypesLoaded = Boolean.FALSE;
    protected Boolean eventsLoaded = Boolean.FALSE;
    protected Boolean authIdsLoaded = Boolean.FALSE;
    protected Boolean dbspacesLoaded = Boolean.FALSE;
    protected Boolean dbInfo1Loaded = Boolean.FALSE;
    protected Boolean dbInfo2Loaded = Boolean.FALSE;
    protected Boolean catalogsLoaded = Boolean.FALSE;
    private SoftReference databaseLoaderRef = null;

    public SybaseASACatalogDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
        try {
            this.dbName = this.connection.getCatalog();
            this.setName(this.dbName);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    public SybaseASACatalogDatabase() {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (this.schemasLoaded.booleanValue()) {
                this.schemasLoaded = Boolean.FALSE;
            }
        }
        bl = this.webServicesLoaded;
        synchronized (bl) {
            if (this.webServicesLoaded.booleanValue()) {
                this.webServicesLoaded = Boolean.FALSE;
            }
        }
        bl = this.dataTypesLoaded;
        synchronized (bl) {
            if (this.dataTypesLoaded.booleanValue()) {
                this.dataTypesLoaded = Boolean.FALSE;
            }
        }
        bl = this.eventsLoaded;
        synchronized (bl) {
            if (this.eventsLoaded.booleanValue()) {
                this.eventsLoaded = Boolean.FALSE;
            }
        }
        bl = this.authIdsLoaded;
        synchronized (bl) {
            if (this.authIdsLoaded.booleanValue()) {
                this.authIdsLoaded = Boolean.FALSE;
            }
        }
        bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (this.dbInfo1Loaded.booleanValue()) {
                this.dbInfo1Loaded = Boolean.FALSE;
            }
        }
        bl = this.dbInfo2Loaded;
        synchronized (bl) {
            if (this.dbInfo2Loaded.booleanValue()) {
                this.dbInfo2Loaded = Boolean.FALSE;
            }
        }
        bl = this.dbspacesLoaded;
        synchronized (bl) {
            if (this.dbspacesLoaded.booleanValue()) {
                this.dbspacesLoaded = Boolean.FALSE;
            }
        }
        bl = this.catalogsLoaded;
        synchronized (bl) {
            if (this.catalogsLoaded.booleanValue()) {
                this.catalogsLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEvent() {
        Boolean bl = this.eventsLoaded;
        synchronized (bl) {
            if (this.eventsLoaded.booleanValue()) {
                this.eventsLoaded = Boolean.FALSE;
            }
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 9: {
                this.getSchemas();
                break;
            }
            case 14: {
                this.getWebServices();
                break;
            }
            case 10: {
                this.getEvents();
                break;
            }
            case 13: {
                this.getDataTypes();
                break;
            }
            case 12: {
                this.getAuthorizationIds();
                break;
            }
            case 15: {
                this.getDbSpaces();
                break;
            }
            case 16: {
                this.getDatabaseFileName();
                break;
            }
            case 17: {
                this.getLogFileName();
                break;
            }
            case 18: {
                this.getMirrorFileName();
                break;
            }
            case 19: {
                this.isCaseSensitive();
                break;
            }
            case 20: {
                this.getCollation();
                break;
            }
            case 21: {
                this.isBlankPaddingOn();
                break;
            }
            case 22: {
                this.isCheckSumOn();
                break;
            }
            case 23: {
                this.isJConnectOn();
                break;
            }
            case 24: {
                this.getPageSize();
                break;
            }
            case 25: {
                this.getEncryptionInfo();
                break;
            }
            case 28: {
                this.isASECompatible();
                break;
            }
            case 11: {
                this.getCatalogs();
                break;
            }
            case 27: {
                this.getPasswordCaseSensitive();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getCatalogs() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (!this.catalogsLoaded.booleanValue()) {
                EList catalogs = super.getCatalogs();
                if (catalogs.size() > 0) {
                    SybaseASACatalog catalog = (SybaseASACatalog)((Object)catalogs.get(0));
                    catalog.refresh();
                } else {
                    SybaseASACatalog catalog = new SybaseASACatalog();
                    catalog.setName(this.dbName);
                    catalogs.add((Object)catalog);
                }
                this.catalogsLoaded = Boolean.TRUE;
            }
        }
        return super.getCatalogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getWebServices() {
        Boolean bl = this.webServicesLoaded;
        synchronized (bl) {
            if (!this.webServicesLoaded.booleanValue()) {
                this.getDatabaseLoader().loadWebServices(super.getWebServices());
                this.webServicesLoaded = Boolean.TRUE;
            }
        }
        return super.getWebServices();
    }

    public EList getSchemas() {
        Catalog catalog = (Catalog)this.getCatalogs().get(0);
        catalog.getSchemas();
        return super.getSchemas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getDataTypes() {
        Boolean bl = this.dataTypesLoaded;
        synchronized (bl) {
            if (!this.dataTypesLoaded.booleanValue()) {
                this.getDatabaseLoader().loadDataTypes(super.getDataTypes());
                this.dataTypesLoaded = Boolean.TRUE;
            }
        }
        return super.getDataTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getEvents() {
        Boolean bl = this.eventsLoaded;
        synchronized (bl) {
            if (!this.eventsLoaded.booleanValue()) {
                this.getDatabaseLoader().loadEvents(super.getEvents());
                this.eventsLoaded = Boolean.TRUE;
            }
        }
        return super.getEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getAuthorizationIds() {
        Boolean bl = this.authIdsLoaded;
        synchronized (bl) {
            if (!this.authIdsLoaded.booleanValue()) {
                this.getDatabaseLoader().loadAuthIds(super.getAuthorizationIds());
                this.authIdsLoaded = Boolean.TRUE;
            }
        }
        return super.getAuthorizationIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getDbSpaces() {
        Boolean bl = this.dbspacesLoaded;
        synchronized (bl) {
            if (!this.dbspacesLoaded.booleanValue()) {
                this.getDatabaseLoader().loadDbSpaces(super.getDbSpaces());
                this.dbspacesLoaded = Boolean.TRUE;
            }
        }
        return super.getDbSpaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogFileName() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getLogFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseFileName() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getDatabaseFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMirrorFileName() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getMirrorFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCaseSensitive() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.isCaseSensitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageSize() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getPageSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCollation() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getCollation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlankPaddingOn() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.isBlankPaddingOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJConnectOn() {
        Boolean bl = this.dbInfo2Loaded;
        synchronized (bl) {
            if (!this.dbInfo2Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo2();
                this.dbInfo2Loaded = Boolean.TRUE;
            }
        }
        return super.isJConnectOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckSumOn() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.isCheckSumOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSupportType getJavaSupport() {
        Boolean bl = this.dbInfo2Loaded;
        synchronized (bl) {
            if (!this.dbInfo2Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo2();
                this.dbInfo2Loaded = Boolean.TRUE;
            }
        }
        return super.getJavaSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getPasswordCaseSensitive() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getPasswordCaseSensitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptionInfo getEncryptionInfo() {
        Boolean bl = this.dbInfo1Loaded;
        synchronized (bl) {
            if (!this.dbInfo1Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo1();
                this.dbInfo1Loaded = Boolean.TRUE;
            }
        }
        return super.getEncryptionInfo();
    }

    protected SybaseASABaseDatabaseLoader getDatabaseLoader() {
        SybaseASABaseDatabaseLoader loader;
        SybaseASABaseDatabaseLoader sybaseASABaseDatabaseLoader = loader = this.databaseLoaderRef == null ? null : (SybaseASABaseDatabaseLoader)this.databaseLoaderRef.get();
        if (loader == null) {
            loader = this.createDatabaseLoader();
            this.databaseLoaderRef = new SoftReference<SybaseASABaseDatabaseLoader>(loader);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isASECompatible() {
        Boolean bl = this.dbInfo2Loaded;
        synchronized (bl) {
            if (!this.dbInfo2Loaded.booleanValue()) {
                this.getDatabaseLoader().loadDbInfo2();
                this.dbInfo2Loaded = Boolean.TRUE;
            }
        }
        return super.isASECompatible();
    }

    protected SybaseASABaseDatabaseLoader createDatabaseLoader() {
        return new SybaseASADatabaseLoader(this);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

