/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaConversionValue
extends AbstractJavaJpaContextNode
implements ConversionValue {
    private ConversionValueAnnotation resourceConversionValue;
    private String dataValue;
    private String objectValue;

    public EclipseLinkJavaConversionValue(EclipseLinkJavaObjectTypeConverter parent) {
        super((JpaContextNode)parent);
    }

    @Override
    public EclipseLinkJavaObjectTypeConverter getParent() {
        return (EclipseLinkJavaObjectTypeConverter)super.getParent();
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ConversionValue";
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceConversionValue.getTextRange(astRoot);
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String newDataValue) {
        String oldDataValue = this.dataValue;
        this.dataValue = newDataValue;
        this.resourceConversionValue.setDataValue(newDataValue);
        this.firePropertyChanged("dataValue", oldDataValue, newDataValue);
    }

    protected void setDataValue_(String newDataValue) {
        String oldDataValue = this.dataValue;
        this.dataValue = newDataValue;
        this.firePropertyChanged("dataValue", oldDataValue, newDataValue);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String newObjectValue) {
        String oldObjectValue = this.objectValue;
        this.objectValue = newObjectValue;
        this.resourceConversionValue.setObjectValue(newObjectValue);
        this.firePropertyChanged("objectValue", oldObjectValue, newObjectValue);
    }

    protected void setObjectValue_(String newObjectValue) {
        String oldObjectValue = this.objectValue;
        this.objectValue = newObjectValue;
        this.firePropertyChanged("objectValue", oldObjectValue, newObjectValue);
    }

    public void initialize(ConversionValueAnnotation resourceConversionValue) {
        this.resourceConversionValue = resourceConversionValue;
        this.dataValue = this.dataValue();
        this.objectValue = this.objectValue();
    }

    public void update(ConversionValueAnnotation resourceConversionValue) {
        this.resourceConversionValue = resourceConversionValue;
        this.setDataValue_(this.dataValue());
        this.setObjectValue_(this.objectValue());
    }

    protected String dataValue() {
        return this.resourceConversionValue.getDataValue();
    }

    protected String objectValue() {
        return this.resourceConversionValue.getObjectValue();
    }

    public TextRange getDataValueTextRange(CompilationUnit astRoot) {
        return this.resourceConversionValue.getDataValueTextRange(astRoot);
    }

    public TextRange getObjectValueTextRange(CompilationUnit astRoot) {
        return this.resourceConversionValue.getObjectValueTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateDataValuesUnique(messages, astRoot);
    }

    protected void validateDataValuesUnique(List<IMessage> messages, CompilationUnit astRoot) {
        ArrayList dataValues = CollectionTools.list(this.getParent().dataValues());
        dataValues.remove(this.dataValue);
        if (dataValues.contains(this.dataValue)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE", new String[]{this.dataValue}, this, this.getDataValueTextRange(astRoot)));
        }
    }
}

