/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.Customizer;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.EclipseLinkJpaFactory;
import org.eclipse.jpt.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaCustomizer
extends AbstractJavaJpaContextNode
implements Customizer {
    private JavaResourcePersistentType resourcePersistentType;
    private String customizerClass;

    public EclipseLinkJavaCustomizer(JavaJpaContextNode parent) {
        super((JpaContextNode)parent);
    }

    @Override
    public char getCustomizerClassEnclosingTypeSeparator() {
        return '.';
    }

    protected EclipseLinkJpaFactory getJpaFactory() {
        return (EclipseLinkJpaFactory)super.getJpaFactory();
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    protected void addResourceCustomizer() {
        this.resourcePersistentType.addSupportingAnnotation(this.getAnnotationName());
    }

    protected void removeResourceCustomizer() {
        this.resourcePersistentType.removeSupportingAnnotation(this.getAnnotationName());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceCustomizer().getTextRange(astRoot);
    }

    protected CustomizerAnnotation getResourceCustomizer() {
        return (CustomizerAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getAnnotationName());
    }

    @Override
    public String getCustomizerClass() {
        return this.getSpecifiedCustomizerClass();
    }

    @Override
    public String getDefaultCustomizerClass() {
        return null;
    }

    @Override
    public String getSpecifiedCustomizerClass() {
        return this.customizerClass;
    }

    @Override
    public void setSpecifiedCustomizerClass(String newCustomizerClass) {
        if (this.attributeValueHasNotChanged(this.customizerClass, newCustomizerClass)) {
            return;
        }
        String oldCustomizerClass = this.customizerClass;
        this.customizerClass = newCustomizerClass;
        if (this.customizerClass != null) {
            this.addResourceCustomizer();
        } else {
            this.removeResourceCustomizer();
        }
        if (newCustomizerClass != null) {
            this.getResourceCustomizer().setValue(newCustomizerClass);
        }
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    protected void setCustomizerClass_(String newCustomizerClass) {
        String oldCustomizerClass = this.customizerClass;
        this.customizerClass = newCustomizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    public void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        CustomizerAnnotation resourceCustomizer = this.getResourceCustomizer();
        this.customizerClass = this.customizerClass(resourceCustomizer);
    }

    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        CustomizerAnnotation resourceCustomizer = this.getResourceCustomizer();
        this.setCustomizerClass_(this.customizerClass(resourceCustomizer));
    }

    protected String customizerClass(CustomizerAnnotation resourceCustomizer) {
        return resourceCustomizer == null ? null : resourceCustomizer.getValue();
    }

    public TextRange getCustomizerClassTextRange(CompilationUnit astRoot) {
        return this.getResourceCustomizer().getValueTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConverterClass(messages, astRoot);
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        CustomizerAnnotation resourceCustomizer = this.getResourceCustomizer();
        if (resourceCustomizer != null && !resourceCustomizer.customizerClassImplementsInterface("org.eclipse.persistence.config.DescriptorCustomizer", astRoot)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CUSTOMIZER_CLASS_IMPLEMENTS_DESCRIPTOR_CUSTOMIZER", new String[]{this.customizerClass}, this, this.getCustomizerClassTextRange(astRoot)));
        }
    }
}

