/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.DdlGenerationType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.OutputMode;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.SchemaGeneration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkSchemaGeneration
extends EclipseLinkPersistenceUnitProperties
implements SchemaGeneration {
    private OutputMode outputMode;
    private DdlGenerationType ddlGenerationType;
    private String createFileName;
    private String dropFileName;
    private String applicationLocation;

    public EclipseLinkSchemaGeneration(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void initializeProperties() {
        this.outputMode = (OutputMode)this.getEnumValue("eclipselink.ddl-generation.output-mode", OutputMode.values());
        this.ddlGenerationType = (DdlGenerationType)this.getEnumValue("eclipselink.ddl-generation", DdlGenerationType.values());
        this.createFileName = this.getStringValue("eclipselink.create-ddl-jdbc-file-name");
        this.dropFileName = this.getStringValue("eclipselink.drop-ddl-jdbc-file-name");
        this.applicationLocation = this.getStringValue("eclipselink.application-location");
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.ddl-generation.output-mode", "outputMode");
        propertyNames.put("eclipselink.ddl-generation", "ddlGenerationType");
        propertyNames.put("eclipselink.create-ddl-jdbc-file-name", "createFileName");
        propertyNames.put("eclipselink.drop-ddl-jdbc-file-name", "dropFileName");
        propertyNames.put("eclipselink.application-location", "applicationLocation");
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.ddl-generation.output-mode")) {
            this.outputModeChanged(newValue);
        } else if (propertyName.equals("eclipselink.ddl-generation")) {
            this.ddlGenerationTypeChanged(newValue);
        } else if (propertyName.equals("eclipselink.create-ddl-jdbc-file-name")) {
            this.createFileNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.drop-ddl-jdbc-file-name")) {
            this.dropFileNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.application-location")) {
            this.applicationLocationChanged(newValue);
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.ddl-generation.output-mode")) {
            this.outputModeChanged(null);
        } else if (propertyName.equals("eclipselink.ddl-generation")) {
            this.ddlGenerationTypeChanged(null);
        } else if (propertyName.equals("eclipselink.create-ddl-jdbc-file-name")) {
            this.createFileNameChanged(null);
        } else if (propertyName.equals("eclipselink.drop-ddl-jdbc-file-name")) {
            this.dropFileNameChanged(null);
        } else if (propertyName.equals("eclipselink.application-location")) {
            this.applicationLocationChanged(null);
        }
    }

    @Override
    public DdlGenerationType getDdlGenerationType() {
        return this.ddlGenerationType;
    }

    @Override
    public void setDdlGenerationType(DdlGenerationType newDdlGenType) {
        DdlGenerationType old = this.ddlGenerationType;
        this.ddlGenerationType = newDdlGenType;
        this.putProperty("ddlGenerationType", (Object)newDdlGenType);
        this.firePropertyChanged("ddlGenerationType", (Object)old, (Object)newDdlGenType);
    }

    private void ddlGenerationTypeChanged(String stringValue) {
        DdlGenerationType newValue = (DdlGenerationType)EclipseLinkSchemaGeneration.getEnumValueOf((String)stringValue, (Enum[])DdlGenerationType.values());
        DdlGenerationType old = this.ddlGenerationType;
        this.ddlGenerationType = newValue;
        this.firePropertyChanged("ddlGenerationType", (Object)old, (Object)newValue);
    }

    @Override
    public DdlGenerationType getDefaultDdlGenerationType() {
        return DEFAULT_SCHEMA_GENERATION_DDL_GENERATION_TYPE;
    }

    @Override
    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    @Override
    public void setOutputMode(OutputMode newOutputMode) {
        OutputMode old = this.outputMode;
        this.outputMode = newOutputMode;
        this.putProperty("outputMode", (Object)newOutputMode);
        this.firePropertyChanged("outputMode", (Object)old, (Object)newOutputMode);
    }

    private void outputModeChanged(String stringValue) {
        OutputMode newValue = (OutputMode)EclipseLinkSchemaGeneration.getEnumValueOf((String)stringValue, (Enum[])OutputMode.values());
        OutputMode old = this.outputMode;
        this.outputMode = newValue;
        this.firePropertyChanged("outputMode", (Object)old, (Object)newValue);
    }

    @Override
    public OutputMode getDefaultOutputMode() {
        return DEFAULT_SCHEMA_GENERATION_OUTPUT_MODE;
    }

    @Override
    public String getCreateFileName() {
        return this.createFileName;
    }

    @Override
    public void setCreateFileName(String newCreateFileName) {
        String old = this.createFileName;
        this.createFileName = newCreateFileName;
        this.putProperty("createFileName", newCreateFileName);
        this.firePropertyChanged("createFileName", old, newCreateFileName);
    }

    private void createFileNameChanged(String newValue) {
        String old = this.createFileName;
        this.createFileName = newValue;
        this.firePropertyChanged("createFileName", old, newValue);
    }

    @Override
    public String getDefaultCreateFileName() {
        return "createDDL.jdbc";
    }

    @Override
    public String getDropFileName() {
        return this.dropFileName;
    }

    @Override
    public void setDropFileName(String newDropFileName) {
        String old = this.dropFileName;
        this.dropFileName = newDropFileName;
        this.putProperty("dropFileName", newDropFileName);
        this.firePropertyChanged("dropFileName", old, newDropFileName);
    }

    private void dropFileNameChanged(String newValue) {
        String old = this.dropFileName;
        this.dropFileName = newValue;
        this.firePropertyChanged("dropFileName", old, newValue);
    }

    @Override
    public String getDefaultDropFileName() {
        return "dropDDL.jdbc";
    }

    @Override
    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    @Override
    public void setApplicationLocation(String newApplicationLocation) {
        String old = this.applicationLocation;
        this.applicationLocation = newApplicationLocation;
        this.putProperty("applicationLocation", newApplicationLocation);
        this.firePropertyChanged("applicationLocation", old, newApplicationLocation);
    }

    private void applicationLocationChanged(String newValue) {
        String old = this.applicationLocation;
        this.applicationLocation = newValue;
        this.firePropertyChanged("applicationLocation", old, newValue);
    }

    @Override
    public String getDefaultApplicationLocation() {
        return ".";
    }
}

