/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.commons.ui.SwtUtil;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.editors.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvisibleContextElementsPart {
    private TableViewer invisibleTable;
    private Section invisibleSection;
    private CommonViewer commonViewer;

    public InvisibleContextElementsPart(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
    }

    public Control createControl(FormToolkit toolkit, Composite composite) {
        Collection<Object> allVisible;
        this.invisibleSection = toolkit.createSection(composite, 258);
        this.invisibleSection.setText(NLS.bind((String)Messages.InvisibleContextElementsPart_Invisible_elements, (Object)"0"));
        this.invisibleSection.setEnabled(false);
        Composite toolbarComposite = toolkit.createComposite((Composite)this.invisibleSection);
        toolbarComposite.setBackground(null);
        this.invisibleSection.setTextClient((Control)toolbarComposite);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        toolbarComposite.setLayout((Layout)rowLayout);
        ToolBarManager toolbarManager = new ToolBarManager(0x800000);
        toolbarManager.add((IAction)new RemoveInvisibleAction());
        toolbarManager.createControl(toolbarComposite);
        toolbarManager.markDirty();
        toolbarManager.update(true);
        Composite invisibleSectionClient = toolkit.createComposite((Composite)this.invisibleSection);
        invisibleSectionClient.setLayout((Layout)new GridLayout());
        this.invisibleSection.setClient((Control)invisibleSectionClient);
        Composite tableComposite = toolkit.createComposite(invisibleSectionClient);
        GridDataFactory.fillDefaults().hint(450, 200).grab(true, false).applyTo((Control)tableComposite);
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        this.invisibleTable = new TableViewer(tableComposite, 101122);
        this.invisibleTable.setColumnProperties(new String[]{Messages.InvisibleContextElementsPart_Structure_handle, Messages.InvisibleContextElementsPart_Structure_kind});
        this.invisibleTable.getTable().setHeaderVisible(true);
        Table table = this.invisibleTable.getTable();
        toolkit.adapt((Composite)table);
        table.setMenu(null);
        InteractionElementTableLabelProvider labelProvider = new InteractionElementTableLabelProvider();
        this.invisibleTable.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.invisibleTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        InteractionElementTableSorter invisibleTableSorter = new InteractionElementTableSorter(labelProvider);
        invisibleTableSorter.setCriteria(0);
        this.invisibleTable.setSorter((ViewerSorter)invisibleTableSorter);
        this.createColumn(layout, 0, Messages.InvisibleContextElementsPart_Structure_handle, 340, table, invisibleTableSorter);
        this.createColumn(layout, 1, Messages.InvisibleContextElementsPart_Structure_kind, 100, table, invisibleTableSorter);
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(1024);
        if (ContextCore.getContextManager().isContextActive() && (allVisible = this.getAllVisibleElementsInContextPage()) != null) {
            IInteractionContext context = ContextCore.getContextManager().getActiveContext();
            this.updateInvisibleSectionInBackground(context, allVisible);
        }
        return this.invisibleSection;
    }

    private void createColumn(TableColumnLayout layout, final int index, String label, int weight, final Table table, final InteractionElementTableSorter invisibleTableSorter) {
        final TableColumn column = new TableColumn(table, 16384, index);
        column.setText(label);
        column.setToolTipText(label);
        column.setResizable(true);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(weight, true));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                invisibleTableSorter.setCriteria(index);
                table.setSortColumn(column);
                if (invisibleTableSorter.isDecending()) {
                    table.setSortDirection(128);
                } else {
                    table.setSortDirection(1024);
                }
                InvisibleContextElementsPart.this.invisibleTable.refresh();
            }
        });
    }

    public void updateInvisibleElementsSection() {
        if (ContextCore.getContextManager().isContextActive()) {
            Collection<Object> allVisible = this.getAllVisibleElementsInContextPage();
            if (allVisible != null) {
                IInteractionContext context = ContextCore.getContextManager().getActiveContext();
                this.updateInvisibleSectionInBackground(context, allVisible);
            }
        } else {
            this.updateInvisibleSectionInBackground(null, null);
        }
    }

    private void updateInvisibleSectionInBackground(final IInteractionContext context, final Collection<Object> allVisible) {
        Job j = new Job(Messages.InvisibleContextElementsPart_Updating_invisible_element_list){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.InvisibleContextElementsPart_Computing_invisible_elements, -1);
                final List allInvisibleElements = InvisibleContextElementsPart.this.getAllInvisibleElements(context, allVisible);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (InvisibleContextElementsPart.this.invisibleSection != null && !InvisibleContextElementsPart.this.invisibleSection.isDisposed()) {
                            InvisibleContextElementsPart.this.invisibleSection.setText(NLS.bind((String)Messages.InvisibleContextElementsPart_Invisible_elements, (Object)allInvisibleElements.size()));
                            InvisibleContextElementsPart.this.invisibleSection.layout();
                            if (allInvisibleElements.size() == 0) {
                                InvisibleContextElementsPart.this.invisibleSection.setExpanded(false);
                                InvisibleContextElementsPart.this.invisibleSection.setEnabled(false);
                            } else {
                                InvisibleContextElementsPart.this.invisibleSection.setEnabled(true);
                            }
                        }
                        if (InvisibleContextElementsPart.this.invisibleTable != null && !InvisibleContextElementsPart.this.invisibleTable.getTable().isDisposed()) {
                            InvisibleContextElementsPart.this.invisibleTable.setInput((Object)allInvisibleElements);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    private List<IInteractionElement> getAllInvisibleElements(IInteractionContext context, Collection<Object> allVisible) {
        if (context == null || allVisible == null) {
            return Collections.emptyList();
        }
        List allToRemove = context.getAllElements();
        ArrayList<IInteractionElement> allVisibleElements = new ArrayList<IInteractionElement>();
        for (Object visibleObject : allVisible) {
            IInteractionElement element;
            String handle;
            AbstractContextStructureBridge bridge2;
            for (AbstractContextStructureBridge bridge2 : ContextCorePlugin.getDefault().getStructureBridges().values()) {
                IInteractionElement element2;
                String handle2;
                if (bridge2 == null || (handle2 = bridge2.getHandleIdentifier(visibleObject)) == null || (element2 = context.get(handle2)) == null) continue;
                allVisibleElements.add(element2);
            }
            bridge2 = ContextCorePlugin.getDefault().getStructureBridge("resource");
            if (bridge2 == null || (handle = bridge2.getHandleIdentifier(visibleObject)) == null || (element = context.get(handle)) == null) continue;
            allVisibleElements.add(element);
        }
        IInteractionElement emptyElement = context.get("");
        if (emptyElement != null) {
            allVisibleElements.add(emptyElement);
        }
        allToRemove.removeAll(allVisibleElements);
        return allToRemove;
    }

    private Collection<Object> getAllVisibleElementsInContextPage() {
        if (this.commonViewer == null || this.commonViewer.getTree() == null || this.commonViewer.getTree().isDisposed()) {
            return null;
        }
        HashSet<Object> allVisible = new HashSet<Object>();
        SwtUtil.collectItemData((TreeItem[])this.commonViewer.getTree().getItems(), allVisible);
        return allVisible;
    }

    protected void setCommonViewer(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
        this.updateInvisibleElementsSection();
    }

    private final class InteractionElementTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private InteractionElementTableLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IInteractionElement) {
                return ((IInteractionElement)element).getHandleIdentifier();
            }
            return super.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IInteractionElement) {
                if (columnIndex == 0) {
                    return ((IInteractionElement)element).getHandleIdentifier();
                }
                if (columnIndex == 1) {
                    return ((IInteractionElement)element).getContentType();
                }
            }
            return "";
        }
    }

    private final class InteractionElementTableSorter
    extends ViewerSorter {
        private int criteria = 0;
        private boolean isDecending = true;
        private final ITableLabelProvider labelProvider;

        public InteractionElementTableSorter(ITableLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            String value1 = this.labelProvider.getColumnText(e1, this.criteria);
            String value2 = this.labelProvider.getColumnText(e2, this.criteria);
            if (value1 == null && value2 != null) {
                result = -1;
            } else if (value1 != null && value2 == null) {
                result = 1;
            } else if (value1 != null && value2 != null) {
                result = value1.compareTo(value2);
            }
            return this.isDecending() ? result * -1 : result;
        }

        public boolean isDecending() {
            return this.isDecending;
        }

        public void setCriteria(int index) {
            this.isDecending = this.criteria == index ? !this.isDecending : false;
            this.criteria = index;
        }
    }

    private final class RemoveInvisibleAction
    extends Action {
        public RemoveInvisibleAction() {
            this.setText(Messages.ContextEditorFormPage_Remove_Invisible_);
            this.setToolTipText(Messages.ContextEditorFormPage_Remove_Invisible_);
            this.setImageDescriptor(TasksUiImages.CONTEXT_CLEAR);
        }

        public void run() {
            if (InvisibleContextElementsPart.this.commonViewer == null) {
                MessageDialog.openWarning((Shell)WorkbenchUtil.getShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_Activate_task_to_remove_invisible);
                return;
            }
            boolean confirmed = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_Remove_every_element_not_visible);
            if (confirmed) {
                if (ContextCore.getContextManager().isContextActive()) {
                    try {
                        final Collection allVisible = InvisibleContextElementsPart.this.getAllVisibleElementsInContextPage();
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.InvisibleContextElementsPart_Collecting_all_invisible, -1);
                                if (allVisible != null) {
                                    IInteractionContext context = ContextCore.getContextManager().getActiveContext();
                                    final List allToRemove = InvisibleContextElementsPart.this.getAllInvisibleElements(context, allVisible);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        public void run() {
                                            ContextCore.getContextManager().deleteElements((Collection)allToRemove);
                                        }
                                    });
                                } else {
                                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_No_context_active);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", e.getMessage(), (Throwable)e));
                    }
                    catch (InterruptedException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", e.getMessage(), (Throwable)e));
                    }
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_No_context_active);
                }
            }
        }
    }
}

