/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProviderTarget;
import org.eclipse.debug.internal.ui.viewers.model.LabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class TreeModelLabelProvider
extends ColumnLabelProvider
implements ITreeModelLabelProvider {
    private ITreeModelLabelProviderTarget fViewer;
    private List fComplete;
    private Map fImageCache = new HashMap();
    private Map fFontCache = new HashMap();
    private Map fColorCache = new HashMap();
    private ListenerList fLabelListeners = new ListenerList();
    private Map fPendingUpdates = new HashMap();
    private UIJob fPendingUpdatesJob;
    private List fUpdatesInProgress = new ArrayList();

    public TreeModelLabelProvider(ITreeModelLabelProviderTarget viewer) {
        this.fViewer = viewer;
    }

    public Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.fImageCache.get(descriptor);
        if (image == null) {
            image = new Image((Device)this.getDisplay(), descriptor.getImageData());
            this.fImageCache.put(descriptor, image);
        }
        return image;
    }

    private Display getDisplay() {
        return this.fViewer.getDisplay();
    }

    public Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        Font font = (Font)this.fFontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)this.getDisplay(), fontData);
            this.fFontCache.put(fontData, font);
        }
        return font;
    }

    public Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = (Color)this.fColorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getDisplay(), rgb);
            this.fColorCache.put(rgb, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.fUpdatesInProgress;
        synchronized (object) {
            Iterator updatesInProgress = this.fUpdatesInProgress.iterator();
            while (updatesInProgress.hasNext()) {
                ILabelUpdate currentUpdate = (ILabelUpdate)updatesInProgress.next();
                currentUpdate.cancel();
            }
        }
        object = this;
        synchronized (object) {
            if (this.fPendingUpdatesJob != null) {
                this.fPendingUpdatesJob.cancel();
                this.fPendingUpdatesJob = null;
            }
        }
        Iterator images = this.fImageCache.values().iterator();
        while (images.hasNext()) {
            Image image = (Image)images.next();
            image.dispose();
        }
        this.fImageCache.clear();
        Iterator fonts = this.fFontCache.values().iterator();
        while (fonts.hasNext()) {
            Font font = (Font)fonts.next();
            font.dispose();
        }
        this.fFontCache.clear();
        Iterator colors = this.fColorCache.values().iterator();
        while (colors.hasNext()) {
            Color color = (Color)colors.next();
            color.dispose();
        }
        this.fColorCache.clear();
        super.dispose();
    }

    public synchronized void update(ViewerCell cell) {
    }

    public synchronized boolean update(TreePath elementPath) {
        String[] visibleColumns = this.fViewer.getVisibleColumns();
        Object element = elementPath.getLastSegment();
        IElementLabelProvider presentation = ViewerAdapterService.getLabelProvider(element);
        if (presentation != null) {
            LinkedList<LabelUpdate> updates = (LinkedList<LabelUpdate>)this.fPendingUpdates.get(presentation);
            if (updates == null) {
                updates = new LinkedList<LabelUpdate>();
                this.fPendingUpdates.put(presentation, updates);
            }
            updates.add(new LabelUpdate(this.fViewer.getInput(), elementPath, this, this.fViewer, visibleColumns, this.fViewer.getPresentationContext()));
            if (this.fPendingUpdatesJob != null) {
                this.fPendingUpdatesJob.cancel();
            }
            this.fPendingUpdatesJob = new UIJob(this.fViewer.getDisplay(), "Schedule Pending Label Updates"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeModelLabelProvider.this.startRequests(this);
                    return Status.OK_STATUS;
                }
            };
            this.fPendingUpdatesJob.setSystem(true);
            this.fPendingUpdatesJob.schedule();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRequests(UIJob updateJob) {
        Map updates = null;
        TreeModelLabelProvider treeModelLabelProvider = this;
        synchronized (treeModelLabelProvider) {
            if (updateJob == this.fPendingUpdatesJob) {
                updates = this.fPendingUpdates;
                this.fPendingUpdates = new HashMap();
                this.fPendingUpdatesJob = null;
            }
        }
        if (updates != null) {
            Iterator itr = updates.keySet().iterator();
            while (itr.hasNext()) {
                IElementLabelProvider presentation = (IElementLabelProvider)itr.next();
                List list = (List)updates.get(presentation);
                Iterator listItr = list.iterator();
                while (listItr.hasNext()) {
                    this.updateStarted((ILabelUpdate)listItr.next());
                }
                presentation.update(list.toArray(new ILabelUpdate[list.size()]));
            }
        }
    }

    protected IPresentationContext getPresentationContext() {
        return this.fViewer.getPresentationContext();
    }

    protected synchronized void complete(ILabelUpdate update) {
        if (update.isCanceled()) {
            this.updateComplete(update);
        } else {
            if (this.fComplete == null) {
                this.fComplete = new ArrayList();
                UIJob job = new UIJob(this.getDisplay(), "Label Updates"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        LabelUpdate[] updates = null;
                        TreeModelLabelProvider treeModelLabelProvider = TreeModelLabelProvider.this;
                        synchronized (treeModelLabelProvider) {
                            updates = TreeModelLabelProvider.this.fComplete.toArray(new LabelUpdate[TreeModelLabelProvider.this.fComplete.size()]);
                            TreeModelLabelProvider.this.fComplete = null;
                        }
                        int i = 0;
                        while (i < updates.length) {
                            updates[i].update();
                            ++i;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule(10L);
            }
            this.fComplete.add(update);
        }
    }

    public void addLabelUpdateListener(ILabelUpdateListener listener) {
        this.fLabelListeners.add((Object)listener);
    }

    public void removeLabelUpdateListener(ILabelUpdateListener listener) {
        this.fLabelListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStarted(ILabelUpdate update) {
        boolean begin = false;
        List list = this.fUpdatesInProgress;
        synchronized (list) {
            begin = this.fUpdatesInProgress.isEmpty();
            this.fUpdatesInProgress.add(update);
        }
        if (begin) {
            if (ModelContentProvider.DEBUG_UPDATE_SEQUENCE && (ModelContentProvider.DEBUG_PRESENTATION_ID == null || ModelContentProvider.DEBUG_PRESENTATION_ID.equals(this.getPresentationContext().getId()))) {
                System.out.println("LABEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (ModelContentProvider.DEBUG_UPDATE_SEQUENCE && (ModelContentProvider.DEBUG_PRESENTATION_ID == null || ModelContentProvider.DEBUG_PRESENTATION_ID.equals(this.getPresentationContext().getId()))) {
            System.out.println("\tBEGIN - " + update);
        }
        this.notifyUpdate(2, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateComplete(ILabelUpdate update) {
        boolean end = false;
        List list = this.fUpdatesInProgress;
        synchronized (list) {
            this.fUpdatesInProgress.remove(update);
            end = this.fUpdatesInProgress.isEmpty();
        }
        if (ModelContentProvider.DEBUG_UPDATE_SEQUENCE && (ModelContentProvider.DEBUG_PRESENTATION_ID == null || ModelContentProvider.DEBUG_PRESENTATION_ID.equals(this.getPresentationContext().getId()))) {
            System.out.println("\tEND - " + update);
        }
        this.notifyUpdate(3, update);
        if (end) {
            if (ModelContentProvider.DEBUG_UPDATE_SEQUENCE && (ModelContentProvider.DEBUG_PRESENTATION_ID == null || ModelContentProvider.DEBUG_PRESENTATION_ID.equals(this.getPresentationContext().getId()))) {
                System.out.println("LABEL SEQUENCE ENDS");
            }
            this.notifyUpdate(1, null);
        }
    }

    protected void notifyUpdate(final int type, final ILabelUpdate update) {
        if (!this.fLabelListeners.isEmpty()) {
            Object[] listeners = this.fLabelListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ILabelUpdateListener listener = (ILabelUpdateListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.labelUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.labelUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.labelUpdateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.labelUpdateComplete(update);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }
}

