/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Bag<E>
extends Collection<E> {
    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public int count(Object var1);

    public boolean add(E var1, int var2);

    public boolean remove(Object var1, int var2);

    public Iterator<E> uniqueIterator();

    public Iterator<Entry<E>> entries();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Empty<E>
    extends AbstractCollection<E>
    implements Bag<E>,
    Serializable {
        public static final Bag INSTANCE = new Empty();
        private static final long serialVersionUID = 1L;

        public static <T> Bag<T> instance() {
            return INSTANCE;
        }

        private Empty() {
        }

        @Override
        public Iterator<E> iterator() {
            return EmptyIterator.instance();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> uniqueIterator() {
            return EmptyIterator.instance();
        }

        @Override
        public int count(Object o) {
            return 0;
        }

        @Override
        public Iterator<Entry<E>> entries() {
            return EmptyIterator.instance();
        }

        @Override
        public boolean remove(Object o, int count) {
            return false;
        }

        @Override
        public boolean add(E o, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bag)) {
                return false;
            }
            return ((Bag)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<E> {
        public E getElement();

        public int getCount();

        public int setCount(int var1);

        public boolean equals(Object var1);

        public int hashCode();
    }
}

