/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.Iterator;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterable<E1, E2>
implements Iterable<E2> {
    private final Iterable<? extends E1> iterable;
    private final Filter<E1> filter;

    public FilteringIterable(Iterable<? extends E1> iterable) {
        this.iterable = iterable;
        this.filter = new DefaultFilter();
    }

    public FilteringIterable(Iterable<? extends E1> iterable, Filter<E1> filter) {
        this.iterable = iterable;
        this.filter = filter;
    }

    @Override
    public Iterator<E2> iterator() {
        return new FilteringIterator(this.iterable.iterator(), this.filter);
    }

    protected boolean accept(E1 o) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultFilter
    implements Filter<E1> {
        DefaultFilter() {
        }

        @Override
        public boolean accept(E1 o) {
            return FilteringIterable.this.accept(o);
        }
    }
}

