/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyCompositeListIterator<E>
implements ListIterator<E> {
    private final ListIterator<? extends ListIterator<? extends E>> iterators;
    private ListIterator<? extends E> nextIterator;
    private int nextIndex;

    public ReadOnlyCompositeListIterator(List<? extends List<? extends E>> lists) {
        this(new TransformationListIterator<List<? extends E>, ListIterator<? extends E>>(lists.listIterator()){

            @Override
            protected ListIterator<? extends E> transform(List<? extends E> list) {
                return list.listIterator();
            }
        });
    }

    public ReadOnlyCompositeListIterator(ListIterator<? extends ListIterator<? extends E>> iterators) {
        this.iterators = iterators;
        this.nextIndex = 0;
    }

    public ReadOnlyCompositeListIterator(E object, List<? extends E> list) {
        this((E)object, list.listIterator());
    }

    public ReadOnlyCompositeListIterator(E object, ListIterator<? extends E> iterator) {
        this(new ListIterator[]{new SingleElementListIterator<E>(object), iterator});
    }

    public ReadOnlyCompositeListIterator(List<? extends E> list, E object) {
        this(list.listIterator(), (E)object);
    }

    public ReadOnlyCompositeListIterator(ListIterator<? extends E> iterator, E object) {
        this(new ListIterator[]{iterator, new SingleElementListIterator<E>(object)});
    }

    public ReadOnlyCompositeListIterator(List<? extends E> ... lists) {
        this(Arrays.asList(lists));
    }

    public ReadOnlyCompositeListIterator(ListIterator<? extends E> ... iterators) {
        this((ListIterator<ListIterator<? extends E>>)new ArrayListIterator<ListIterator<? extends E>>(iterators));
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    @Override
    public E next() {
        this.loadNextIterator();
        E result = this.nextIterator.next();
        ++this.nextIndex;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        this.loadPreviousIterator();
        E result = this.nextIterator.previous();
        --this.nextIndex;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = this.iterators.next();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterators);
    }
}

