/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAspectAdapter<S extends Model, E>
extends AspectAdapter<S>
implements CollectionValueModel<E> {
    protected final String[] collectionNames;
    protected static final String[] EMPTY_COLLECTION_NAMES = new String[0];
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionAspectAdapter(String collectionName, S subject) {
        this(new String[]{collectionName}, subject);
    }

    protected CollectionAspectAdapter(String[] collectionNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), collectionNames);
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... collectionNames) {
        super(subjectHolder);
        this.collectionNames = collectionNames;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> collectionNames) {
        this(subjectHolder, collectionNames.toArray(new String[collectionNames.size()]));
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_COLLECTION_NAMES);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                CollectionAspectAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                CollectionAspectAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                CollectionAspectAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionAspectAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener: " + Arrays.asList(CollectionAspectAdapter.this.collectionNames);
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.subject == null ? EmptyIterator.instance() : this.iterator_();
    }

    protected Iterator<E> iterator_() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.size_();
    }

    protected int size_() {
        return CollectionTools.size(this.iterator());
    }

    @Override
    protected Object getValue() {
        return this.iterator();
    }

    @Override
    protected Class<? extends ChangeListener> getListenerClass() {
        return CollectionChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireCollectionChanged("values");
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.subject).addCollectionChangeListener(collectionName, this.collectionChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.subject).removeCollectionChangeListener(collectionName, this.collectionChangeListener);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        int i = 0;
        while (i < this.collectionNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.collectionNames[i]);
            ++i;
        }
    }

    protected void itemsAdded(CollectionChangeEvent event) {
        this.fireItemsAdded(event.cloneWithSource(this, "values"));
    }

    protected void itemsRemoved(CollectionChangeEvent event) {
        this.fireItemsRemoved(event.cloneWithSource(this, "values"));
    }

    protected void collectionCleared(CollectionChangeEvent event) {
        this.fireCollectionCleared("values");
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.fireCollectionChanged("values");
    }
}

