/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedListValueModelWrapper<E>
extends ListValueModelWrapper<E>
implements ListValueModel<E> {
    protected List<E> prefix;
    protected List<E> suffix;

    public ExtendedListValueModelWrapper(List<? extends E> prefix, ListValueModel<? extends E> listHolder, List<? extends E> suffix) {
        super(listHolder);
        this.prefix = new ArrayList<E>(prefix);
        this.suffix = new ArrayList<E>(suffix);
    }

    public ExtendedListValueModelWrapper(E prefix, ListValueModel<? extends E> listHolder, E suffix) {
        super(listHolder);
        this.prefix = Collections.singletonList(prefix);
        this.suffix = Collections.singletonList(suffix);
    }

    public ExtendedListValueModelWrapper(List<? extends E> prefix, ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = new ArrayList<E>(prefix);
        this.suffix = Collections.emptyList();
    }

    public ExtendedListValueModelWrapper(E prefix, ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = Collections.singletonList(prefix);
        this.suffix = Collections.emptyList();
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder, List<? extends E> suffix) {
        super(listHolder);
        this.prefix = Collections.emptyList();
        this.suffix = new ArrayList<E>(suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder, E suffix) {
        super(listHolder);
        this.prefix = Collections.emptyList();
        this.suffix = Collections.singletonList(suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = Collections.singletonList(null);
        this.suffix = Collections.emptyList();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.listIterator_());
    }

    protected ListIterator<E> listIterator_() {
        return new ReadOnlyCompositeListIterator(this.prefix.listIterator(), this.listHolder.listIterator(), this.suffix.listIterator());
    }

    @Override
    public E get(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            return this.prefix.get(index);
        }
        if (index >= prefixSize + this.listHolder.size()) {
            return this.suffix.get(index - (prefixSize + this.listHolder.size()));
        }
        return this.listHolder.get(index - prefixSize);
    }

    @Override
    public int size() {
        return this.prefix.size() + this.listHolder.size() + this.suffix.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>(this.size());
        list.addAll(this.prefix);
        CollectionTools.addAll(list, this.listHolder.iterator());
        list.addAll(this.suffix);
        return list.toArray();
    }

    @Override
    protected void itemsAdded(ListChangeEvent event) {
        this.fireItemsAdded(event.cloneWithSource(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsRemoved(ListChangeEvent event) {
        this.fireItemsRemoved(event.cloneWithSource(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsReplaced(ListChangeEvent event) {
        this.fireItemsReplaced(event.cloneWithSource(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsMoved(ListChangeEvent event) {
        this.fireItemsMoved(event.cloneWithSource(this, "list values", this.prefix.size()));
    }

    @Override
    protected void listCleared(ListChangeEvent event) {
        this.fireListChanged("list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.fireListChanged("list values");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.prefix);
        sb.append(" ");
        super.toString(sb);
        sb.append(" ");
        sb.append(this.suffix);
    }

    public void setPrefix(List<E> prefix) {
        this.prefix = prefix;
        this.fireListChanged("list values");
    }

    public void setSuffix(List<E> suffix) {
        this.suffix = suffix;
        this.fireListChanged("list values");
    }
}

