/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.ReporterHelper;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.NullValidator;
import org.eclipse.wst.validation.internal.SummaryReporter;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorExtensionReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorExtender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Validator
implements Comparable<Validator> {
    protected boolean _buildValidation = true;
    private String _delegatingId;
    private String _sourceId;
    protected boolean _manualValidation = true;
    private String _markerId;
    private int _version = 1;
    private Map<String, MessageSeveritySetting> _messageSettings;
    protected IProject _project;
    protected transient int _changeCountGlobal;
    protected transient int _changeCountMessages;
    private boolean _migrated;

    public Validator(IProject project) {
        this._project = project;
    }

    void setMigrated(boolean migrated) {
        this._migrated = migrated;
    }

    public static Validator create(IConfigurationElement validator, IProject project) {
        V2 v2 = new V2(validator, project);
        return v2;
    }

    public static Validator create(ValidatorMetaData vmd, ValidationConfiguration config, IProject project) {
        V1 v1 = new V1(vmd, config, project);
        return v1;
    }

    public V1 asV1Validator() {
        return null;
    }

    public V2 asV2Validator() {
        return null;
    }

    public void clean(IProject project, ValOperation operation, IProgressMonitor monitor) {
    }

    @Override
    public int compareTo(Validator validator) {
        return this.getName().compareTo(validator.getName());
    }

    public Validator copy() {
        return this.copy(false);
    }

    public abstract Validator copy(boolean var1);

    protected void copyLocal(Validator v, boolean includeChangeCounts) {
        this._buildValidation = v._buildValidation;
        this._delegatingId = v._delegatingId;
        this._manualValidation = v._manualValidation;
        this._markerId = v._markerId;
        this._messageSettings = v._messageSettings;
        this._sourceId = v._sourceId;
        this._version = v._version;
        this._migrated = v._migrated;
        if (includeChangeCounts) {
            this._changeCountGlobal = v._changeCountGlobal;
            this._changeCountMessages = v._changeCountMessages;
        }
    }

    public boolean shouldClearMarkers(ValidationEvent event) {
        return true;
    }

    public boolean shouldValidate(IResource resource, boolean isManual, boolean isBuild) {
        return this.shouldValidate(resource, isManual, isBuild, new ContentTypeWrapper());
    }

    boolean shouldValidate(IResource resource, boolean isManual, boolean isBuild, ContentTypeWrapper contentTypeWrapper) {
        if (isManual && !this._manualValidation) {
            return false;
        }
        if (isBuild && !this._buildValidation) {
            return false;
        }
        return this.shouldValidate(resource, contentTypeWrapper);
    }

    public boolean shouldValidate(IResource resource, ValType valType) {
        return this.shouldValidate(resource, valType, new ContentTypeWrapper());
    }

    boolean shouldValidate(IResource resource, ValType valType, ContentTypeWrapper contentTypeWrapper) {
        if (Tracing.matchesExtraDetail(this.getId())) {
            Tracing.log("Validator-01: checking if " + this.getId() + " should validate " + resource);
        }
        if (valType == ValType.Manual && !this._manualValidation) {
            return false;
        }
        if (valType == ValType.Build && !this._buildValidation) {
            return false;
        }
        boolean result = this.shouldValidate(resource, contentTypeWrapper);
        if (Tracing.matchesExtraDetail(this.getId())) {
            Tracing.log("Validator-02: result = " + result);
        }
        return result;
    }

    public boolean shouldValidateProject(IProject project, ValType type) {
        return this.shouldValidateProject(project, type == ValType.Manual, type == ValType.Build);
    }

    public boolean shouldValidateProject(IProject project, boolean isManual, boolean isBuild) {
        if (Tracing.matchesExtraDetail(this.getId())) {
            Tracing.log("Validator-03: checking if " + this.getId() + " should validate " + project);
        }
        if (isManual && !this._manualValidation) {
            return false;
        }
        if (isBuild && !this._buildValidation) {
            return false;
        }
        if (project == null || !project.isOpen()) {
            return false;
        }
        boolean result = this.shouldValidateProject(project);
        if (Tracing.matchesExtraDetail(this.getId())) {
            Tracing.log("Validator-04: result " + result);
        }
        return result;
    }

    public abstract ValidationResult validate(IResource var1, int var2, ValOperation var3, IProgressMonitor var4);

    public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor, ValidationEvent event) {
        return this.validate(resource, kind, operation, monitor);
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    void add(MessageSeveritySetting message) {
        if (this._messageSettings == null) {
            this._messageSettings = new HashMap<String, MessageSeveritySetting>(10);
        }
        this._messageSettings.put(message.getId(), message);
        this.bumpChangeCountMessages();
    }

    public IValidator asIValidator() {
        return null;
    }

    protected abstract boolean shouldValidate(IResource var1, ContentTypeWrapper var2);

    protected abstract boolean shouldValidateProject(IProject var1);

    public abstract String getId();

    public MessageSeveritySetting getMessage(String id) {
        return this.getMessageSettings().get(id);
    }

    public Map<String, MessageSeveritySetting> getMessageSettings() {
        Map<String, MessageSeveritySetting> settings = this._messageSettings;
        if (settings == null) {
            settings = new HashMap<String, MessageSeveritySetting>(10);
            this.init(settings);
            if (ValManager.getDefault().mustUseGlobalValidators(this.getProject())) {
                ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
                gp.loadMessages(this, settings);
            } else {
                ValPrefManagerProject vp = new ValPrefManagerProject(this.getProject());
                vp.loadMessages(this, settings);
            }
            this._messageSettings = settings;
        }
        return settings;
    }

    public int hashCodeForConfig() {
        int h = 0;
        if (this._buildValidation) {
            h += 101;
        }
        if (this._delegatingId != null) {
            h += this._delegatingId.hashCode();
        }
        if (this._manualValidation) {
            h += 201;
        }
        if (this._messageSettings != null) {
            for (MessageSeveritySetting ms : this._messageSettings.values()) {
                h += ms.hashCode();
            }
        }
        if (this._sourceId != null) {
            h += this._sourceId.hashCode();
        }
        return h += this._version;
    }

    private void init(Map<String, MessageSeveritySetting> settings) {
        for (MessageSeveritySetting ms : ValidatorExtensionReader.getDefault().addMessages(this)) {
            settings.put(ms.getId(), ms);
        }
    }

    public abstract String getName();

    public IProject getProject() {
        return this._project;
    }

    public abstract String getValidatorClassname();

    public boolean isManualValidation() {
        return this._manualValidation;
    }

    public boolean setManualValidation(boolean manualValidation) {
        return this.setManualValidation2(manualValidation);
    }

    protected final boolean setManualValidation2(boolean manualValidation) {
        boolean changed = false;
        if (this._manualValidation != manualValidation) {
            this.bumpChangeCountGlobal();
            changed = true;
            this._manualValidation = manualValidation;
        }
        return changed;
    }

    public boolean isBuildValidation() {
        return this._buildValidation;
    }

    public boolean isChanged() {
        return this._changeCountGlobal > 0 || this._changeCountMessages > 0 || this._migrated;
    }

    abstract boolean isLoaded();

    public boolean setBuildValidation(boolean buildValidation) {
        return this.setBuildValidation2(buildValidation);
    }

    protected final boolean setBuildValidation2(boolean buildValidation) {
        boolean changed = false;
        if (this._buildValidation != buildValidation) {
            this.bumpChangeCountGlobal();
            changed = true;
            this._buildValidation = buildValidation;
        }
        return changed;
    }

    public String getDelegatingId() {
        return this._delegatingId;
    }

    public void setDelegatingId(String delegating) {
        if (!Misc.same(this._delegatingId, delegating)) {
            this._delegatingId = delegating;
            this.bumpChangeCountGlobal();
        }
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        if (this._version != version) {
            this._version = version;
            this.bumpChangeCountGlobal();
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getSourceId() {
        return this._sourceId;
    }

    public void setSourceId(String sourceId) {
        if (!Misc.same(this._sourceId, sourceId)) {
            this._sourceId = sourceId;
            this.bumpChangeCountGlobal();
        }
    }

    void setMessages(Map<String, MessageSeveritySetting> map) {
        this._messageSettings = map;
        this.bumpChangeCountMessages();
    }

    public int getChangeCountGlobal() {
        return this._changeCountGlobal;
    }

    public boolean hasGlobalChanges() {
        return this._migrated || this._changeCountGlobal > 0;
    }

    public int getChangeCountMessages() {
        return this._changeCountMessages;
    }

    public void bumpChangeCountMessages() {
        ++this._changeCountMessages;
    }

    public void resetChangeCounters() {
        this._changeCountGlobal = 0;
        this._changeCountMessages = 0;
    }

    public void bumpChangeCountGlobal() {
        ++this._changeCountGlobal;
    }

    public boolean sameConfig(Validator validator) {
        if (validator == null) {
            return false;
        }
        return this.hashCodeForConfig() == validator.hashCodeForConfig();
    }

    public String getMarkerId() {
        return this._markerId;
    }

    public void setMarkerId(String markerId) {
        this._markerId = markerId;
        if (markerId != null) {
            MarkerManager.getDefault().getMarkers().add(markerId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        Extension,
        Global,
        Project;

    }

    public static class V1
    extends Validator {
        private ValidatorMetaData _vmd;

        public V1(ValidatorMetaData vmd, ValidationConfiguration config, IProject project) {
            super(project);
            this._vmd = vmd;
            if (config != null) {
                this.setBuildValidation(config.isBuildEnabled(vmd));
                this.setManualValidation(config.isManualEnabled(vmd));
            }
            this.setDelegatingId(ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(this._vmd.getValidatorUniqueName()));
            if (this._vmd.getMarkerIds() != null && this._vmd.getMarkerIds().length > 0) {
                this.setMarkerId(this._vmd.getMarkerIds()[0]);
            }
            this.resetChangeCounters();
        }

        public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
            IValidator v;
            if (project != null && (v = this.asIValidator()) instanceof IValidatorExtender) {
                IValidatorExtender vExt = (IValidatorExtender)((Object)v);
                vExt.validationFinishing(project, state, monitor);
            }
        }

        public IValidator asIValidator() {
            IValidator v = null;
            try {
                v = this._vmd.getValidator();
            }
            catch (InstantiationException e) {
                ValidationPlugin.getPlugin().handleException(e);
                return null;
            }
            return v;
        }

        public V1 asV1Validator() {
            return this;
        }

        public Validator copy(boolean includeChangeCounts) {
            V1Copy v = new V1Copy(this._vmd, null, this._project);
            v.copyLocal(this, includeChangeCounts);
            return v;
        }

        public String getName() {
            return this._vmd.getValidatorDisplayName();
        }

        public ValidatorMetaData getVmd() {
            return this._vmd;
        }

        public String getValidatorClassname() {
            String name = "";
            try {
                name = this._vmd.getValidator().getClass().getName();
            }
            catch (Exception exception) {}
            return name;
        }

        public String getId() {
            return this._vmd.getValidatorUniqueName();
        }

        boolean isLoaded() {
            return this._vmd.isActive();
        }

        public boolean setBuildValidation(boolean buildValidation) {
            boolean changed = super.setBuildValidation(buildValidation);
            this._vmd.setBuildValidation(buildValidation);
            return changed;
        }

        public boolean setManualValidation(boolean manualValidation) {
            boolean changed = super.setManualValidation(manualValidation);
            this._vmd.setManualValidation(manualValidation);
            return changed;
        }

        protected boolean shouldValidate(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            return this._vmd.isApplicableTo(resource);
        }

        protected boolean shouldValidateProject(IProject project) {
            return true;
        }

        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ValidationResult vr = new ValidationResult();
            IValidator v = this.asIValidator();
            if (v == null) {
                return null;
            }
            try {
                IProject project = resource.getProject();
                SummaryReporter reporter = new SummaryReporter(project, monitor);
                IWorkbenchContext helper = this._vmd.getHelper(project);
                if (helper instanceof WorkbenchContext) {
                    WorkbenchContext wc = (WorkbenchContext)helper;
                    LinkedList<String> files = new LinkedList<String>();
                    files.add(wc.getPortableName(resource));
                    wc.setValidationFileURIs(files);
                }
                try {
                    ValidatorLauncher.getLauncher().start(helper, v, reporter);
                }
                finally {
                    try {
                        v.cleanup(reporter);
                    }
                    finally {
                        helper.cleanup(reporter);
                    }
                }
                vr.incrementError(reporter.getSeverityHigh());
                vr.incrementWarning(reporter.getSeverityNormal());
                vr.incrementInfo(reporter.getSeverityLow());
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            return vr;
        }

        public static final class V1Copy
        extends V1 {
            public V1Copy(ValidatorMetaData vmd, ValidationConfiguration vc, IProject project) {
                super(vmd, vc, project);
            }

            public boolean setManualValidation(boolean bool) {
                return this.setManualValidation2(bool);
            }

            public boolean setBuildValidation(boolean bool) {
                return this.setBuildValidation2(bool);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class V2
    extends Validator
    implements IAdaptable {
        private AbstractValidator _validator;
        private List<FilterGroup> _groups = new LinkedList<FilterGroup>();
        private FilterGroup[] _groupsArray;
        private String _id;
        private String _name;
        private IConfigurationElement _validatorConfigElement;
        private String _validatorClassName;
        private String[] _validatorGroupIds;
        private AbstractValidator _delegated;
        protected transient int _changeCountGroups;
        private Level _level;
        private AtomicBoolean _pendingValidationStarted = new AtomicBoolean();

        V2(IConfigurationElement configElement, IProject project) {
            super(project);
            assert (configElement != null);
            this._validatorConfigElement = configElement;
            this._validatorClassName = configElement.getAttribute("class");
            IConfigurationElement[] groupReferenceElements = configElement.getChildren("group");
            ArrayList<String> validatorGroupIDs = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray = groupReferenceElements;
            int n = groupReferenceElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement groupElement = iConfigurationElementArray[n2];
                String id = groupElement.getAttribute("id");
                if (id != null) {
                    validatorGroupIDs.add(id);
                }
                ++n2;
            }
            this._validatorGroupIds = validatorGroupIDs.toArray(new String[validatorGroupIDs.size()]);
            this.init();
        }

        private V2(IProject project, String validatorClassName, AbstractValidator validator) {
            super(project);
            assert (validator != null);
            this._validatorClassName = validatorClassName;
            this._validator = validator;
            this.init();
        }

        private void init() {
            try {
                String id = ConfigurationManager.getManager().getConfiguration(this._project).getDelegateForTarget(this._validatorClassName);
                if (id == null) {
                    id = ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(this._validatorClassName);
                }
                this.setDelegatingId(id);
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            this.resetChangeCounters();
        }

        public synchronized void add(FilterGroup fg) {
            assert (fg != null);
            this._groupsArray = null;
            this._groups.add(fg);
            this.bumpChangeCountGroups();
        }

        @Override
        public IValidator asIValidator() {
            AbstractValidator av = this.getDelegatedValidator();
            if (av instanceof IValidator) {
                return (IValidator)((Object)av);
            }
            return super.asIValidator();
        }

        @Override
        public V2 asV2Validator() {
            return this;
        }

        @Override
        public void clean(IProject project, ValOperation operation, IProgressMonitor monitor) {
            this.getDelegatedValidator().clean(project, operation.getState(), monitor);
        }

        @Override
        public Validator copy(boolean includeChangeCounts) {
            V2 v = null;
            v = this._validatorConfigElement != null ? new V2(this._validatorConfigElement, this._project) : new V2(this._project, this._validatorClassName, this._validator);
            v.copyLocal(this, includeChangeCounts);
            if (includeChangeCounts) {
                v._changeCountGroups = this._changeCountGroups;
            }
            FilterGroup[] groups = this.getGroups();
            v._groupsArray = new FilterGroup[groups.length];
            int i = 0;
            while (i < groups.length) {
                v._groupsArray[i] = groups[i];
                v._groups.add(groups[i]);
                ++i;
            }
            v._id = this._id;
            v._name = this._name;
            v._validatorGroupIds = this._validatorGroupIds;
            v._pendingValidationStarted = this._pendingValidationStarted;
            return v;
        }

        public int getChangeCountGroups() {
            return this._changeCountGroups;
        }

        public void bumpChangeCountGroups() {
            ++this._changeCountGroups;
        }

        public Level getLevel() {
            return this._level;
        }

        public void setLevel(Level level) {
            assert (this._level == null);
            this._level = level;
        }

        public AbstractValidator getDelegatedValidator() {
            AbstractValidator delegated = this._delegated;
            if (delegated != null) {
                return delegated;
            }
            if (this.getDelegatingId() == null) {
                return this.getValidator();
            }
            try {
                ValidatorDelegateDescriptor vdd = ValidatorDelegatesRegistry.getInstance().getDescriptor(this.getValidatorClassname(), this.getDelegatingId());
                if (vdd == null) {
                    return this.getValidator();
                }
                delegated = vdd.getValidator2();
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
                delegated = new NullValidator();
            }
            delegated.setParent(this);
            this._delegated = delegated;
            return delegated;
        }

        @Override
        public String getId() {
            return this._id;
        }

        public synchronized FilterGroup[] getGroups() {
            FilterGroup[] groups = this._groupsArray;
            if (groups == null) {
                groups = new FilterGroup[this._groups.size()];
                this._groups.toArray(groups);
                this._groupsArray = groups;
            }
            return groups;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public AbstractValidator getValidator() {
            if (this._validator == null) {
                try {
                    this._validator = (AbstractValidator)this._validatorConfigElement.createExecutableExtension("class");
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    IContributor contrib = this._validatorConfigElement.getContributor();
                    String message = NLS.bind((String)ValMessages.ErrConfig, (Object)contrib.getName());
                    ValidationPlugin.getPlugin().logMessage(4, message);
                    this._validator = new NullValidator();
                }
                this._validator.setParent(this);
                this._validatorConfigElement = null;
            }
            return this._validator;
        }

        @Override
        public String getValidatorClassname() {
            return this._validatorClassName;
        }

        public String[] getValidatorGroups() {
            return this._validatorGroupIds;
        }

        @Override
        public int hashCodeForConfig() {
            int h = super.hashCodeForConfig();
            if (this._id != null) {
                h += this._id.hashCode();
            }
            if (this._groups != null) {
                for (FilterGroup fg : this._groups) {
                    h += fg.hashCodeForConfig();
                }
            }
            return h;
        }

        @Override
        public boolean isChanged() {
            if (this._changeCountGroups > 0) {
                return true;
            }
            return super.isChanged();
        }

        @Override
        boolean isLoaded() {
            return this._validator != null;
        }

        @Override
        public boolean shouldClearMarkers(ValidationEvent event) {
            return this.getValidator().shouldClearMarkers(event);
        }

        @Override
        protected boolean shouldValidate(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            if (resource.isDerived()) {
                return false;
            }
            FilterGroup[] groups = this.getGroups();
            IProject project = resource.getProject();
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (!group.shouldValidate(project, resource, contentTypeWrapper)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public void setDelegatingId(String delegating) {
            super.setDelegatingId(delegating);
            this._delegated = null;
        }

        public synchronized void setGroups(List<FilterGroup> groups) {
            this._groups = groups;
            this._groupsArray = null;
            this.bumpChangeCountGroups();
        }

        public void setId(String id) {
            if (!Misc.same(this._id, id)) {
                this._id = id;
                this.bumpChangeCountGlobal();
            }
        }

        public void setName(String name) {
            if (!Misc.same(this._name, name)) {
                this._name = name;
                this.bumpChangeCountGlobal();
            }
        }

        @Override
        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor) {
            return this.validate(resource, kind, operation, monitor, null);
        }

        @Override
        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor, ValidationEvent event) {
            ValidationResult vr = null;
            if (operation == null) {
                operation = new ValOperation();
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                if (event == null) {
                    event = new ValidationEvent(resource, kind, null);
                }
                if ((vr = this.getDelegatedValidator().validate(event, operation.getState(), monitor)) == null) {
                    vr = this.getDelegatedValidator().validate(resource, kind, operation.getState(), monitor);
                }
            }
            catch (Exception e) {
                try {
                    String msg = NLS.bind((String)ValMessages.LogValEnd, (Object)this.getName(), (Object)resource.getLocationURI());
                    ValidationPlugin.getPlugin().logMessage(4, msg);
                }
                catch (Exception exception) {}
                ValidationPlugin.getPlugin().handleException(e);
            }
            if (vr != null) {
                IResource[] validated;
                if (vr.getValidationException() != null) {
                    ValidationPlugin.getPlugin().handleException(vr.getValidationException());
                }
                this.updateResults(vr);
                if (vr.getDependsOn() != null) {
                    ValidationFramework.getDefault().getDependencyIndex().set(this.getId(), resource, vr.getDependsOn());
                }
                if ((validated = vr.getValidated()) != null) {
                    int i = 0;
                    while (i < validated.length) {
                        operation.addValidated(this.getId(), validated[i]);
                        ++i;
                    }
                }
                ValidatorMessage[] msgs = vr.getMessages();
                MarkerManager mm = MarkerManager.getDefault();
                ValidatorMessage[] validatorMessageArray = msgs;
                int n = msgs.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMessage m = validatorMessageArray[n2];
                    mm.createMarker(m, this.getId());
                    ++n2;
                }
            }
            return vr;
        }

        private void updateResults(ValidationResult vr) {
            ReporterHelper rh = vr.getReporterHelper();
            if (rh == null) {
                return;
            }
            ClassLoader classloader = this.getDelegatedValidator().getClass().getClassLoader();
            for (IMessage message : rh.getMessages()) {
                String groupName;
                Object target = message.getTargetObject();
                if (target == null) continue;
                IResource res = null;
                if (target instanceof IResource) {
                    res = (IResource)target;
                }
                if (res == null && (target = message.getAttribute("TargetResource")) != null && target instanceof IResource) {
                    res = (IResource)target;
                }
                if (res == null) continue;
                ValidatorMessage vm = ValidatorMessage.create(message.getText(classloader), res);
                if (this.getMarkerId() != null) {
                    vm.setType(this.getMarkerId());
                }
                vr.add(vm);
                int markerSeverity = 0;
                int sev = message.getSeverity();
                if ((sev & 1) != 0) {
                    markerSeverity = 2;
                } else if ((sev & 2) != 0) {
                    markerSeverity = 1;
                }
                vm.setAttribute("severity", markerSeverity);
                vm.setAttribute("lineNumber", message.getLineNumber());
                int offset = message.getOffset();
                if (offset != -1) {
                    vm.setAttribute("charStart", offset);
                    int len = message.getLength();
                    if (len != -1) {
                        vm.setAttribute("charStart", offset);
                        vm.setAttribute("charEnd", offset + len);
                    }
                }
                if ((groupName = message.getGroupName()) != null) {
                    vm.setAttribute("groupName", groupName);
                }
                this.copyAttributes(message, vm);
            }
        }

        private void copyAttributes(IMessage message, ValidatorMessage vm) {
            HashMap attributes = message.getAttributes();
            if (attributes != null) {
                for (Map.Entry me : attributes.entrySet()) {
                    String key = (String)me.getKey();
                    vm.setAttribute(key, me.getValue());
                }
            }
        }

        @Override
        public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
            if (project == null) {
                this._pendingValidationStarted.set(true);
            } else {
                AbstractValidator val = this.getDelegatedValidator();
                if (this._pendingValidationStarted.getAndSet(false)) {
                    val.validationStarting(null, state, monitor);
                }
                val.validationStarting(project, state, monitor);
            }
        }

        @Override
        public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
            if (project == null) {
                if (!this._pendingValidationStarted.getAndSet(false)) {
                    this.getDelegatedValidator().validationFinishing(null, state, monitor);
                }
            } else {
                this.getDelegatedValidator().validationFinishing(project, state, monitor);
            }
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public synchronized void remove(FilterGroup group) {
            this._groups.remove(group);
            this._groupsArray = null;
            this.bumpChangeCountGroups();
        }

        @Override
        public void resetChangeCounters() {
            super.resetChangeCounters();
            this._changeCountGroups = 0;
        }

        @Override
        protected boolean shouldValidateProject(IProject project) {
            FilterGroup[] groups = this.getGroups();
            ContentTypeWrapper ctw = new ContentTypeWrapper();
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (!group.shouldValidate(project, null, ctw)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public synchronized void replaceFilterGroup(FilterGroup existing, FilterGroup merged) {
            this.remove(existing);
            this.add(merged);
        }
    }
}

