/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ISessionListener;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;
import org.eclipse.pde.api.tools.internal.provisional.ITreeModel;
import org.eclipse.pde.api.tools.internal.provisional.ITreeNode;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.ui.internal.ApiImageDescriptor;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.actions.CollapseAllAction;
import org.eclipse.pde.api.tools.ui.internal.actions.ExpandAllAction;
import org.eclipse.pde.api.tools.ui.internal.actions.ExportSessionAction;
import org.eclipse.pde.api.tools.ui.internal.actions.NavigateAction;
import org.eclipse.pde.api.tools.ui.internal.actions.RemoveActiveSessionAction;
import org.eclipse.pde.api.tools.ui.internal.actions.RemoveAllSessionsAction;
import org.eclipse.pde.api.tools.ui.internal.actions.SelectSessionAction;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class APIToolingView
extends ViewPart
implements ISessionListener {
    public static final String ID = "org.eclipse.pde.api.tools.ui.views.apitooling.views.apitoolingview";
    public TreeViewer viewer;
    private Label sessionDescription = null;
    private IAction removeActiveSessionAction;
    private IAction removeAllSessionsAction;
    private IAction selectSessionAction;
    private Action doubleClickAction;
    private ExportSessionAction exportSessionAction;
    private NavigateAction nextAction;
    private NavigateAction previousAction;
    private ExpandAllAction expandallAction;
    private CollapseAllAction collapseallAction;
    private IPropertySheetPage page;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        ViewForm form = new ViewForm(parent, 0x800000);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, IApiToolsHelpContextIds.API_TOOLING_VIEW);
        this.sessionDescription = SWTFactory.createLabel((Composite)form, null, 1);
        form.setTopCenterSeparate(true);
        form.setTopCenter((Control)this.sessionDescription);
        this.viewer = new TreeViewer((Composite)form, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                ITreeNode node = (ITreeNode)element;
                switch (node.getId()) {
                    case 5: {
                        return 1;
                    }
                }
                return 0;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.createActions();
        this.updateActions();
        this.configureToolbar();
        this.hookDoubleClickAction();
        form.setContent((Control)this.viewer.getTree());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        ISessionManager sessionManager = ApiPlugin.getDefault().getSessionManager();
        ISession[] sessions = sessionManager.getSessions();
        if (sessions.length > 0) {
            ISession activeSession = sessionManager.getActiveSession();
            if (sessions[0] != activeSession) {
                sessionManager.activateSession(sessions[0]);
            } else {
                this.viewer.setInput((Object)activeSession);
                this.updateActions();
            }
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ISessionManager sessionManager = ApiPlugin.getDefault().getSessionManager();
        sessionManager.addSessionListener((ISessionListener)this);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                APIToolingView.this.doubleClickAction.run();
            }
        });
    }

    public void dispose() {
        ApiPlugin.getDefault().getSessionManager().removeSessionListener((ISessionListener)this);
    }

    protected void configureToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.removeActiveSessionAction);
        tbm.add(this.removeAllSessionsAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.selectSessionAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.nextAction);
        tbm.add((IAction)this.previousAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.expandallAction);
        tbm.add((IAction)this.collapseallAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.exportSessionAction);
    }

    private void createActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.removeActiveSessionAction = new RemoveActiveSessionAction();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.removeActiveSessionAction);
        this.removeAllSessionsAction = new RemoveAllSessionsAction();
        this.selectSessionAction = new SelectSessionAction();
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = APIToolingView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    ITreeNode node;
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (APIToolingView.this.viewer.getExpandedState(item)) {
                        APIToolingView.this.viewer.collapseToLevel(item, 1);
                    } else {
                        APIToolingView.this.viewer.expandToLevel(item, 1);
                    }
                    if (item instanceof ITreeNode && (node = (ITreeNode)item).getData() != null && !node.hasChildren()) {
                        ApiUIPlugin.getDefault().showPropertiesView();
                    }
                }
            }
        };
        this.exportSessionAction = new ExportSessionAction(this);
        this.nextAction = new NavigateAction(this, true);
        this.previousAction = new NavigateAction(this, false);
        this.expandallAction = new ExpandAllAction(this.viewer);
        this.collapseallAction = new CollapseAllAction(this.viewer);
    }

    private void updateActions() {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ISessionManager sessionManager = ApiPlugin.getDefault().getSessionManager();
                ISession active = sessionManager.getActiveSession();
                APIToolingView.this.sessionDescription.setText(active == null ? "No Description" : active.getDescription());
                ISession[] sessions = sessionManager.getSessions();
                boolean atLeastOne = sessions.length >= 1;
                APIToolingView.this.removeActiveSessionAction.setEnabled(atLeastOne);
                APIToolingView.this.removeAllSessionsAction.setEnabled(atLeastOne);
                APIToolingView.this.selectSessionAction.setEnabled(atLeastOne);
                APIToolingView.this.exportSessionAction.setEnabled(active != null);
                APIToolingView.this.expandallAction.setEnabled(atLeastOne);
                APIToolingView.this.collapseallAction.setEnabled(atLeastOne);
                APIToolingView.this.nextAction.setEnabled(atLeastOne);
                APIToolingView.this.previousAction.setEnabled(atLeastOne);
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void sessionAdded(final ISession session) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                APIToolingView.this.viewer.setInput((Object)session);
            }
        });
        this.updateActions();
    }

    public void sessionRemoved(ISession session) {
        this.viewer.setInput(null);
        this.updateActions();
    }

    public void sessionActivated(final ISession session) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                APIToolingView.this.viewer.setInput((Object)session);
            }
        });
        this.updateActions();
    }

    protected IPropertySheetPage getPropertySheet() {
        if (this.page == null) {
            this.page = new PropertySheetPage();
        }
        return this.page;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.getPropertySheet();
        }
        return super.getAdapter(adapter);
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ITreeModel model;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.model = null;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof ISession) {
                ISession session = (ISession)parent;
                if (this.model == null) {
                    this.model = session.getModel();
                }
                return this.getChildren(this.model.getRoot());
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ITreeNode) {
                return ((ITreeNode)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof ITreeNode) {
                return ((ITreeNode)parent).hasChildren();
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof ITreeNode) {
                IDelta delta;
                Image image;
                ITreeNode treeNode = (ITreeNode)obj;
                switch (treeNode.getId()) {
                    case 1: {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                    }
                    case 2: {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif");
                    }
                    case 3: {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
                    }
                    case 4: {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.enum_obj.gif");
                    }
                    case 5: {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
                    }
                }
                Object data = treeNode.getData();
                if (data instanceof IDelta && (image = this.getDeltaElementImage(delta = (IDelta)data)) != null) {
                    int flags = DeltaProcessor.isCompatible((IDelta)delta) ? 2 : 1;
                    ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)image);
                    ApiImageDescriptor desc = new ApiImageDescriptor(descriptor, flags);
                    return ApiUIPlugin.getImage((ImageDescriptor)desc);
                }
            }
            return null;
        }

        private Image getDeltaElementImage(IDelta delta) {
            switch (delta.getFlags()) {
                case 16: 
                case 61: {
                    int modifiers = delta.getNewModifiers();
                    switch (delta.getKind()) {
                        case 3: {
                            modifiers = delta.getOldModifiers();
                        }
                    }
                    if (Flags.isPublic((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
                    }
                    if (Flags.isProtected((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_protected_obj.gif");
                    }
                    if (Flags.isPrivate((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_private_obj.gif");
                    }
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_default_obj.gif");
                }
                case 7: 
                case 8: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 67: {
                    int modifiers = delta.getNewModifiers();
                    switch (delta.getKind()) {
                        case 3: {
                            modifiers = delta.getOldModifiers();
                        }
                    }
                    if (Flags.isPublic((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                    }
                    if (Flags.isProtected((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpro_obj.gif");
                    }
                    if (Flags.isPrivate((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpri_obj.gif");
                    }
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_default_obj.gif");
                }
            }
            switch (delta.getElementType()) {
                case 1: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
                }
                case 6: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.enum_obj.gif");
                }
                case 4: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                }
                case 8: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif");
                }
                case 7: {
                    int modifiers = delta.getNewModifiers();
                    switch (delta.getKind()) {
                        case 3: {
                            modifiers = delta.getOldModifiers();
                        }
                    }
                    if (Flags.isPublic((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
                    }
                    if (Flags.isProtected((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_protected_obj.gif");
                    }
                    if (Flags.isPrivate((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_private_obj.gif");
                    }
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_default_obj.gif");
                }
                case 5: 
                case 9: {
                    int modifiers = delta.getNewModifiers();
                    switch (delta.getKind()) {
                        case 3: {
                            modifiers = delta.getOldModifiers();
                        }
                    }
                    if (Flags.isPublic((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                    }
                    if (Flags.isProtected((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpro_obj.gif");
                    }
                    if (Flags.isPrivate((int)modifiers)) {
                        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpri_obj.gif");
                    }
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_default_obj.gif");
                }
                case 10: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                }
                case 2: 
                case 3: {
                    String componentVersionId = delta.getComponentVersionId();
                    IApiComponent component = null;
                    if (componentVersionId != null) {
                        IApiComponent apiComponent;
                        int indexOfOpen = componentVersionId.lastIndexOf(40);
                        String componentID = componentVersionId.substring(0, indexOfOpen);
                        IApiBaseline baseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
                        if (baseline != null && (apiComponent = baseline.getApiComponent(componentID)) != null) {
                            component = apiComponent;
                        }
                    }
                    if (component != null) {
                        if (component.isSystemComponent()) {
                            return ApiUIPlugin.getSharedImage("IMG_OBJ_API_SYSTEM_LIBRARY");
                        }
                        try {
                            if (component.isFragment()) {
                                return ApiUIPlugin.getSharedImage("IMG_OBJ_FRAGMENT");
                            }
                        }
                        catch (CoreException e) {
                            ApiPlugin.log((Throwable)e);
                        }
                    }
                    return ApiUIPlugin.getSharedImage("IMG_OBJ_BUNDLE");
                }
            }
            return null;
        }
    }
}

