/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.monitor.ui.IActivityManagerCallback;
import org.eclipse.mylyn.internal.monitor.ui.Messages;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;

public class CheckActivityJob
extends Job {
    private boolean active;
    private final int ACTIVE_TICK = 30000;
    private final IActivityManagerCallback callback;
    private int inactivityTimeout;
    protected long previousEventTime;
    protected long tick = 30000L;

    public CheckActivityJob(IActivityManagerCallback callback) {
        super(Messages.CheckActivityJob_Activity_Monitor_Job);
        this.callback = callback;
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isEnabled() {
        return Platform.isRunning() && !MonitorUiPlugin.getDefault().getWorkbench().isClosing();
    }

    public void reschedule() {
        this.schedule(this.active ? this.tick : this.tick / 6L);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.isEnabled()) {
            try {
                long lastEventTime = this.callback.getLastEventTime();
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastEventTime >= (long)this.inactivityTimeout && this.inactivityTimeout != 0) {
                    if (this.active) {
                        this.active = false;
                        this.callback.inactive();
                    }
                } else if (!this.active) {
                    this.active = true;
                    this.previousEventTime = this.inactivityTimeout != 0 ? lastEventTime : currentTime;
                    this.callback.active();
                } else if (currentTime - this.previousEventTime > this.tick * 3L) {
                    if (this.inactivityTimeout != 0) {
                        if (currentTime - lastEventTime <= this.tick) {
                            this.previousEventTime = lastEventTime;
                        } else {
                            this.active = false;
                            this.callback.inactive();
                        }
                    } else {
                        this.previousEventTime = currentTime;
                    }
                } else {
                    this.callback.addMonitoredActivityTime(this.previousEventTime, currentTime);
                    this.previousEventTime = currentTime;
                }
            }
            finally {
                this.reschedule();
            }
        }
        return Status.OK_STATUS;
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }
}

