/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentAttribute
extends AbstractJavaJpaContextNode
implements JavaPersistentAttribute {
    protected String name;
    protected JavaAttributeMapping defaultMapping;
    protected JavaAttributeMapping specifiedMapping;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;
    protected static final String[] VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    protected static final String[] OTHER_VALID_BASIC_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    protected static final String SERIALIZABLE_TYPE_NAME = Serializable.class.getName();
    protected static final String[] COLLECTION_TYPE_NAMES = new String[]{Collection.class.getName(), Set.class.getName(), List.class.getName()};
    protected static final String[] MAP_TYPE_NAMES = new String[]{Map.class.getName()};
    protected static final String[] CONTAINER_TYPE_NAMES = (String[])CollectionTools.concatenate((Object[][])new String[][]{COLLECTION_TYPE_NAMES, MAP_TYPE_NAMES});

    protected AbstractJavaPersistentAttribute(PersistentType parent, JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super(parent);
        this.resourcePersistentAttribute = resourcePersistentAttribute;
        this.name = this.buildName();
        this.defaultMapping = this.buildDefaultMapping();
        this.specifiedMapping = this.buildJavaAttributeMappingFromAnnotation(this.getJavaMappingAnnotationName());
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentAttribute";
    }

    @Override
    public IContentType getContentType() {
        return this.getPersistentType().getContentType();
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getNameTextRange(astRoot);
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePersistentAttribute.getJavaResourceCompilationUnit().buildASTRoot();
    }

    @Override
    public void dispose() {
    }

    @Override
    public AccessType getAccess() {
        AccessType access = this.getSpecifiedAccess();
        return access != null ? access : this.getDefaultAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.resourcePersistentAttribute.isField() ? AccessType.FIELD : AccessType.PROPERTY;
    }

    @Override
    public JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    @Override
    public PersistentType getPersistentType() {
        return this.getParent();
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getMapping().getPrimaryKeyColumnName();
    }

    @Override
    public boolean isOverridableAttribute() {
        return this.getMapping().isOverridableAttributeMapping();
    }

    @Override
    public boolean isOverridableAssociation() {
        return this.getMapping().isOverridableAssociationMapping();
    }

    @Override
    public boolean isIdAttribute() {
        return this.getMapping().isIdMapping();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    protected TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getTextRange(astRoot);
    }

    @Override
    public Embeddable getEmbeddable() {
        String typeName = this.resourcePersistentAttribute.getTypeName();
        return typeName == null ? null : this.getPersistenceUnit().getEmbeddable(typeName);
    }

    @Override
    public boolean isField() {
        return this.resourcePersistentAttribute.isField();
    }

    @Override
    public boolean isProperty() {
        return this.resourcePersistentAttribute.isProperty();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic((int)this.resourcePersistentAttribute.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal((int)this.resourcePersistentAttribute.getModifiers());
    }

    @Override
    public boolean typeIsBasic() {
        String typeName = this.resourcePersistentAttribute.getTypeName();
        if (typeName == null) {
            return false;
        }
        int arrayDepth = ClassTools.arrayDepthForTypeDeclaration((String)typeName);
        if (arrayDepth > 1) {
            return false;
        }
        if (arrayDepth == 1) {
            String elementTypeName = ClassTools.elementTypeNameForTypeDeclaration((String)typeName, (int)1);
            return this.elementTypeIsValidForBasicArray(elementTypeName);
        }
        if (ClassTools.classNamedIsVariablePrimitive((String)typeName)) {
            return true;
        }
        if (ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)typeName)) {
            return true;
        }
        if (this.typeIsOtherValidBasicType(typeName)) {
            return true;
        }
        if (this.resourcePersistentAttribute.typeIsEnum()) {
            return true;
        }
        return this.resourcePersistentAttribute.typeIsSubTypeOf(SERIALIZABLE_TYPE_NAME);
    }

    protected boolean elementTypeIsValidForBasicArray(String elementTypeName) {
        return CollectionTools.contains((Object[])VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    protected boolean typeIsOtherValidBasicType(String typeName) {
        return CollectionTools.contains((Object[])OTHER_VALID_BASIC_TYPE_NAMES, (Object)typeName);
    }

    @Override
    public String getSingleReferenceEntityTypeName() {
        return this.buildSingleReferenceEntityTypeName(this.resourcePersistentAttribute.getTypeName());
    }

    @Override
    public String getMultiReferenceEntityTypeName() {
        String typeName = this.resourcePersistentAttribute.getTypeName();
        if (typeName == null) {
            return null;
        }
        if (ClassTools.arrayDepthForTypeDeclaration((String)typeName) != 0) {
            return null;
        }
        switch (this.resourcePersistentAttribute.typeTypeArgumentNamesSize()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.typeIsCollection(typeName) ? this.resourcePersistentAttribute.getTypeTypeArgumentName(0) : null;
            }
            case 2: {
                return this.typeIsMap(typeName) ? this.resourcePersistentAttribute.getTypeTypeArgumentName(1) : null;
            }
        }
        return null;
    }

    protected String buildSingleReferenceEntityTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        if (ClassTools.arrayDepthForTypeDeclaration((String)typeName) != 0) {
            return null;
        }
        if (this.typeIsContainer(typeName)) {
            return null;
        }
        return typeName;
    }

    protected boolean typeIsCollection(String typeName) {
        return CollectionTools.contains((Object[])COLLECTION_TYPE_NAMES, (Object)typeName);
    }

    protected boolean typeIsMap(String typeName) {
        return CollectionTools.contains((Object[])MAP_TYPE_NAMES, (Object)typeName);
    }

    protected boolean typeIsContainer(String typeName) {
        return CollectionTools.contains((Object[])CONTAINER_TYPE_NAMES, (Object)typeName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    protected String buildName() {
        return this.resourcePersistentAttribute.getName();
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.specifiedMapping != null ? this.specifiedMapping : this.defaultMapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public JavaAttributeMapping getDefaultMapping() {
        return this.defaultMapping;
    }

    protected void setDefaultMapping(JavaAttributeMapping defaultMapping) {
        JavaAttributeMapping old = this.defaultMapping;
        this.defaultMapping = defaultMapping;
        this.firePropertyChanged("defaultMapping", old, defaultMapping);
    }

    protected JavaAttributeMapping buildDefaultMapping() {
        JavaAttributeMapping mapping = this.getJpaPlatform().buildDefaultJavaAttributeMapping(this);
        Annotation annotation = this.resourcePersistentAttribute.getNullMappingAnnotation(mapping.getAnnotationName());
        mapping.initialize(annotation);
        return mapping;
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMapping.getKey();
    }

    @Override
    public boolean mappingIsDefault(JavaAttributeMapping mapping) {
        return this.defaultMapping == mapping;
    }

    @Override
    public JavaAttributeMapping getSpecifiedMapping() {
        return this.specifiedMapping;
    }

    protected void setSpecifiedMapping(JavaAttributeMapping specifiedMapping) {
        JavaAttributeMapping old = this.specifiedMapping;
        this.specifiedMapping = specifiedMapping;
        this.firePropertyChanged("specifiedMapping", old, specifiedMapping);
    }

    protected String getSpecifiedMappingKey() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getKey();
    }

    @Override
    public void setSpecifiedMappingKey(String key) {
        JavaAttributeMapping newMapping;
        if (key == this.getSpecifiedMappingKey()) {
            return;
        }
        JavaAttributeMapping oldMapping = this.specifiedMapping;
        this.specifiedMapping = newMapping = this.buildMappingFromMappingKey(key);
        this.resourcePersistentAttribute.setMappingAnnotation(newMapping == null ? null : newMapping.getAnnotationName());
        this.firePropertyChanged("specifiedMapping", oldMapping, newMapping);
        if (oldMapping != null) {
            HashBag annotationsToRemove = CollectionTools.collection(oldMapping.supportingAnnotationNames());
            CollectionTools.removeAll((Collection)annotationsToRemove, this.supportingAnnotationNames());
            for (String annotationName : annotationsToRemove) {
                this.resourcePersistentAttribute.removeSupportingAnnotation(annotationName);
            }
        }
    }

    protected JavaAttributeMapping buildMappingFromMappingKey(String key) {
        if (key == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            return null;
        }
        JavaAttributeMapping mapping = this.getJpaPlatform().buildJavaAttributeMappingFromMappingKey(key, this);
        return mapping;
    }

    protected Iterator<String> supportingAnnotationNames() {
        JavaAttributeMapping mapping = this.getMapping();
        return mapping != null ? mapping.supportingAnnotationNames() : EmptyIterator.instance();
    }

    @Override
    public void update() {
        this.setName(this.buildName());
        this.updateDefaultMapping();
        this.updateSpecifiedMapping();
    }

    protected void updateDefaultMapping() {
        String defaultMappingKey = this.getJpaPlatform().getDefaultJavaAttributeMappingKey(this);
        if (this.defaultMapping.getKey() == defaultMappingKey) {
            this.defaultMapping.update(this.resourcePersistentAttribute.getNullMappingAnnotation(this.defaultMapping.getAnnotationName()));
        } else {
            JavaAttributeMapping old = this.defaultMapping;
            this.defaultMapping = this.buildDefaultMapping();
            this.firePropertyChanged("defaultMapping", old, this.defaultMapping);
        }
    }

    protected void updateSpecifiedMapping() {
        String javaMappingAnnotationName = this.getJavaMappingAnnotationName();
        if (javaMappingAnnotationName == this.getSpecifiedMappingAnnotationName()) {
            if (this.specifiedMapping != null) {
                this.specifiedMapping.update(this.resourcePersistentAttribute.getMappingAnnotation(javaMappingAnnotationName));
            }
        } else {
            this.setSpecifiedMapping(this.buildJavaAttributeMappingFromAnnotation(javaMappingAnnotationName));
        }
    }

    protected String getJavaMappingAnnotationName() {
        Annotation mappingAnnotation = this.resourcePersistentAttribute.getMappingAnnotation();
        return mappingAnnotation == null ? null : mappingAnnotation.getAnnotationName();
    }

    protected String getSpecifiedMappingAnnotationName() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getAnnotationName();
    }

    protected JavaAttributeMapping buildJavaAttributeMappingFromAnnotation(String annotationName) {
        if (annotationName == null) {
            return null;
        }
        JavaAttributeMapping mapping = this.getJpaPlatform().buildJavaAttributeMappingFromAnnotation(annotationName, this);
        mapping.initialize(this.resourcePersistentAttribute.getMappingAnnotation(annotationName));
        return mapping;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateModifiers(messages, astRoot);
        if (this.specifiedMapping != null) {
            this.specifiedMapping.validate(messages, reporter, astRoot);
        } else if (this.defaultMapping != null) {
            this.defaultMapping.validate(messages, reporter, astRoot);
        }
    }

    protected void validateModifiers(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getMappingKey() == "transient") {
            return;
        }
        if (this.isField()) {
            if (this.isFinal()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_FINAL_FIELD", astRoot));
            }
            if (this.isPublic()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", astRoot));
            }
        }
    }

    protected IMessage buildAttributeMessage(String msgID, CompilationUnit astRoot) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{this.getName()}, this, this.getValidationTextRange(astRoot));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.getMapping().javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public PersistentType getParent() {
        return (PersistentType)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }
}

