/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.resource.java.AccessAnnotation;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePersistentAttribute
extends SourcePersistentMember<Attribute>
implements JavaResourcePersistentAttribute {
    private int modifiers;
    private String typeName;
    private boolean typeIsInterface;
    private boolean typeIsEnum;
    private final Vector<String> typeSuperclassNames = new Vector();
    private final Vector<String> typeInterfaceNames = new Vector();
    private final Vector<String> typeTypeArgumentNames = new Vector();

    static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, String name, int occurrence, JavaResourceCompilationUnit javaResourceCompilationUnit, CompilationUnit astRoot) {
        JDTFieldAttribute attribute = new JDTFieldAttribute(declaringType, name, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentAttribute jrpa = new SourcePersistentAttribute(parent, attribute);
        jrpa.initialize(astRoot);
        return jrpa;
    }

    static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, MethodSignature signature, int occurrence, JavaResourceCompilationUnit javaResourceCompilationUnit, CompilationUnit astRoot) {
        JDTMethodAttribute attribute = JDTMethodAttribute.newInstance(declaringType, signature, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentAttribute jrpa = new SourcePersistentAttribute(parent, attribute);
        jrpa.initialize(astRoot);
        return jrpa;
    }

    private SourcePersistentAttribute(JavaResourcePersistentType parent, Attribute attribute) {
        super(parent, attribute);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.modifiers = this.buildModifiers(astRoot);
        this.typeName = this.buildTypeName(astRoot);
        this.typeIsInterface = this.buildTypeIsInterface(astRoot);
        this.typeIsEnum = this.buildTypeIsEnum(astRoot);
        this.typeSuperclassNames.addAll(this.buildTypeSuperclassNames(astRoot));
        this.typeInterfaceNames.addAll(this.buildTypeInterfaceNames(astRoot));
        this.typeTypeArgumentNames.addAll(this.buildTypeTypeArgumentNames(astRoot));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setTypeName(this.buildTypeName(astRoot));
        this.setTypeSuperclassNames(this.buildTypeSuperclassNames(astRoot));
        this.setTypeInterfaceNames(this.buildTypeInterfaceNames(astRoot));
        this.setTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(astRoot));
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setModifiers(this.buildModifiers(astRoot));
        this.setTypeName(this.buildTypeName(astRoot));
        this.setTypeIsInterface(this.buildTypeIsInterface(astRoot));
        this.setTypeIsEnum(this.buildTypeIsEnum(astRoot));
        this.setTypeSuperclassNames(this.buildTypeSuperclassNames(astRoot));
        this.setTypeInterfaceNames(this.buildTypeInterfaceNames(astRoot));
        this.setTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildAttributeMappingAnnotation(this, (Attribute)this.member, mappingAnnotationName);
    }

    @Override
    Annotation buildSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildAttributeSupportingAnnotation(this, (Attribute)this.member, annotationName);
    }

    @Override
    Annotation buildNullSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeSupportingAnnotation(this, annotationName);
    }

    @Override
    public Annotation getNullMappingAnnotation(String annotationName) {
        return annotationName == null ? null : this.buildNullMappingAnnotation(annotationName);
    }

    private Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeMappingAnnotation(this, annotationName);
    }

    @Override
    ListIterator<String> validMappingAnnotationNames() {
        return this.getAnnotationProvider().attributeMappingAnnotationNames();
    }

    @Override
    ListIterator<String> validSupportingAnnotationNames() {
        return this.getAnnotationProvider().attributeSupportingAnnotationNames();
    }

    @Override
    public boolean isFor(MethodSignature signature, int occurrence) {
        return ((MethodAttribute)this.member).matches(signature, occurrence);
    }

    @Override
    public String getName() {
        return ((Attribute)this.member).getAttributeName();
    }

    @Override
    public boolean isField() {
        return ((Attribute)this.member).isField();
    }

    @Override
    public boolean isProperty() {
        return !this.isField();
    }

    @Override
    public boolean hasAnyPersistenceAnnotations() {
        return this.mappingAnnotationsSize() > 0 || this.supportingAnnotationsSize() > 0;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        AccessAnnotation accessAnnotation = (AccessAnnotation)this.getSupportingAnnotation("javax.persistence.Access");
        return accessAnnotation == null ? null : accessAnnotation.getValue();
    }

    @Override
    public boolean typeIsSubTypeOf(String tn) {
        if (this.typeName == null) {
            return false;
        }
        return this.typeName.equals(tn) || this.typeInterfaceNames.contains(tn) || this.typeSuperclassNames.contains(tn);
    }

    @Override
    public boolean typeIsVariablePrimitive() {
        return this.typeName != null && ClassTools.classNamedIsVariablePrimitive((String)this.typeName);
    }

    private ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        return ((Attribute)this.member).getTypeBinding(astRoot);
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void setModifiers(int modifiers) {
        int old = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChanged("modifiers", old, modifiers);
    }

    private int buildModifiers(CompilationUnit astRoot) {
        IBinding binding = ((Attribute)this.member).getBinding(astRoot);
        return binding == null ? 0 : binding.getModifiers();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    private void setTypeName(String typeName) {
        String old = this.typeName;
        this.typeName = typeName;
        this.firePropertyChanged("typeName", old, typeName);
    }

    private String buildTypeName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        return typeBinding == null ? null : typeBinding.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean typeIsInterface() {
        return this.typeIsInterface;
    }

    private void setTypeIsInterface(boolean typeIsInterface) {
        boolean old = this.typeIsInterface;
        this.typeIsInterface = typeIsInterface;
        this.firePropertyChanged("typeIsInterface", old, typeIsInterface);
    }

    private boolean buildTypeIsInterface(CompilationUnit astRoot) {
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isInterface();
    }

    @Override
    public boolean typeIsEnum() {
        return this.typeIsEnum;
    }

    private void setTypeIsEnum(boolean typeIsEnum) {
        boolean old = this.typeIsEnum;
        this.typeIsEnum = typeIsEnum;
        this.firePropertyChanged("typeIsEnum", old, typeIsEnum);
    }

    private boolean buildTypeIsEnum(CompilationUnit astRoot) {
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isEnum();
    }

    @Override
    public ListIterator<String> typeSuperclassNames() {
        return new CloneListIterator(this.typeSuperclassNames);
    }

    private void setTypeSuperclassNames(List<String> typeSuperclassNames) {
        this.synchronizeList(typeSuperclassNames, this.typeSuperclassNames, "typeSuperclassNames");
    }

    private List<String> buildTypeSuperclassNames(CompilationUnit astRoot) {
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        typeBinding = typeBinding.getSuperclass();
        while (typeBinding != null) {
            names.add(typeBinding.getQualifiedName());
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    @Override
    public Iterator<String> typeInterfaceNames() {
        return new CloneIterator(this.typeInterfaceNames);
    }

    private void setTypeInterfaceNames(Collection<String> typeInterfaceNames) {
        this.synchronizeCollection(typeInterfaceNames, this.typeInterfaceNames, "typeInterfaceNames");
    }

    private Collection<String> buildTypeInterfaceNames(CompilationUnit astRoot) {
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        if (typeBinding == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        while (typeBinding != null) {
            this.addInterfaceNamesTo(typeBinding, names);
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    private void addInterfaceNamesTo(ITypeBinding typeBinding, HashSet<String> names) {
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            names.add(interfaceBinding.getQualifiedName());
            this.addInterfaceNamesTo(interfaceBinding, names);
            ++n2;
        }
    }

    @Override
    public ListIterator<String> typeTypeArgumentNames() {
        return new CloneListIterator(this.typeTypeArgumentNames);
    }

    @Override
    public int typeTypeArgumentNamesSize() {
        return this.typeTypeArgumentNames.size();
    }

    @Override
    public String getTypeTypeArgumentName(int index) {
        return this.typeTypeArgumentNames.get(index);
    }

    private void setTypeTypeArgumentNames(List<String> typeTypeArgumentNames) {
        this.synchronizeList(typeTypeArgumentNames, this.typeTypeArgumentNames, "typeTypeArgumentNames");
    }

    private List<String> buildTypeTypeArgumentNames(CompilationUnit astRoot) {
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArguments.length);
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            if (typeArgument == null) {
                names.add(null);
            } else {
                names.add(typeArgument.getTypeDeclaration().getQualifiedName());
            }
            ++n2;
        }
        return names;
    }
}

