/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizationsHelper;
import org.eclipse.jst.pagedesigner.editors.palette.IEntryChangeListener;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteConstants;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteHelper;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public class PaletteItemManager
implements IPaletteItemManager,
IPaletteConstants {
    private static Map _managers = new HashMap();
    private List _categories = new ArrayList();
    private IProject _curProject = null;
    private IEntryChangeListener[] _listeners;
    private static PaletteItemManager _defaultManager = null;
    private static PaletteItemManager _currentInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaletteItemManager getInstance(IProject project) {
        if (project == null) {
            return PaletteItemManager.getDefaultPaletteItemManager();
        }
        Map map = _managers;
        synchronized (map) {
            PaletteItemManager manager = (PaletteItemManager)_managers.get(project);
            if (manager == null) {
                manager = new PaletteItemManager(project);
                _managers.put(project, manager);
            }
            _currentInstance = manager;
            return manager;
        }
    }

    public static synchronized PaletteItemManager getCurrentInstance() {
        return _currentInstance;
    }

    private IProject getCurProject() {
        return this._curProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePaletteItemManager(PaletteItemManager manager) {
        Map map = _managers;
        synchronized (map) {
            _managers.remove(manager.getCurProject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPaletteItemManager() {
        Map map = _managers;
        synchronized (map) {
            _managers.clear();
        }
    }

    private static synchronized PaletteItemManager getDefaultPaletteItemManager() {
        if (_defaultManager == null) {
            _defaultManager = new PaletteItemManager(null);
        }
        return _defaultManager;
    }

    private PaletteItemManager(IProject project) {
        this._curProject = project;
        this.init();
    }

    public synchronized List getAllCategories() {
        return this._categories;
    }

    protected synchronized void init() {
        this.getAllCategories().clear();
        this.initFromProject(this._curProject);
        DesignerPaletteCustomizationsHelper.loadUserCustomizations(this);
        this.sortCategories();
    }

    private void sortCategories() {
        Collections.sort(this.getAllCategories(), new Comparator(){

            public int compare(Object o1, Object o2) {
                String label1 = ((PaletteEntry)o1).getLabel();
                String label2 = ((PaletteEntry)o2).getLabel();
                return label1.compareTo(label2);
            }
        });
    }

    public void reset() {
        this.init();
        this.fireModelChanged(null, null);
    }

    private void initFromProject(IProject project) {
        this.registerHTMLCategory();
        this.registerJSPCategory();
        this.registerTldFromClasspath(project);
    }

    private void registerHTMLCategory() {
        CMDocument doc = HTMLCMDocumentFactory.getCMDocument((String)"HTML");
        PaletteHelper.getOrCreateTaglibPaletteDrawer(this, doc, "HTML", this.getCurProject());
    }

    private void registerJSPCategory() {
        CMDocument doc = HTMLCMDocumentFactory.getCMDocument((String)"JSP11");
        PaletteHelper.getOrCreateTaglibPaletteDrawer(this, doc, "JSP11", this.getCurProject());
    }

    private void registerTldFromClasspath(IProject project) {
        if (project != null) {
            ITaglibRecord[] tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)project.getFullPath());
            int i = 0;
            while (i < tldrecs.length) {
                PaletteHelper.configPaletteItemsByTLD(this, this.getCurProject(), tldrecs[i]);
                ++i;
            }
        }
    }

    public TaglibPaletteDrawer findOrCreateCategory(String id, String label) {
        TaglibPaletteDrawer category2;
        for (TaglibPaletteDrawer category2 : this.getAllCategories()) {
            if (!id.equals(category2.getId())) continue;
            return category2;
        }
        category2 = this.createTaglibPaletteDrawer(id, label);
        return category2;
    }

    public TaglibPaletteDrawer findCategoryByURI(String uri) {
        for (TaglibPaletteDrawer category : this.getAllCategories()) {
            if (!uri.equals(category.getURI())) continue;
            return category;
        }
        return null;
    }

    public TaglibPaletteDrawer createTaglibPaletteDrawer(String uri, String label) {
        TaglibPaletteDrawer r = new TaglibPaletteDrawer(uri, label);
        this.getAllCategories().add(r);
        return r;
    }

    public TaglibPaletteDrawer getTaglibPalletteDrawer(String uri) {
        for (TaglibPaletteDrawer cat : this.getAllCategories()) {
            if (!uri.equals(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    public void addEntryChangeListener(IEntryChangeListener listener) {
        if (this._listeners == null) {
            this._listeners = new IEntryChangeListener[]{listener};
        } else {
            IEntryChangeListener[] newListeners = new IEntryChangeListener[this._listeners.length + 1];
            newListeners[0] = listener;
            System.arraycopy(this._listeners, 0, newListeners, 1, this._listeners.length);
            this._listeners = newListeners;
        }
    }

    public void removeEntryChangeListener(IEntryChangeListener listener) {
        if (this._listeners == null) {
            return;
        }
        if (this._listeners.length == 1) {
            this._listeners = null;
        } else {
            ArrayList<IEntryChangeListener> newListenersList = new ArrayList<IEntryChangeListener>(Arrays.asList(this._listeners));
            newListenersList.remove(listener);
            IEntryChangeListener[] newListeners = new IEntryChangeListener[newListenersList.size() - 1];
            newListeners = newListenersList.toArray(newListeners);
            this._listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChanged(List oldDefinitions, List newDefinitions) {
        if (this._listeners == null) {
            return;
        }
        IEntryChangeListener[] iEntryChangeListenerArray = this._listeners;
        synchronized (this._listeners) {
            int i = 0;
            while (i < this._listeners.length) {
                this._listeners[i].modelChanged(oldDefinitions, newDefinitions);
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public IProject getProject() {
        return this.getCurProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPaletteItemManagersOfCustomizationsUpdate(IPaletteItemManager notifyingManager) {
        Map map = _managers;
        synchronized (map) {
            for (PaletteItemManager mgr : _managers.values()) {
                if (mgr == null || notifyingManager == mgr) continue;
                mgr.reset();
            }
        }
    }
}

