/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.AbstractDropLocationStrategy;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;

public class DefaultDropLocationStrategy
extends AbstractDropLocationStrategy {
    private static final int DROP_HINT_VERTICAL_OFFSET = 20;

    public DefaultDropLocationStrategy(EditPartViewer viewer) {
        super(viewer);
    }

    public DesignPosition calculateDesignPosition(EditPart host, Point p, IPositionMediator validator) {
        return EditPartPositionHelper.findEditPartPosition(host, p, validator);
    }

    public List showTargetFeedback(EditPart host, DesignPosition position, DropRequest request) {
        ArrayList<Object> feedback = new ArrayList<Object>(4);
        feedback.add(this.showFeedbackRect(this.createCaretBounds(position)));
        feedback.add(this.showDropHintLabel(request.getLocation(), position));
        return feedback;
    }

    protected final RectangleFigure showFeedbackRect(Rectangle rect) {
        RectangleFigure pf = this.createFeedbackFigure();
        pf.translateToRelative((Translatable)rect);
        pf.setBounds(rect);
        return pf;
    }

    protected Rectangle createCaretBounds(DesignPosition position) {
        Rectangle rect = EditPartPositionHelper.convertToAbsoluteCaretRect(position);
        rect = rect.intersect(this.getFeedbackLayer().getBounds());
        return rect;
    }

    protected RectangleFigure createFeedbackFigure() {
        RectangleFigure feedbackFigure = new RectangleFigure();
        feedbackFigure.setFill(true);
        feedbackFigure.setOutline(true);
        feedbackFigure.setLineWidth(1);
        feedbackFigure.setForegroundColor(ColorConstants.red);
        feedbackFigure.setBounds(new Rectangle(0, 0, 0, 0));
        feedbackFigure.setXOR(true);
        this.addFeedback((IFigure)feedbackFigure);
        return feedbackFigure;
    }

    protected final Label showDropHintLabel(Point mousePosition, DesignPosition position) {
        Label dropHintLabel = new Label();
        dropHintLabel.setOpaque(true);
        dropHintLabel.setBackgroundColor(ColorConstants.tooltipBackground);
        dropHintLabel.setBorder((Border)new LineBorder(ColorConstants.black, 1){

            public Insets getInsets(IFigure figure) {
                return new Insets(this.getWidth() + 1);
            }
        });
        this.addFeedback((IFigure)dropHintLabel);
        String hintText = this.getDropHintText(position);
        dropHintLabel.setText(hintText);
        Dimension hintSize = dropHintLabel.getPreferredSize();
        Point hintLocation = new Point(mousePosition.x, mousePosition.y + 20);
        Rectangle hintRect = new Rectangle(hintLocation, hintSize);
        hintRect = hintRect.intersect(this.getFeedbackLayer().getBounds());
        dropHintLabel.translateToRelative((Translatable)hintRect);
        dropHintLabel.setBounds(hintRect);
        return dropHintLabel;
    }

    protected String getDropHintText(DesignPosition position) {
        StringBuffer buffer = new StringBuffer("Place");
        EditPart prevPart = position.getSiblingEditPart(false);
        EditPart nextPart = position.getSiblingEditPart(true);
        if (nextPart instanceof ElementEditPart) {
            buffer.append(" before ");
            buffer.append(((ElementEditPart)nextPart).getTagConvert().getHostElement().getNodeName());
            buffer.append(",");
        }
        if (prevPart instanceof ElementEditPart) {
            buffer.append(" after ");
            buffer.append(((ElementEditPart)prevPart).getTagConvert().getHostElement().getNodeName());
            buffer.append(",");
        }
        buffer.append(" inside ");
        buffer.append(position.getContainerNode().getNodeName());
        return buffer.toString();
    }
}

