/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoProxyConstants;
import org.eclipse.jem.internal.beaninfo.core.BeaninfosDoc;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.JavaStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;

public final class Utilities {
    private Utilities() {
    }

    public static JavaClass getJavaClass(String className, ResourceSet rset) {
        return (JavaClass)Utilities.getJavaType(className, rset);
    }

    public static JavaHelpers getJavaType(String className, ResourceSet rset) {
        return (JavaHelpers)rset.getEObject(Utilities.getJavaClassURI(className), true);
    }

    public static URI getJavaClassURI(String className) {
        return JavaRefFactory.eINSTANCE.createTypeURI(className);
    }

    public static EClassifier getJavaClass(IBeanTypeProxy type, ResourceSet rset) {
        if (type != null) {
            return Utilities.getJavaType(type.getFormalTypeName(), rset);
        }
        return null;
    }

    public static Method getMethod(IMethodProxy method, ResourceSet rset) {
        return method != null ? (Method)rset.getEObject(URI.createURI((String)Utilities.getMethodURL(method)), true) : null;
    }

    public static String getMethodURL(IMethodProxy method) {
        String className = method.getClassType().getTypeName();
        IBeanTypeProxy[] parms = method.getParameterTypes();
        String[] parmTypes = parms.length > 0 ? new String[parms.length] : null;
        int i = 0;
        while (i < parms.length) {
            parmTypes[i] = parms[i].getFormalTypeName();
            ++i;
        }
        return Utilities.computeMethodURL(className, method.getName(), parmTypes);
    }

    protected static String computeMethodURL(String fullyQualifiedClassName, String methodName, String[] parmTypes) {
        int classStart = fullyQualifiedClassName.lastIndexOf(46);
        StringBuffer url = new StringBuffer(50);
        url.append("java:/");
        if (classStart > -1) {
            url.append(fullyQualifiedClassName.substring(0, classStart));
        }
        url.append('#');
        url.append(Utilities.computeMethodID(fullyQualifiedClassName.substring(classStart + 1), methodName, parmTypes));
        return url.toString();
    }

    protected static String computeFieldURL(String fullyQualifiedClassName, String fieldName) {
        int classStart = fullyQualifiedClassName.lastIndexOf(46);
        StringBuffer url = new StringBuffer(50);
        url.append("java:/");
        if (classStart > -1) {
            url.append(fullyQualifiedClassName.substring(0, classStart));
        }
        url.append('#');
        url.append(fullyQualifiedClassName.substring(classStart + 1));
        url.append('.');
        url.append(fieldName);
        return url.toString();
    }

    public static URI getFieldURI(String fullyQualifiedClassName, String fieldName) {
        return URI.createURI((String)Utilities.computeFieldURL(fullyQualifiedClassName, fieldName));
    }

    public static URI getMethodURI(String fullyQualifiedClassName, String methodName, String[] parmTypes) {
        return URI.createURI((String)Utilities.computeMethodURL(fullyQualifiedClassName, methodName, parmTypes));
    }

    public static URI getMethodURI(IMethodProxy method) {
        return URI.createURI((String)Utilities.getMethodURL(method));
    }

    public static String computeMethodID(String className, String methodName, String[] parameterTypes) {
        StringBuffer out = new StringBuffer(50);
        out.append(className);
        out.append('.');
        out.append(methodName);
        out.append('(');
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                out.append(parameterTypes[i]);
                if (i < parameterTypes.length - 1) {
                    out.append(',');
                }
                ++i;
            }
        }
        if (className.equals(methodName)) {
            out.append("_V");
        }
        return out.toString();
    }

    public static BeanDecorator getBeanDecorator(EModelElement model) {
        return (BeanDecorator)Utilities.getDecorator(model, BeanDecorator.class);
    }

    public static EAnnotation getDecorator(EModelElement model, Class decoratorClass) {
        for (EAnnotation decr : model.getEAnnotations()) {
            if (!decoratorClass.isInstance(decr)) continue;
            return decr;
        }
        return null;
    }

    public static EventSetDecorator getEventSetDecorator(EModelElement model) {
        return (EventSetDecorator)Utilities.getDecorator(model, EventSetDecorator.class);
    }

    public static MethodDecorator getMethodDecorator(EModelElement model) {
        return (MethodDecorator)Utilities.getDecorator(model, MethodDecorator.class);
    }

    public static PropertyDecorator getPropertyDecorator(EModelElement model) {
        return (PropertyDecorator)Utilities.getDecorator(model, PropertyDecorator.class);
    }

    public static Iterator getPropertiesIterator(EList properties) {
        return new Iterator(properties){
            private Iterator itr;
            private boolean hasNext;
            private PropertyDecorator next;
            {
                this.itr = eList.iterator();
                this.hasNext = true;
                this.findNext();
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Object next() {
                PropertyDecorator temp = this.next;
                this.findNext();
                return temp;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void findNext() {
                while (this.itr.hasNext()) {
                    EModelElement nextOne = (EModelElement)this.itr.next();
                    this.next = Utilities.getPropertyDecorator(nextOne);
                    if (this.next == null) continue;
                    return;
                }
                this.hasNext = false;
            }
        };
    }

    public static Iterator getEventSetsIterator(EList events) {
        return new Iterator(events){
            private Iterator itr;
            private boolean hasNext;
            private EventSetDecorator next;
            {
                this.itr = eList.iterator();
                this.hasNext = true;
                this.findNext();
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Object next() {
                EventSetDecorator temp = this.next;
                this.findNext();
                return temp;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void findNext() {
                while (this.itr.hasNext()) {
                    EModelElement nextOne = (EModelElement)this.itr.next();
                    this.next = Utilities.getEventSetDecorator(nextOne);
                    if (this.next == null) continue;
                    return;
                }
                this.hasNext = false;
            }
        };
    }

    public static Iterator getMethodsIterator(EList methods) {
        return new Iterator(methods){
            private Iterator itr;
            private boolean hasNext;
            private MethodDecorator next;
            {
                this.itr = eList.iterator();
                this.hasNext = true;
                this.findNext();
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Object next() {
                MethodDecorator temp = this.next;
                this.findNext();
                return temp;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void findNext() {
                while (this.itr.hasNext()) {
                    EModelElement nextOne = (EModelElement)this.itr.next();
                    this.next = Utilities.getMethodDecorator(nextOne);
                    if (this.next == null) continue;
                    return;
                }
                this.hasNext = false;
            }
        };
    }

    public static IArrayBeanProxy getBeanInfoSearchPath(ProxyFactoryRegistry registry) {
        BeaninfoProxyConstants biconstants = BeaninfoProxyConstants.getConstants(registry);
        if (biconstants != null) {
            return (IArrayBeanProxy)biconstants.getGetBeanInfoSearchPathProxy().invokeCatchThrowableExceptions(null);
        }
        return null;
    }

    public static void setBeanInfoSearchPath(ProxyFactoryRegistry registry, String[] paths) {
        try {
            BeaninfoProxyConstants biConstants = BeaninfoProxyConstants.getConstants(registry);
            if (biConstants != null) {
                JavaStandardBeanProxyConstants jConstants = JavaStandardBeanProxyConstants.getConstants((ProxyFactoryRegistry)registry);
                IStandardBeanProxyFactory proxyFactory = registry.getBeanProxyFactory();
                IArrayBeanProxy newPath = proxyFactory.createBeanProxyWith(jConstants.getStringType(), paths != null ? paths.length : 0);
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        newPath.set((IBeanProxy)proxyFactory.createBeanProxyWith(paths[i]), i);
                        ++i;
                    }
                }
                biConstants.getSetBeanInfoSearchPathProxy().invoke(null, (IBeanProxy)newPath);
            }
        }
        catch (ThrowableProxy throwableProxy) {}
    }

    public static void insertBeanInfoSearchPath(BeaninfoNature nature, IBeaninfosDocEntry path, int index) throws CoreException {
        BeaninfosDoc infoPath = nature.getSearchPath();
        IBeaninfosDocEntry[] oldPath = infoPath.getSearchpath();
        IBeaninfosDocEntry[] newPath = new IBeaninfosDocEntry[oldPath.length + 1];
        if (index == -1 || index >= oldPath.length) {
            System.arraycopy(oldPath, 0, newPath, 0, oldPath.length);
            newPath[oldPath.length] = path;
        } else {
            System.arraycopy(oldPath, 0, newPath, 0, index);
            newPath[index] = path;
            System.arraycopy(oldPath, index, newPath, index + 1, oldPath.length - index);
        }
        infoPath.setSearchpath(newPath);
        nature.setSearchPath(infoPath);
    }

    public static void insertBeanInfoSearchPath(ProxyFactoryRegistry registry, String path, int index) {
        try {
            BeaninfoProxyConstants biConstants = BeaninfoProxyConstants.getConstants(registry);
            if (biConstants != null) {
                IArrayBeanProxy infoPath = (IArrayBeanProxy)biConstants.getGetBeanInfoSearchPathProxy().invoke(null);
                int pathLength = infoPath.getLength();
                IStandardBeanProxyFactory proxyFactory = registry.getBeanProxyFactory();
                IArrayBeanProxy newPath = proxyFactory.createBeanProxyWith(infoPath.getTypeProxy(), pathLength + 1);
                IStringBeanProxy stringProxy = proxyFactory.createBeanProxyWith(path);
                JavaStandardBeanProxyConstants constants = JavaStandardBeanProxyConstants.getConstants((ProxyFactoryRegistry)registry);
                if (index == -1 || index >= pathLength) {
                    constants.arraycopy((IBeanProxy)infoPath, 0, (IBeanProxy)newPath, 0, infoPath.getLength());
                    newPath.set((IBeanProxy)stringProxy, pathLength);
                } else {
                    constants.arraycopy((IBeanProxy)infoPath, 0, (IBeanProxy)newPath, 0, index);
                    newPath.set((IBeanProxy)stringProxy, index);
                    constants.arraycopy((IBeanProxy)infoPath, index, (IBeanProxy)newPath, index + 1, pathLength - index);
                }
                biConstants.getSetBeanInfoSearchPathProxy().invoke(null, (IBeanProxy)newPath);
            }
        }
        catch (ThrowableProxy throwableProxy) {}
    }

    public static void removeBeanInfoPath(BeaninfoNature nature, IBeaninfosDocEntry path) throws CoreException {
        BeaninfosDoc infoPath = nature.getSearchPath();
        IBeaninfosDocEntry[] oldPath = infoPath.getSearchpath();
        int i = 0;
        while (i < oldPath.length) {
            if (path.equals(oldPath[i])) {
                IBeaninfosDocEntry[] newPath = new IBeaninfosDocEntry[oldPath.length - 1];
                System.arraycopy(oldPath, 0, newPath, 0, i);
                if (i < oldPath.length - 1) {
                    System.arraycopy(oldPath, i + 1, newPath, i, oldPath.length - i - 1);
                }
                infoPath.setSearchpath(newPath);
                nature.setSearchPath(infoPath);
                return;
            }
            ++i;
        }
    }

    public static void removeBeanInfoPath(ProxyFactoryRegistry registry, String path) {
        try {
            BeaninfoProxyConstants biConstants = BeaninfoProxyConstants.getConstants(registry);
            if (biConstants != null) {
                IArrayBeanProxy infoPath = (IArrayBeanProxy)biConstants.getGetBeanInfoSearchPathProxy().invoke(null);
                int pathLength = infoPath.getLength();
                int i = 0;
                while (i < pathLength) {
                    IStringBeanProxy aPath = (IStringBeanProxy)infoPath.get(i);
                    if (path.equals(aPath.stringValue())) {
                        IArrayBeanProxy newPath = registry.getBeanProxyFactory().createBeanProxyWith(infoPath.getTypeProxy(), pathLength - 1);
                        JavaStandardBeanProxyConstants constants = JavaStandardBeanProxyConstants.getConstants((ProxyFactoryRegistry)registry);
                        constants.arraycopy((IBeanProxy)infoPath, 0, (IBeanProxy)newPath, 0, i);
                        if (i < pathLength - 1) {
                            constants.arraycopy((IBeanProxy)infoPath, i + 1, (IBeanProxy)newPath, i, pathLength - i - 1);
                        }
                        biConstants.getSetBeanInfoSearchPathProxy().invoke(null, (IBeanProxy)newPath);
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (ThrowableProxy throwableProxy) {}
    }
}

