/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobListener;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;

public abstract class SubmitJob
extends TaskJob {
    private final List<SubmitJobListener> submitJobListeners = Collections.synchronizedList(new ArrayList());
    protected final IDelegatingProgressMonitor monitor = new DelegatingProgressMonitor();

    public SubmitJob(String name) {
        super(name);
    }

    public void addSubmitJobListener(SubmitJobListener listener) {
        this.submitJobListeners.add(listener);
    }

    public void removeSubmitJobListener(SubmitJobListener listener) {
        this.submitJobListeners.remove(listener);
    }

    protected SubmitJobListener[] getSubmitJobListeners() {
        return this.submitJobListeners.toArray(new SubmitJobListener[0]);
    }

    protected void fireTaskSubmitted(IProgressMonitor monitor) throws CoreException {
        SubmitJobListener[] listeners = this.submitJobListeners.toArray(new SubmitJobListener[0]);
        if (listeners.length > 0) {
            SubmitJobEvent event = new SubmitJobEvent(this);
            SubmitJobListener[] submitJobListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                SubmitJobListener listener = submitJobListenerArray[n2];
                listener.taskSubmitted(event, Policy.subMonitorFor((IProgressMonitor)monitor, (int)100));
                ++n2;
            }
        }
    }

    protected void fireTaskSynchronized(IProgressMonitor monitor) throws CoreException {
        SubmitJobListener[] listeners = this.submitJobListeners.toArray(new SubmitJobListener[0]);
        if (listeners.length > 0) {
            SubmitJobEvent event = new SubmitJobEvent(this);
            SubmitJobListener[] submitJobListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                SubmitJobListener listener = submitJobListenerArray[n2];
                listener.taskSynchronized(event, Policy.subMonitorFor((IProgressMonitor)monitor, (int)100));
                ++n2;
            }
        }
    }

    protected void fireDone() {
        SubmitJobListener[] listeners = this.submitJobListeners.toArray(new SubmitJobListener[0]);
        if (listeners.length > 0) {
            final SubmitJobEvent event = new SubmitJobEvent(this);
            SubmitJobListener[] submitJobListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final SubmitJobListener listener = submitJobListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed", e));
                    }

                    public void run() throws Exception {
                        listener.done(event);
                    }
                });
                ++n2;
            }
        }
    }

    public abstract ITask getTask();

    public abstract RepositoryResponse getResponse();

    public IDelegatingProgressMonitor getMonitor() {
        return this.monitor;
    }
}

