/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptorManager;
import org.eclipse.ui.internal.navigator.sorters.SkeletonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class NavigatorSorterService
implements INavigatorSorterService {
    private final NavigatorContentService contentService;
    private final Map sorters = new HashMap();

    public NavigatorSorterService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public ViewerSorter findSorterForParent(Object aParent) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(this.contentService, aParent);
        if (descriptors.length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return SkeletonViewerSorter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerSorter getSorter(CommonSorterDescriptor descriptor) {
        ViewerSorter sorter = null;
        Map map = this.sorters;
        synchronized (map) {
            sorter = (ViewerSorter)this.sorters.get(descriptor);
            if (sorter == null) {
                sorter = descriptor.createSorter();
                this.sorters.put(descriptor, sorter);
            }
        }
        return sorter;
    }

    public ViewerSorter findSorter(INavigatorContentDescriptor source, Object parent, Object lvalue, Object rvalue) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(this.contentService, source, parent, lvalue, rvalue);
        if (descriptors.length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return null;
    }

    public Map findAvailableSorters(INavigatorContentDescriptor theSource) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(theSource);
        HashMap<String, ViewerSorter> sorters = new HashMap<String, ViewerSorter>();
        int count = 0;
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId() != null && descriptors[i].getId().length() > 0) {
                sorters.put(descriptors[i].getId(), this.getSorter(descriptors[i]));
            } else {
                sorters.put(String.valueOf(theSource.getId()) + ".sorter." + ++count, this.getSorter(descriptors[i]));
            }
            ++i;
        }
        return sorters;
    }
}

