/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.plugin.EnvPlugin;
import org.eclipse.wst.command.internal.env.ui.EnvironmentUIMessages;
import org.eclipse.wst.command.internal.env.ui.dialog.AntExtension;
import org.eclipse.wst.command.internal.env.ui.dialog.AntExtensionCreation;
import org.eclipse.wst.command.internal.env.ui.dialog.AntFileImportWizardPage;
import org.eclipse.wst.command.internal.env.ui.plugin.EnvUIPlugin;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.NullStatusHandler;
import org.osgi.framework.Bundle;

public class AntFileImportWizard
extends Wizard
implements INewWizard {
    private AntFileImportWizardPage mainPage;
    private IWorkbench workbench;
    private AntExtensionCreation antExtC_;
    protected IStructuredSelection selection;
    static /* synthetic */ Class class$0;

    public AntFileImportWizard() {
        this.setWindowTitle(EnvironmentUIMessages.WIZARD_TITLE_ANT);
    }

    public void setWindowTitle(String newTitle) {
        super.setWindowTitle(newTitle);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new AntFileImportWizardPage(EnvironmentUIMessages.WIZARD_PAGE_TITLE_ANT, this.getSelection());
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        Path propertyPath;
        this.antExtC_ = AntExtensionCreation.getInstance();
        IPath destination = this.mainPage.getPath();
        if (destination == null) {
            return false;
        }
        AntExtension antExt = this.antExtC_.getAnrExtByScenario(this.mainPage.getScenario());
        Bundle wsBundle = Platform.getBundle((String)antExt.getPlugin());
        URL propertyURL = FileLocator.find((Bundle)wsBundle, (IPath)(propertyPath = new Path(antExt.getPath())), null);
        if (propertyURL == null) {
            this.mainPage.displayErrorDialog(NLS.bind((String)EnvironmentUIMessages.MSG_ERR_ANT_FILES_NOT_FOUND, (Object)antExt.getPath()));
            return false;
        }
        InputStream isProperty = null;
        try {
            URLConnection conn = propertyURL.openConnection();
            isProperty = conn.getInputStream();
        }
        catch (IOException iOException) {}
        EnvPlugin sourcePlugin = EnvPlugin.getInstance();
        String targetFile = antExt.getPath();
        this.createIFile((Plugin)sourcePlugin, isProperty, destination, targetFile, (IProgressMonitor)new NullProgressMonitor());
        Path wsgenPath = new Path(antExt.getWSGenPath());
        URL fileURL = FileLocator.find((Bundle)wsBundle, (IPath)wsgenPath, null);
        if (fileURL == null) {
            this.mainPage.displayErrorDialog(NLS.bind((String)EnvironmentUIMessages.MSG_ERR_ANT_FILES_NOT_FOUND, (Object)antExt.getWSGenPath()));
            return false;
        }
        InputStream isWSGen = null;
        try {
            URLConnection connWSGen = fileURL.openConnection();
            isWSGen = connWSGen.getInputStream();
        }
        catch (IOException iOException) {}
        String targetFileWSGen = antExt.getWSGenPath();
        this.createIFile((Plugin)sourcePlugin, isWSGen, destination, targetFileWSGen, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus createIFile(Plugin plugin, InputStream source, IPath targetPath, String targetFile, IProgressMonitor monitor) {
        if (plugin == null) return Status.OK_STATUS;
        IPath target = targetPath.append((IPath)new Path(targetFile));
        ProgressUtils.report((IProgressMonitor)monitor, (String)EnvironmentUIMessages.MSG_STATUS_COPYING_ANT_FILES);
        try {
            TransientResourceContext context = new TransientResourceContext();
            IResource resource = FileResourceUtils.findResource((IPath)target);
            if (resource != null) {
                MessageBox overwriteBox = new MessageBox(this.getShell(), 196);
                overwriteBox.setMessage(EnvironmentUIMessages.bind((String)EnvironmentUIMessages.MSG_WARNING_FILE_EXISTS, (Object)target.toString()));
                overwriteBox.setText(EnvironmentUIMessages.DIALOG_TITLE_OVERWRITE);
                int result = overwriteBox.open();
                if (result == 128) return Status.CANCEL_STATUS;
                FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)source, (IProgressMonitor)monitor, (IStatusHandler)new NullStatusHandler());
                return Status.OK_STATUS;
            } else {
                FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)source, (IProgressMonitor)monitor, (IStatusHandler)new NullStatusHandler());
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)EnvironmentUIMessages.MSG_ERR_COPYING_ANT_FILES, (Throwable)e);
        }
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = EnvUIPlugin.getImageDescriptor("icons/full/wizban/newantfiles_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected void selectAndReveal(IResource newResource) {
        AntFileImportWizard.selectAndReveal(newResource, this.getWorkbench().getActiveWorkbenchWindow());
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }
}

