/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetCompile;
import org.apache.tools.ant.taskdefs.optional.dotnet.DotnetResource;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class VisualBasicCompile
extends DotnetCompile {
    private boolean removeIntChecks = false;
    private boolean optionExplicit = false;
    private boolean optionStrict = false;
    private String optionCompare;
    private String rootNamespace;
    private String imports;

    public VisualBasicCompile() {
        this.clear();
    }

    public void clear() {
        super.clear();
        this.imports = null;
        this.rootNamespace = null;
        this.optionCompare = null;
        this.optionExplicit = false;
        this.optionStrict = false;
        this.removeIntChecks = false;
        this.setExecutable("vbc");
    }

    protected String getWin32ResParameter() {
        if (this.getWin32Res() != null) {
            return "/win32resource:" + this.getWin32Res().toString();
        }
        return null;
    }

    public void setRemoveIntChecks(boolean flag) {
        this.removeIntChecks = flag;
    }

    public boolean getRemoveIntChecks() {
        return this.removeIntChecks;
    }

    public String getRemoveIntChecksParameter() {
        return "/removeintchecks" + (this.removeIntChecks ? "+" : "-");
    }

    public void setOptionExplicit(boolean flag) {
        this.optionExplicit = flag;
    }

    public boolean getOptionExplicit() {
        return this.optionExplicit;
    }

    public String getOptionExplicitParameter() {
        return "/optionexplicit" + (this.optionExplicit ? "+" : "-");
    }

    public void setOptionStrict(boolean flag) {
        this.optionStrict = flag;
    }

    public boolean getOptionStrict() {
        return this.optionStrict;
    }

    public String getOptionStrictParameter() {
        return "/optionstrict" + (this.optionStrict ? "+" : "-");
    }

    public void setRootNamespace(String rootNamespace) {
        this.rootNamespace = rootNamespace;
    }

    public String getRootNamespace() {
        return this.rootNamespace;
    }

    protected String getRootNamespaceParameter() {
        if (this.rootNamespace != null && this.rootNamespace.length() != 0) {
            return "/rootnamespace:" + this.rootNamespace;
        }
        return null;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public String getImports() {
        return this.imports;
    }

    protected String getImportsParameter() {
        if (this.imports != null && this.imports.length() != 0) {
            return "/imports:" + this.imports;
        }
        return null;
    }

    public void setOptionCompare(String optionCompare) {
        this.optionCompare = "text".equalsIgnoreCase(optionCompare) ? "text" : "binary";
    }

    public String getOptionCompare() {
        return this.optionCompare;
    }

    protected String getOptionCompareParameter() {
        if (this.optionCompare != null && "text".equalsIgnoreCase(this.optionCompare)) {
            return "/optioncompare:text";
        }
        return "/optioncompare:binary";
    }

    protected void addCompilerSpecificOptions(NetCommand command) {
        command.addArgument(this.getRemoveIntChecksParameter());
        command.addArgument(this.getImportsParameter());
        command.addArgument(this.getOptionExplicitParameter());
        command.addArgument(this.getOptionStrictParameter());
        command.addArgument(this.getRootNamespaceParameter());
        command.addArgument(this.getOptionCompareParameter());
    }

    public String getReferenceDelimiter() {
        return ",";
    }

    public String getFileExtension() {
        return "vb";
    }

    protected void createResourceParameter(NetCommand command, DotnetResource resource) {
        resource.getParameters(this.getProject(), command, false);
    }

    protected void validate() throws BuildException {
        super.validate();
        if (this.getDestFile() == null) {
            throw new BuildException("DestFile was not specified");
        }
    }
}

