/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;

public class ClassLiteralAccess
extends Expression {
    public TypeReference type;
    public TypeBinding targetType;
    FieldBinding syntheticField;

    public ClassLiteralAccess(int sourceEnd, TypeReference type) {
        this.type = type;
        type.bits |= 0x40000000;
        this.sourceStart = type.sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        SourceTypeBinding sourceType = currentScope.outerMostClassScope().enclosingSourceType();
        if (!sourceType.isInterface() && !sourceType.isBaseType() && currentScope.compilerOptions().sourceLevel < 0x310000L) {
            this.syntheticField = sourceType.addSyntheticFieldForClassLiteral(this.targetType, currentScope);
        }
        return flowInfo;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.type.print(0, output).append(".class");
    }

    public TypeBinding resolveType(BlockScope scope) {
        ReferenceBinding classType;
        this.constant = Constant.NotAConstant;
        this.targetType = this.type.resolveType(scope, true);
        if (this.targetType == null) {
            return null;
        }
        if (this.targetType.isArrayType() && ((ArrayBinding)this.targetType).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.targetType.isTypeVariable()) {
            scope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)this.targetType, this);
        }
        if ((classType = scope.getJavaLangClass()).isGenericType()) {
            TypeBinding boxedType = null;
            if (this.targetType.id == 6) {
                boxedType = scope.environment().getType(JAVA_LANG_VOID);
                if (boxedType == null) {
                    boxedType = new ProblemReferenceBinding(JAVA_LANG_VOID, null, 1);
                }
            } else {
                boxedType = scope.boxing(this.targetType);
            }
            this.resolvedType = scope.environment().createParameterizedType(classType, new TypeBinding[]{boxedType}, null);
        } else {
            this.resolvedType = classType;
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.type.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 115;
    }
}

