/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.navigator.actions;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.Category;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.LocalRepositoryNode;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.datatools.connectivity.ui.actions.DeleteAction;
import org.eclipse.datatools.connectivity.ui.actions.RenameAction;
import org.eclipse.datatools.connectivity.ui.actions.ViewPropertyAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.operations.UndoRedoActionGroup;

public class ProfileActionsActionProvider
extends CommonActionProvider {
    private StructuredViewer aViewer;
    private IStructuredSelection selection;
    private AddProfileViewAction addCPAction;
    private ViewPropertyAction propAction;
    private RenameAction renameAction;
    private DeleteAction deleteAction;
    private UndoRedoActionGroup undoRedoGroup;

    public void dispose() {
    }

    private void setSelection(IStructuredSelection selection) {
        this.selection = selection;
        this.updateActionBars();
    }

    public void setActionContext(ActionContext aContext) {
        if (aContext.getSelection() instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)aContext.getSelection());
        }
        this.undoRedoGroup.setContext(aContext);
    }

    public void fillContextMenu(IMenuManager manager) {
        boolean hasSelection = false;
        if (this.selection != null && this.selection.getFirstElement() != null) {
            hasSelection = true;
        }
        Object selObject = null;
        if (hasSelection) {
            selObject = this.selection.getFirstElement();
            if (selObject instanceof ICategory) {
                if (selObject instanceof Category) {
                    IConnectionProfile repositoryProfile = ((Category)selObject).getRepositoryProfile();
                    if (repositoryProfile != null) {
                        this.addCPAction.setParentProfile(repositoryProfile);
                    } else {
                        this.addCPAction.setParentProfile(null);
                    }
                }
                this.addCPAction.setCategory((ICategory)selObject);
                manager.insertBefore("slot1", (IAction)this.addCPAction);
            } else if (selObject instanceof LocalRepositoryNode) {
                this.addCPAction.setParentProfile(null);
                this.addCPAction.setCategory((ICategory)null);
                manager.insertBefore("slot1", (IAction)this.addCPAction);
            } else if (selObject instanceof IConnectionProfile && ((IConnectionProfile)selObject).getConnectionState() == 1 && ((IConnectionProfile)selObject).getProvider().getConnectionFactory(IConnectionProfileRepository.class.getName()) != null) {
                this.addCPAction.setCategory((ICategory)null);
                this.addCPAction.setParentProfile((IConnectionProfile)selObject);
                manager.insertBefore("slot1", (IAction)this.addCPAction);
            }
        } else {
            this.addCPAction.setCategory((ICategory)null);
            manager.insertBefore("slot1", (IAction)this.addCPAction);
        }
        if (hasSelection && ViewPropertyAction.hasContributors(selObject)) {
            manager.add((IAction)this.propAction);
        }
        this.undoRedoGroup.fillContextMenu(manager);
    }

    public void fillActionBars(IActionBars bars) {
        this.undoRedoGroup.fillActionBars(bars);
        bars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propAction);
        bars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.updateActionBars();
    }

    public void init(ICommonActionExtensionSite aConfig) {
        super.init(aConfig);
        this.aViewer = aConfig.getStructuredViewer();
        this.makeActions();
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this.undoRedoGroup = new UndoRedoActionGroup(((ICommonViewerWorkbenchSite)aConfig.getViewSite()).getSite(), workspaceContext, true);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (context.getSelection() instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)context.getSelection());
        }
    }

    private void makeActions() {
        this.addCPAction = this.createAddProfileViewAction();
        this.addCPAction.setUseSelection(false);
        this.addCPAction.setIgnoreCategory(false);
        this.addCPAction.init(this.getActionSite().getViewSite().getShell());
        this.propAction = this.createViewPropertyAction((Viewer)this.aViewer);
        this.propAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.renameAction = this.createRenameAction();
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.renameAction.setText(ConnectivityUIPlugin.getDefault().getResourceString("DSE.Rename.label"));
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setText(ConnectivityUIPlugin.getDefault().getResourceString("DSE.Delete.label"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    protected AddProfileViewAction createAddProfileViewAction() {
        return new AddProfileViewAction();
    }

    protected void setAddProfileViewAction(AddProfileViewAction action) {
        this.addCPAction = action;
    }

    protected ViewPropertyAction createViewPropertyAction(Viewer viewer) {
        return new ViewPropertyAction(viewer);
    }

    protected void setViewPropertyAction(ViewPropertyAction action) {
        this.propAction = action;
    }

    protected RenameAction createRenameAction() {
        return new RenameAction();
    }

    protected void setRenameAction(RenameAction action) {
        this.renameAction = action;
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction();
    }

    protected void setDeleteAction(DeleteAction action) {
        this.deleteAction = action;
    }

    public void updateActionBars() {
        IStructuredSelection selection = null;
        if (this.getContext().getSelection() != null) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        this.addCPAction.selectionChanged((IAction)this.addCPAction, (ISelection)selection);
        this.renameAction.selectionChanged((IAction)this.renameAction, (ISelection)selection);
        this.deleteAction.selectionChanged((IAction)this.deleteAction, (ISelection)selection);
        Object selected = selection.getFirstElement();
        boolean hasProperties = ViewPropertyAction.hasContributors(selected);
        this.propAction.setEnabled(hasProperties);
        this.undoRedoGroup.updateActionBars();
    }
}

