/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.JARFileFilter;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class BuildClasspathSection
extends TableSection
implements IModelChangedListener {
    private TableViewer fTableViewer;
    private boolean fEnabled;
    static /* synthetic */ Class class$0;

    public BuildClasspathSection(PDEFormPage page, Composite parent) {
        String[] stringArray = new String[4];
        stringArray[0] = PDEUIMessages.BuildEditor_ClasspathSection_add;
        stringArray[1] = PDEUIMessages.BuildEditor_ClasspathSection_remove;
        super(page, parent, 130, stringArray);
        this.fEnabled = true;
        this.getSection().setText(PDEUIMessages.BuildEditor_ClasspathSection_title);
        this.getSection().setDescription(PDEUIMessages.BuildEditor_ClasspathSection_desc);
        this.initialize();
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.getPage().getPDEEditor().getContextManager().findContext("build-context");
        if (context == null) {
            return null;
        }
        return (IBuildModel)context.getModel();
    }

    public void initialize() {
        this.getBuildModel().addModelChangedListener((IModelChangedListener)this);
        IBuildEntry entry = this.getBuildModel().getBuild().getEntry("jars.extra.classpath");
        this.getSection().setExpanded(entry != null && entry.getTokens().length > 0);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 65536, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(true);
        this.fTableViewer = tablePart.getTableViewer();
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fTableViewer.setInput((Object)this.getBuildModel());
        toolkit.paintBordersFor(container);
        this.enableSection(true);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        data.horizontalSpan = 2;
        section.setClient((Control)container);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.fTableViewer.getSelection();
        Action action = new Action(PDEUIMessages.BuildEditor_ClasspathSection_add){

            public void run() {
                BuildClasspathSection.this.handleNew();
            }
        };
        action.setEnabled(this.fEnabled);
        manager.add((IAction)action);
        manager.add((IContributionItem)new Separator());
        action = new Action(PDEUIMessages.BuildEditor_ClasspathSection_remove){

            public void run() {
                BuildClasspathSection.this.handleDelete();
            }
        };
        action.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)action);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    public void dispose() {
        IBuildModel model = this.getBuildModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.fEnabled) {
                this.handleDelete();
            }
            return true;
        }
        return false;
    }

    public void enableSection(boolean enable) {
        this.fEnabled = enable;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(1, enable && !this.fTableViewer.getSelection().isEmpty());
        tablePart.setButtonEnabled(0, enable);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.getTablePart().setButtonEnabled(1, selection != null && selection.size() > 0 && this.fEnabled);
    }

    private void handleDelete() {
        IBuild build;
        IBuildEntry entry;
        Object selection = ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
        if (selection != null && selection instanceof String && (entry = (build = this.getBuildModel().getBuild()).getEntry("jars.extra.classpath")) != null) {
            try {
                entry.removeToken(selection.toString());
                String[] tokens = entry.getTokens();
                if (tokens.length == 0) {
                    build.remove(entry);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void initializeDialogSettings(ElementTreeSelectionDialog dialog) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        dialog.setValidator((ISelectionStatusValidator)new ElementSelectionValidator(acceptedClasses, true));
        dialog.setTitle(PDEUIMessages.BuildEditor_ClasspathSection_jarsTitle);
        dialog.setMessage(PDEUIMessages.BuildEditor_ClasspathSection_jarsDesc);
        dialog.addFilter((ViewerFilter)new JARFileFilter());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IBuildModel model;
                IBuildEntry entry;
                if (element instanceof IProject) {
                    try {
                        return ((IProject)element).hasNature("org.eclipse.pde.PluginNature");
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                if (element instanceof IResource && (entry = (model = BuildClasspathSection.this.getBuildModel()).getBuild().getEntry("jars.extra.classpath")) != null) {
                    return !entry.contains(BuildClasspathSection.this.getRelativePathTokenName((IResource)element));
                }
                return true;
            }
        });
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)this.getBuildModel().getUnderlyingResource().getProject());
    }

    private void handleNew() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.initializeDialogSettings(dialog);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i = 0;
            while (i < elements.length) {
                IResource elem = (IResource)elements[i];
                String tokenName = this.getRelativePathTokenName(elem);
                if (tokenName != null) {
                    this.addClasspathToken(tokenName);
                }
                ++i;
            }
        }
    }

    private void addClasspathToken(String tokenName) {
        IBuildModel model = this.getBuildModel();
        IBuildEntry entry = model.getBuild().getEntry("jars.extra.classpath");
        try {
            if (entry == null) {
                entry = model.getFactory().createEntry("jars.extra.classpath");
                model.getBuild().add(entry);
            }
            if (!entry.contains(tokenName)) {
                entry.addToken(tokenName);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private String getRelativePathTokenName(IResource elem) {
        IProject thisProject = this.getBuildModel().getUnderlyingResource().getProject();
        IProject elemProject = elem.getProject();
        String projectRelative = elem.getProjectRelativePath().toString();
        if (thisProject == elemProject) {
            return projectRelative;
        }
        IPluginModelBase model = PluginRegistry.findModel((IProject)elemProject);
        if (model != null) {
            return "platform:/plugin/" + model.getPluginBase().getId() + '/' + projectRelative;
        }
        return null;
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleDelete();
                break;
            }
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        Object changeObject;
        if (event.getChangeType() == 99) {
            this.markStale();
        } else if (event.getChangeType() == 3 && (changeObject = event.getChangedObjects()[0]) instanceof IBuildEntry && ((IBuildEntry)changeObject).getName().equals("jars.extra.classpath")) {
            Table table = this.fTableViewer.getTable();
            int index = table.getSelectionIndex();
            this.fTableViewer.refresh();
            int count = table.getItemCount();
            if (index == -1 || index >= count || event.getOldValue() == null) {
                index = count - 1;
            }
            if (count == 0) {
                this.fTableViewer.setSelection(null);
            } else {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection(table.getItem(index).getData()));
            }
            table.setFocus();
        }
    }

    class ElementSelectionValidator
    implements ISelectionStatusValidator {
        private Class[] fAcceptedTypes;
        private boolean fAllowMultipleSelection;

        public ElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
            Assert.isNotNull((Object)acceptedTypes);
            this.fAcceptedTypes = acceptedTypes;
            this.fAllowMultipleSelection = allowMultipleSelection;
        }

        public IStatus validate(Object[] elements) {
            if (this.isValid(elements)) {
                return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
            }
            return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
        }

        private boolean isOfAcceptedType(Object o) {
            int i = 0;
            while (i < this.fAcceptedTypes.length) {
                if (this.fAcceptedTypes[i].isInstance(o)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isValid(Object[] selection) {
            if (selection.length == 0) {
                return false;
            }
            if (!this.fAllowMultipleSelection && selection.length != 1) {
                return false;
            }
            int i = 0;
            while (i < selection.length) {
                Object o = selection[i];
                if (!this.isOfAcceptedType(o)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IBuild build;
            IBuildEntry entry;
            if (parent instanceof IBuildModel && (entry = (build = ((IBuildModel)parent).getBuild()).getEntry("jars.extra.classpath")) != null) {
                return entry.getTokens();
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return sharedImages.getImage("IMG_OBJ_FILE");
        }
    }
}

