/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.mylyn.internal.wikitext.core.util.XML11Char;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class DefaultXmlStreamWriter
extends XmlStreamWriter {
    private PrintWriter out;
    private final Map<String, String> prefixToUri = new HashMap<String, String>();
    private final Map<String, String> uriToPrefix = new HashMap<String, String>();
    private boolean inEmptyElement = false;
    private boolean inStartElement = false;
    private final Stack<String> elements = new Stack();
    private char xmlHederQuoteChar = (char)39;

    public DefaultXmlStreamWriter(OutputStream out) throws UnsupportedEncodingException {
        this.out = this.createUtf8PrintWriter(out);
    }

    public DefaultXmlStreamWriter(Writer out) {
        this.out = new PrintWriter(out);
    }

    public DefaultXmlStreamWriter(Writer out, char xmlHeaderQuoteChar) {
        this.out = new PrintWriter(out);
        this.xmlHederQuoteChar = xmlHeaderQuoteChar;
    }

    protected PrintWriter createUtf8PrintWriter(OutputStream out) throws UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter(out, "UTF8"));
    }

    public void close() {
        if (this.out != null) {
            this.closeElement();
            this.flush();
        }
        this.out = null;
    }

    public void flush() {
        this.out.flush();
    }

    public String getPrefix(String uri) {
        return this.uriToPrefix.get(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    public void setDefaultNamespace(String uri) {
        this.setPrefix("", uri);
    }

    public void setPrefix(String prefix, String uri) {
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    public void writeAttribute(String localName, String value) {
        this.out.write(32);
        this.out.write(localName);
        this.out.write("=\"");
        if (value != null) {
            this.attrEncode(value);
        }
        this.out.write("\"");
    }

    public void writeAttribute(String namespaceURI, String localName, String value) {
        this.out.write(32);
        String prefix = this.uriToPrefix.get(namespaceURI);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
        this.out.write("=\"");
        if (value != null) {
            this.attrEncode(value);
        }
        this.out.write("\"");
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        this.out.write(32);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
        this.out.write("=\"");
        if (value != null) {
            this.attrEncode(value);
        }
        this.out.write("\"");
    }

    private void attrEncode(String value) {
        if (value == null) {
            return;
        }
        DefaultXmlStreamWriter.printEscaped(this.out, value, true);
    }

    private void encode(String text) {
        if (text == null) {
            return;
        }
        DefaultXmlStreamWriter.printEscaped(this.out, text, false);
    }

    public void writeCData(String data) {
        this.closeElement();
        this.out.write("<![CDATA[");
        this.out.write(data);
        this.out.write("]]>");
    }

    public void writeCharacters(String text) {
        this.closeElement();
        this.encode(text);
    }

    public void writeCharactersUnescaped(String text) {
        this.closeElement();
        this.out.print(text);
    }

    public void writeLiteral(String literal) {
        this.writeCharactersUnescaped(literal);
    }

    public void writeCharacters(char[] text, int start, int len) {
        this.closeElement();
        this.encode(new String(text, start, len));
    }

    public void writeComment(String data) {
        this.closeElement();
        this.out.write("<!-- ");
        this.out.write(data);
        this.out.write(" -->");
    }

    public void writeDTD(String dtd) {
        this.out.write(dtd);
    }

    public void writeDefaultNamespace(String namespaceURI) {
        this.writeAttribute("xmlns", namespaceURI);
    }

    private void closeElement() {
        if (this.inEmptyElement) {
            this.out.write("/>");
            this.inEmptyElement = false;
        } else if (this.inStartElement) {
            this.out.write(">");
            this.inStartElement = false;
        }
    }

    public void writeEmptyElement(String localName) {
        this.closeElement();
        this.inEmptyElement = true;
        this.out.write(60);
        this.out.write(localName);
    }

    public void writeEmptyElement(String namespaceURI, String localName) {
        this.closeElement();
        this.inEmptyElement = true;
        String prefix = this.uriToPrefix.get(namespaceURI);
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        this.closeElement();
        this.inEmptyElement = true;
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
    }

    public void writeEndDocument() {
        if (!this.elements.isEmpty()) {
            throw new IllegalStateException(String.valueOf(this.elements.size()) + " elements not closed");
        }
    }

    public void writeEndElement() {
        this.closeElement();
        if (this.elements.isEmpty()) {
            throw new IllegalStateException();
        }
        String name = this.elements.pop();
        this.out.write(60);
        this.out.write(47);
        this.out.write(name);
        this.out.write(62);
    }

    public void writeEntityRef(String name) {
        this.closeElement();
        this.out.write(38);
        this.out.write(name);
        this.out.write(59);
    }

    public void writeNamespace(String prefix, String namespaceURI) {
        if (prefix == null || prefix.length() == 0) {
            this.writeAttribute("xmlns", namespaceURI);
        } else {
            this.writeAttribute("xmlns:" + prefix, namespaceURI);
        }
    }

    public void writeProcessingInstruction(String target) {
        this.closeElement();
    }

    public void writeProcessingInstruction(String target, String data) {
        this.closeElement();
    }

    public void writeStartDocument() {
        this.out.write(this.processXmlHeader("<?xml version='1.0' ?>"));
    }

    public void writeStartDocument(String version) {
        this.out.write(this.processXmlHeader("<?xml version='" + version + "' ?>"));
    }

    public void writeStartDocument(String encoding, String version) {
        this.out.write(this.processXmlHeader("<?xml version='" + version + "' encoding='" + encoding + "' ?>"));
    }

    public void writeStartElement(String localName) {
        this.closeElement();
        this.inStartElement = true;
        this.elements.push(localName);
        this.out.write(60);
        this.out.write(localName);
    }

    public void writeStartElement(String namespaceURI, String localName) {
        this.closeElement();
        this.inStartElement = true;
        String prefix = this.uriToPrefix.get(namespaceURI);
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
            this.elements.push(String.valueOf(prefix) + ':' + localName);
        } else {
            this.elements.push(localName);
        }
        this.out.write(localName);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        this.closeElement();
        this.inStartElement = true;
        this.elements.push(localName);
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
    }

    public char getXmlHederQuoteChar() {
        return this.xmlHederQuoteChar;
    }

    public void setXmlHederQuoteChar(char xmlHederQuoteChar) {
        this.xmlHederQuoteChar = xmlHederQuoteChar;
    }

    private String processXmlHeader(String header) {
        return this.xmlHederQuoteChar == '\'' ? header : header.replace('\'', this.xmlHederQuoteChar);
    }

    private static void printEscaped(PrintWriter writer, CharSequence s, boolean attribute) {
        int length = s.length();
        try {
            int x = 0;
            while (x < length) {
                char ch = s.charAt(x);
                DefaultXmlStreamWriter.printEscaped(writer, ch, attribute);
                ++x;
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private static void printEscaped(PrintWriter writer, int ch, boolean attribute) throws IOException {
        String ref = DefaultXmlStreamWriter.getEntityRef(ch, attribute);
        if (ref != null) {
            writer.write(38);
            writer.write(ref);
            writer.write(59);
        } else if (ch == 13 || ch == 133 || ch == 8232) {
            DefaultXmlStreamWriter.printHex(writer, ch);
        } else if (ch >= 32 && ch != 160 && DefaultXmlStreamWriter.isUtf8Printable((char)ch) && XML11Char.isXML11ValidLiteral(ch) || ch == 9 || ch == 10 || ch == 13) {
            writer.write((char)ch);
        } else {
            DefaultXmlStreamWriter.printHex(writer, ch);
        }
    }

    static final void printHex(PrintWriter writer, int ch) throws IOException {
        writer.write("&#x");
        writer.write(Integer.toHexString(ch));
        writer.write(59);
    }

    protected static String getEntityRef(int ch, boolean attribute) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 34: {
                if (!attribute) break;
                return "quot";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    protected static boolean isUtf8Printable(char ch) {
        return ch >= ' ' && ch <= '\u10ffff' && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t';
    }
}

