/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.EditComboBoxCellEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CellEditor;

public class BuilderUtility {
    public static int fillColumnComboBox(CellEditor cellEditor, SQLQueryObject sqlStatement, boolean enableExprBuilder, boolean existsExpression) {
        List tables = new ArrayList();
        if (sqlStatement instanceof QueryStatement) {
            tables = StatementHelper.getTablesForStatement((QueryStatement)((QueryStatement)sqlStatement));
        } else if (sqlStatement instanceof QuerySelect) {
            tables = StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)((QuerySelect)sqlStatement));
        }
        int size = BuilderUtility.getTotalColumns(tables);
        if (enableExprBuilder && !existsExpression) {
            ++size;
        } else if (enableExprBuilder && existsExpression) {
            size += 2;
        }
        if (cellEditor != null) {
            LabelValuePair[] items = (LabelValuePair[])BuilderUtility.getDistinctColumnItems(sqlStatement, enableExprBuilder, existsExpression);
            if (cellEditor instanceof ComboBoxCellEditor) {
                ((ComboBoxCellEditor)cellEditor).createItems(items);
            } else if (cellEditor instanceof EditComboBoxCellEditor) {
                ((EditComboBoxCellEditor)cellEditor).createItems(items);
            }
        }
        return BuilderUtility.getTotalColumns(tables);
    }

    public static Object getDistinctColumnItems(SQLQueryObject sqlStatement, boolean enableExprBuilder, boolean existsExpression) {
        String tableName;
        TableExpression table;
        Object item;
        ArrayList<LabelValuePair> colList = new ArrayList<LabelValuePair>();
        List tables = new ArrayList();
        if (sqlStatement instanceof QueryStatement) {
            tables = StatementHelper.getTablesForStatement((QueryStatement)((QueryStatement)sqlStatement));
        } else if (sqlStatement instanceof QuerySelect) {
            tables = StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)((QuerySelect)sqlStatement));
        }
        boolean schemaNeeded = false;
        int i = 0;
        while (i < tables.size() && !schemaNeeded) {
            item = tables.get(i);
            table = null;
            tableName = "";
            if (item instanceof TableExpression) {
                table = (TableExpression)item;
                tableName = TableHelper.getExposedTableName((TableExpression)table);
                int j = i + 1;
                while (j < tables.size() && !schemaNeeded) {
                    Object item2 = tables.get(j);
                    TableExpression table2 = null;
                    String tableName2 = "";
                    if (item2 instanceof TableExpression) {
                        table2 = (TableExpression)item2;
                        tableName2 = TableHelper.getExposedTableName((TableExpression)table2);
                    }
                    if (tableName.equalsIgnoreCase(tableName2)) {
                        schemaNeeded = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < tables.size()) {
            item = tables.get(i);
            table = null;
            tableName = "";
            String schemaName = "";
            if (item instanceof TableExpression) {
                table = (TableExpression)item;
                if (schemaNeeded && table instanceof TableInDatabase) {
                    schemaName = TableHelper.getSchemaNameForTableExpression((TableExpression)table);
                }
                if ((tableName = TableHelper.getExposedTableName((TableExpression)((TableExpression)item))) == null || tableName.equals("")) {
                    tableName = "";
                }
                if (tableName.length() > 0 & schemaName.length() > 0) {
                    tableName = String.valueOf(schemaName) + "." + tableName;
                }
            }
            Iterator iterator = table.getColumnList().iterator();
            while (iterator.hasNext()) {
                QueryInsertStatement insert;
                boolean found = false;
                ValueExpressionColumn rdbColumn = (ValueExpressionColumn)iterator.next();
                if (sqlStatement instanceof QueryInsertStatement && BuilderUtility.isExpressionInTargetList(rdbColumn, insert = (QueryInsertStatement)sqlStatement)) continue;
                TableExpression expr = rdbColumn.getTableExpr();
                if (expr == null) {
                    expr = rdbColumn.getParentTableExpr();
                    rdbColumn.setTableExpr(expr);
                }
                String displayName = "";
                displayName = tableName.trim().length() > 0 ? String.valueOf(tableName) + "." + rdbColumn.getName() : rdbColumn.getName();
                for (LabelValuePair label : colList) {
                    if (label == null || !label.fLabel.equals(displayName)) continue;
                    found = true;
                }
                if (found) continue;
                colList.add(new LabelValuePair(displayName, rdbColumn));
            }
            ++i;
        }
        if (enableExprBuilder && !existsExpression) {
            colList.add(new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION));
        } else if (enableExprBuilder && existsExpression) {
            colList.add(new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION));
            colList.add(new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION));
        }
        colList.add(new LabelValuePair(" ", " "));
        LabelValuePair[] items = new LabelValuePair[colList.size()];
        Iterator colItr = colList.iterator();
        int ctr = 0;
        while (colItr.hasNext()) {
            LabelValuePair pair;
            items[ctr] = pair = (LabelValuePair)colItr.next();
            ++ctr;
        }
        return items;
    }

    private static boolean isExpressionInTargetList(ValueExpressionColumn exprColumn, QueryInsertStatement insert) {
        if (exprColumn == null || insert == null) {
            return false;
        }
        EList targetList = insert.getTargetColumnList();
        int i = 0;
        while (i < targetList.size()) {
            ValueExpressionColumn column = (ValueExpressionColumn)targetList.get(i);
            if (column.getName().equalsIgnoreCase(exprColumn.getName()) && column.getTableExpr().getName().equalsIgnoreCase(insert.getTargetTable().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object getColumnItems(QueryStatement sqlStatement, boolean enableExprBuilder, boolean existsExpression) {
        List tables = StatementHelper.getTablesForStatement((QueryStatement)sqlStatement);
        int size = BuilderUtility.getTotalColumns(tables);
        if (enableExprBuilder && !existsExpression) {
            ++size;
        } else if (enableExprBuilder && existsExpression) {
            size += 2;
        }
        LabelValuePair[] items = new LabelValuePair[size];
        int columnIndex = 0;
        int i = 0;
        while (i < tables.size()) {
            Object item = tables.get(i);
            TableExpression table = null;
            String tableName = "";
            if (item instanceof TableExpression) {
                table = (TableExpression)item;
                tableName = TableHelper.getExposedTableName((TableExpression)((TableExpression)item));
                if (tableName == null || tableName.equals("")) {
                    tableName = "";
                }
            }
            Iterator iterator = table.getColumnList().iterator();
            while (iterator.hasNext()) {
                boolean found = false;
                ValueExpressionColumn rdbColumn = (ValueExpressionColumn)iterator.next();
                String displayName = "";
                displayName = tableName.trim().length() > 0 ? String.valueOf(tableName) + "." + rdbColumn.getName() : rdbColumn.getName();
                int newIdx = 0;
                while (newIdx < items.length) {
                    LabelValuePair label = items[newIdx];
                    if (label != null && label.fLabel.equals(displayName)) {
                        found = true;
                    }
                    ++newIdx;
                }
                if (found) continue;
                items[columnIndex++] = new LabelValuePair(displayName, rdbColumn);
            }
            ++i;
        }
        if (enableExprBuilder && !existsExpression) {
            items[columnIndex++] = new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION);
        } else if (enableExprBuilder && existsExpression) {
            items[columnIndex++] = new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION);
            items[columnIndex++] = new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION);
        }
        items[columnIndex] = new LabelValuePair(" ", " ");
        return items;
    }

    public static int getTotalColumns(List tables) {
        int size = 1;
        int i = 0;
        while (i < tables.size()) {
            Object item = tables.get(i);
            TableExpression table = null;
            if (item instanceof TableExpression) {
                table = (TableExpression)item;
            }
            size += table.getColumnList().size();
            ++i;
        }
        return size;
    }

    public static List getColumnVector(SQLQueryObject sqlStatement) {
        ArrayList<ValueExpressionColumn> columnVector = new ArrayList<ValueExpressionColumn>();
        List tables = new ArrayList();
        if (sqlStatement instanceof QueryStatement) {
            tables = StatementHelper.getTablesForStatement((QueryStatement)((QueryStatement)sqlStatement));
        } else if (sqlStatement instanceof QuerySelect) {
            tables = StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)((QuerySelect)sqlStatement));
        }
        int i = 0;
        while (i < tables.size()) {
            EList colList;
            Object item = tables.get(i);
            TableExpression table = null;
            if (item instanceof TableExpression) {
                table = (TableExpression)item;
            }
            if ((colList = table.getColumnList()) != null) {
                for (ValueExpressionColumn colExpr : colList) {
                    columnVector.add(colExpr);
                }
            }
            ++i;
        }
        return columnVector;
    }
}

