/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenScope;
import org.eclipse.jpt.gen.internal.GenTable;
import org.eclipse.jpt.gen.internal.JptGenMessages;
import org.eclipse.jpt.utility.internal.StringTools;

public class PackageGenerator {
    private final Config config;
    private final EntityGenerator.Config entityConfig;
    private final GenScope scope;

    public static void generateEntities(Config config, EntityGenerator.Config entityConfig, IProgressMonitor progressMonitor) {
        if (config == null || entityConfig == null) {
            throw new NullPointerException();
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)JptGenMessages.PackageGenerator_taskName, (int)100);
        new PackageGenerator(config, entityConfig, (IProgressMonitor)sm.newChild(10)).generateEntities((IProgressMonitor)sm.newChild(90));
    }

    private PackageGenerator(Config config, EntityGenerator.Config entityConfig, IProgressMonitor progressMonitor) {
        this.config = config;
        this.entityConfig = entityConfig;
        this.scope = new GenScope(entityConfig, progressMonitor);
    }

    private void generateEntities(IProgressMonitor progressMonitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.scope.entityTablesSize());
        Iterator<GenTable> stream = this.scope.entityGenTables();
        while (stream.hasNext()) {
            this.checkCanceled((IProgressMonitor)sm);
            this.generateEntity(stream.next(), (IProgressMonitor)sm.newChild(1));
        }
    }

    private void generateEntity(GenTable genTable, IProgressMonitor progressMonitor) {
        EntityGenerator.generateEntity(this.entityConfig, this.config.getPackageFragment(), genTable, progressMonitor);
    }

    private void checkCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.scope);
    }

    public static class Config {
        private IPackageFragment packageFragment;

        public IPackageFragment getPackageFragment() {
            return this.packageFragment;
        }

        public void setPackageFragment(IPackageFragment packageFragment) {
            this.packageFragment = packageFragment;
        }
    }
}

