/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal2.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal2.ForeignKeyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTPUtil {
    public static List<String> getPrimaryKeyColumnNames(Table dbTable) {
        Iterator pkColumns = dbTable.primaryKeyColumns();
        ArrayList<String> ret = new ArrayList<String>();
        while (pkColumns.hasNext()) {
            ret.add(((Column)pkColumns.next()).getName());
        }
        return ret;
    }

    public static List<Column> getPrimaryKeyColumns(Table dbTable) {
        Iterator pkColumns = dbTable.primaryKeyColumns();
        ArrayList<Column> ret = new ArrayList<Column>();
        while (pkColumns.hasNext()) {
            ret.add((Column)pkColumns.next());
        }
        return ret;
    }

    public static boolean isAutoIncrement(Column c) {
        return false;
    }

    public static List<ForeignKeyInfo> getForeignKeys(Table dbTable) {
        ArrayList<ForeignKeyInfo> ret = new ArrayList<ForeignKeyInfo>();
        if (dbTable != null) {
            Iterator fks = dbTable.foreignKeys();
            while (fks.hasNext()) {
                ForeignKey fk = (ForeignKey)fks.next();
                Iterator columnPaires = fk.columnPairs();
                ForeignKeyInfo fkInfo = null;
                while (columnPaires.hasNext()) {
                    ForeignKey.ColumnPair columnPair = (ForeignKey.ColumnPair)columnPaires.next();
                    if (fkInfo == null) {
                        String tableName = dbTable.getName();
                        String referencedTableName = "";
                        Table referencedTable = fk.getReferencedTable();
                        referencedTableName = referencedTable.getName();
                        fkInfo = new ForeignKeyInfo(fk, tableName, referencedTableName);
                    }
                    String baseColName = columnPair.getBaseColumn().getName();
                    String referencedColName = columnPair.getReferencedColumn().getName();
                    fkInfo.addColumnMapping(baseColName, referencedColName);
                }
                if (fkInfo == null) continue;
                ret.add(fkInfo);
            }
        }
        return ret;
    }

    public static String getJavaType(Schema schema, Column dbColumn) {
        if (DTPUtil.isPrimaryKey(dbColumn)) {
            return dbColumn.getPrimaryKeyJavaTypeDeclaration();
        }
        return dbColumn.getJavaTypeDeclaration();
    }

    public static boolean isPrimaryKey(Column dbColumn) {
        Table dbTable = dbColumn.getTable();
        Iterator pkColumns = dbTable.primaryKeyColumns();
        while (pkColumns.hasNext()) {
            if (!((Column)pkColumns.next()).equals(dbColumn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefaultSchema(Table dbTable) {
        String schemaName = dbTable.getSchema().getName();
        Schema defaultSchema = dbTable.getSchema().getConnectionProfile().getDatabase().getDefaultSchema();
        return defaultSchema.getName() == schemaName;
    }
}

