/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.PlatformUI;

public class CVSFolderPropertiesPage
extends CVSPropertiesPage {
    IFolder folder;
    private Label root;
    private Label repository;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        try {
            ICVSFolder cvsResource = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.folder);
            if (!cvsResource.isManaged()) {
                if (cvsResource.isIgnored()) {
                    this.createLabel(composite, CVSUIMessages.CVSFolderPropertiesPage_ignored, 2);
                } else {
                    this.createLabel(composite, CVSUIMessages.CVSFolderPropertiesPage_notManaged, 2);
                }
            } else if (!cvsResource.isCVSFolder()) {
                this.createLabel(composite, CVSUIMessages.CVSFolderPropertiesPage_notCVSFolder, 2);
            } else {
                FolderSyncInfo syncInfo = cvsResource.getFolderSyncInfo();
                this.createLabel(composite, CVSUIMessages.CVSFolderPropertiesPage_root);
                this.root = this.createLabel(composite, syncInfo.getRoot());
                this.createLabel(composite, CVSUIMessages.CVSFolderPropertiesPage_repository);
                this.repository = this.createLabel(composite, syncInfo.getRepository());
                this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_tag);
                CVSEntryLineTag tag = syncInfo.getTag();
                if (tag != null && tag.getType() == 1) {
                    tag = Util.getAccurateFolderTag((IResource)this.folder, (CVSTag)tag);
                }
                this.createLabel(composite, CVSFolderPropertiesPage.getTagLabel((CVSTag)tag));
                if (syncInfo.getIsStatic()) {
                    this.createLabel(composite, CVSUIMessages.CVSFolderPropertiesPage_static);
                    this.createLabel(composite, syncInfo.getIsStatic() ? CVSUIMessages.yes : CVSUIMessages.no);
                }
                this.createLabel(composite, "", 2);
                final Button disconnect = new Button(composite, 0);
                disconnect.setText(CVSUIMessages.CVSFolderPropertiesPage_disconnect);
                GridData data = new GridData(128);
                int widthHint = this.convertHorizontalDLUsToPixels(61);
                data.widthHint = Math.max(widthHint, disconnect.computeSize((int)-1, (int)-1, (boolean)true).x);
                disconnect.setLayoutData((Object)data);
                disconnect.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (CVSFolderPropertiesPage.this.disconnectFolder()) {
                            CVSFolderPropertiesPage.this.root.setText(CVSUIMessages.CVSFilePropertiesPage_none);
                            CVSFolderPropertiesPage.this.repository.setText(CVSUIMessages.CVSFilePropertiesPage_none);
                            disconnect.setEnabled(false);
                        }
                    }
                });
            }
        }
        catch (TeamException teamException) {
            this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_error, 2);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.folder_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    private void initialize() {
        this.folder = null;
        IAdaptable element = this.getElement();
        if (element instanceof IFolder) {
            this.folder = (IFolder)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof IFolder) {
                this.folder = (IFolder)adapter;
            }
        }
    }

    private boolean disconnectFolder() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSUIMessages.CVSFolderPropertiesPage_disconnectTitle, (String)CVSUIMessages.CVSFolderPropertiesPage_disconnectQuestion)) {
            final ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.folder);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            cvsFolder.unmanage(null);
                        }
                        catch (CVSException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getShell(), null, null, e);
                return false;
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }
}

