/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceFactoryDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class IntroduceFactoryRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_PROTECT = "protect";
    private ICompilationUnit fCUHandle;
    private CompilationUnit fCU;
    private ICompilationUnit fFactoryUnitHandle;
    private int fSelectionStart;
    private int fSelectionLength;
    private ASTNode fSelectedNode;
    private IMethodBinding fCtorBinding;
    private AbstractTypeDeclaration fCtorOwningClass;
    private String fNewMethodName = null;
    private SearchResultGroup[] fAllCallsTo;
    private AbstractTypeDeclaration fFactoryOwningClass;
    private MethodDeclaration fFactoryMethod = null;
    private String[] fFormalArgNames = null;
    private ITypeBinding[] fArgTypes;
    private boolean fCtorIsVarArgs;
    private boolean fProtectConstructor = true;
    private ImportRewrite fImportRewriter;
    private boolean fCallSitesInBinaryUnits;
    private CompilationUnit fFactoryCU;
    private String fFactoryClassName;
    private int fConstructorVisibility = 2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IntroduceFactoryRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCUHandle = cu;
        if (cu != null) {
            this.initialize();
        }
    }

    public IntroduceFactoryRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void initialize() {
        this.fCU = ASTCreator.createAST(this.fCUHandle, null);
    }

    private ASTNode getTargetNode(ICompilationUnit unit, int offset, int length) {
        ASTNode node = ASTNodes.getNormalizedNode(NodeFinder.perform((ASTNode)this.fCU, offset, length));
        if (node.getNodeType() == 14) {
            return node;
        }
        if (node.getNodeType() == 31 && ((MethodDeclaration)node).isConstructor()) {
            return node;
        }
        StructuralPropertyDescriptor location = node.getLocationInParent();
        ASTNode parent = node.getParent();
        if (location == ClassInstanceCreation.TYPE_PROPERTY) {
            return parent;
        }
        if (location == MethodDeclaration.NAME_PROPERTY && ((MethodDeclaration)parent).isConstructor()) {
            return parent;
        }
        return null;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceFactory_examiningSelection, 2);
            this.fSelectedNode = this.getTargetNode(this.fCUHandle, this.fSelectionStart, this.fSelectionLength);
            if (this.fSelectedNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_notAConstructorInvocation);
                return refactoringStatus;
            }
            if (this.fSelectedNode instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fSelectedNode;
                this.fCtorBinding = classInstanceCreation.resolveConstructorBinding();
            } else if (this.fSelectedNode instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)this.fSelectedNode;
                this.fCtorBinding = methodDeclaration.resolveBinding();
            }
            if (this.fCtorBinding == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_unableToResolveConstructorBinding);
                return refactoringStatus;
            }
            this.fCtorBinding = this.fCtorBinding.getMethodDeclaration();
            pm.worked(1);
            if (this.fCtorBinding.getDeclaringClass().isNested()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_unsupportedNestedTypes);
                return refactoringStatus;
            }
            ITypeBinding ctorType = this.fCtorBinding.getDeclaringClass();
            IType ctorOwningType = (IType)ctorType.getJavaElement();
            if (ctorOwningType.isBinary()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_constructorInBinaryClass);
                return refactoringStatus;
            }
            if (ctorOwningType.isEnum()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_constructorInEnum);
                return refactoringStatus;
            }
            this.fFactoryUnitHandle = ctorOwningType.getCompilationUnit();
            this.fFactoryCU = this.getASTFor(this.fFactoryUnitHandle);
            Name ctorOwnerName = (Name)NodeFinder.perform((ASTNode)this.fFactoryCU, ctorOwningType.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fFactoryOwningClass = this.fCtorOwningClass = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)ctorOwnerName, clazz);
            pm.worked(1);
            if (this.fNewMethodName == null) {
                RefactoringStatus refactoringStatus = this.setNewMethodName("create" + this.fCtorBinding.getName());
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceFactory_checkingActivation, 1);
            if (!this.fCUHandle.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_syntaxError);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private ICompilationUnit[] collectAffectedUnits(SearchResultGroup[] searchHits) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        boolean hitInFactoryClass = false;
        int i = 0;
        while (i < searchHits.length) {
            SearchResultGroup rg = searchHits[i];
            ICompilationUnit icu = rg.getCompilationUnit();
            result.add(icu);
            if (icu.equals(this.fFactoryUnitHandle)) {
                hitInFactoryClass = true;
            }
            ++i;
        }
        if (!hitInFactoryClass) {
            result.add(this.fFactoryUnitHandle);
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private SearchPattern createSearchPattern(IMethod ctor, IMethodBinding methodBinding) {
        Assert.isNotNull((Object)methodBinding, (String)RefactoringCoreMessages.IntroduceFactory_noBindingForSelectedConstructor);
        if (ctor != null) {
            return SearchPattern.createPattern((IJavaElement)ctor, (int)2, (int)24);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(methodBinding.getDeclaringClass().getQualifiedName()).append("(");
        int i = 0;
        while (i < this.fArgTypes.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.fArgTypes[i].getQualifiedName());
            ++i;
        }
        buf.append(")");
        return SearchPattern.createPattern((String)buf.toString(), (int)3, (int)2, (int)24);
    }

    private IJavaSearchScope createSearchScope(IMethod ctor, IMethodBinding binding) throws JavaModelException {
        if (ctor != null) {
            return RefactoringScopeFactory.create((IJavaElement)ctor);
        }
        ITypeBinding type = Bindings.getTopLevelType(binding.getDeclaringClass());
        return RefactoringScopeFactory.create(type.getJavaElement());
    }

    private SearchResultGroup[] excludeBinaryUnits(SearchResultGroup[] groups) {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup rg = groups[i];
            ICompilationUnit unit = rg.getCompilationUnit();
            if (unit != null) {
                result.add(rg);
            } else {
                this.fCallSitesInBinaryUnits = true;
            }
            ++i;
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private SearchResultGroup[] searchForCallsTo(IMethodBinding methodBinding, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        IMethod method = (IMethod)methodBinding.getJavaElement();
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(this.createSearchPattern(method, methodBinding));
        engine.setFiltering(true, true);
        engine.setScope(this.createSearchScope(method, methodBinding));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    private SearchResultGroup[] findAllCallsTo(IMethodBinding ctorBinding, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchResultGroup[] groups = this.excludeBinaryUnits(this.searchForCallsTo(ctorBinding, pm, status));
        return groups;
    }

    private IType findNonPrimaryType(String fullyQualifiedName, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchPattern p = SearchPattern.createPattern((String)fullyQualifiedName, (int)0, (int)0, (int)24);
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(p);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)this.fCtorBinding.getJavaElement().getJavaProject()));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        SearchResultGroup[] groups = (SearchResultGroup[])engine.getResults();
        if (groups.length != 0) {
            int i = 0;
            while (i < groups.length) {
                SearchMatch[] matches = groups[i].getSearchResults();
                int j = 0;
                while (j < matches.length) {
                    if (matches[j].getAccuracy() == 0) {
                        return (IType)matches[j].getElement();
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceFactory_checking_preconditions, 1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fFactoryClassName != null) {
                result.merge(this.setFactoryClass(this.fFactoryClassName));
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fArgTypes = this.fCtorBinding.getParameterTypes();
            this.fCtorIsVarArgs = this.fCtorBinding.isVarargs();
            this.fAllCallsTo = this.findAllCallsTo(this.fCtorBinding, pm, result);
            this.fFormalArgNames = this.findCtorArgNames();
            ICompilationUnit[] affectedFiles = this.collectAffectedUnits(this.fAllCallsTo);
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(affectedFiles), this.getValidationContext()));
            if (this.fCallSitesInBinaryUnits) {
                result.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.IntroduceFactory_callSitesInBinaryClass));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private String[] findCtorArgNames() {
        CompilationUnit ctorUnit;
        MethodDeclaration ctorDecl;
        int numArgs = this.fCtorBinding.getParameterTypes().length;
        String[] names = new String[numArgs];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ctorDecl = (MethodDeclaration)(ctorUnit = (CompilationUnit)ASTNodes.getParent((ASTNode)this.fCtorOwningClass, clazz)).findDeclaringNode(this.fCtorBinding.getKey())) != null) {
            List formalArgs = ctorDecl.parameters();
            int i = 0;
            Iterator iter = formalArgs.iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration svd = (SingleVariableDeclaration)iter.next();
                names[i] = svd.getName().getIdentifier();
                ++i;
            }
            return names;
        }
        int i = 0;
        while (i < numArgs) {
            names[i] = "arg" + (i + 1);
            ++i;
        }
        return names;
    }

    private MethodDeclaration createFactoryMethod(AST ast, IMethodBinding ctorBinding, ASTRewrite unitRewriter) {
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        SimpleName newMethodName = ast.newSimpleName(this.fNewMethodName);
        ClassInstanceCreation newCtorCall = ast.newClassInstanceCreation();
        ReturnStatement ret = ast.newReturnStatement();
        Block body = ast.newBlock();
        List stmts = body.statements();
        String retTypeName = ctorBinding.getName();
        this.createFactoryMethodSignature(ast, newMethod);
        newMethod.setName(newMethodName);
        newMethod.setBody(body);
        ITypeBinding[] ctorOwnerTypeParameters = this.fCtorBinding.getDeclaringClass().getTypeParameters();
        this.setMethodReturnType(newMethod, retTypeName, ctorOwnerTypeParameters, ast);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 9));
        this.setCtorTypeArguments(newCtorCall, retTypeName, ctorOwnerTypeParameters, ast);
        this.createFactoryMethodConstructorArgs(ast, newCtorCall);
        ret.setExpression((Expression)newCtorCall);
        stmts.add(ret);
        return newMethod;
    }

    private void setCtorTypeArguments(ClassInstanceCreation newCtorCall, String ctorTypeName, ITypeBinding[] ctorOwnerTypeParameters, AST ast) {
        if (ctorOwnerTypeParameters.length == 0) {
            newCtorCall.setType(ASTNodeFactory.newType(ast, ctorTypeName));
        } else {
            SimpleType baseType = ast.newSimpleType((Name)ast.newSimpleName(ctorTypeName));
            ParameterizedType newInstantiatedType = ast.newParameterizedType((Type)baseType);
            List newInstTypeArgs = newInstantiatedType.typeArguments();
            int i = 0;
            while (i < ctorOwnerTypeParameters.length) {
                Type typeArg = ASTNodeFactory.newType(ast, ctorOwnerTypeParameters[i].getName());
                newInstTypeArgs.add(typeArg);
                ++i;
            }
            newCtorCall.setType((Type)newInstantiatedType);
        }
    }

    private void setMethodReturnType(MethodDeclaration newMethod, String retTypeName, ITypeBinding[] ctorOwnerTypeParameters, AST ast) {
        if (ctorOwnerTypeParameters.length == 0) {
            newMethod.setReturnType2((Type)ast.newSimpleType((Name)ast.newSimpleName(retTypeName)));
        } else {
            SimpleType baseType = ast.newSimpleType((Name)ast.newSimpleName(retTypeName));
            ParameterizedType newRetType = ast.newParameterizedType((Type)baseType);
            List newRetTypeArgs = newRetType.typeArguments();
            int i = 0;
            while (i < ctorOwnerTypeParameters.length) {
                Type retTypeArg = ASTNodeFactory.newType(ast, ctorOwnerTypeParameters[i].getName());
                newRetTypeArgs.add(retTypeArg);
                ++i;
            }
            newMethod.setReturnType2((Type)newRetType);
        }
    }

    private void createFactoryMethodSignature(AST ast, MethodDeclaration newMethod) {
        List argDecls = newMethod.parameters();
        int i = 0;
        while (i < this.fArgTypes.length) {
            Type argType;
            SingleVariableDeclaration argDecl = ast.newSingleVariableDeclaration();
            if (i == this.fArgTypes.length - 1 && this.fCtorIsVarArgs) {
                argType = this.typeNodeForTypeBinding(this.fArgTypes[i].getElementType(), this.fArgTypes[i].getDimensions() - 1, ast);
                argDecl.setVarargs(true);
            } else {
                argType = this.typeNodeForTypeBinding(this.fArgTypes[i], 0, ast);
            }
            argDecl.setName(ast.newSimpleName(this.fFormalArgNames[i]));
            argDecl.setType(argType);
            argDecls.add(argDecl);
            ++i;
        }
        ITypeBinding[] ctorExcepts = this.fCtorBinding.getExceptionTypes();
        List exceptions = newMethod.thrownExceptions();
        int i2 = 0;
        while (i2 < ctorExcepts.length) {
            String excName = this.fImportRewriter.addImport(ctorExcepts[i2]);
            exceptions.add(ASTNodeFactory.newName(ast, excName));
            ++i2;
        }
        this.copyTypeParameters(ast, newMethod);
    }

    private void copyTypeParameters(AST ast, MethodDeclaration newMethod) {
        ITypeBinding[] ctorOwnerTypeParms = this.fCtorBinding.getDeclaringClass().getTypeParameters();
        List factoryMethodTypeParms = newMethod.typeParameters();
        int i = 0;
        while (i < ctorOwnerTypeParms.length) {
            TypeParameter newParm = ast.newTypeParameter();
            ITypeBinding[] parmTypeBounds = ctorOwnerTypeParms[i].getTypeBounds();
            List newParmBounds = newParm.typeBounds();
            newParm.setName(ast.newSimpleName(ctorOwnerTypeParms[i].getName()));
            int b = 0;
            while (b < parmTypeBounds.length) {
                if (!parmTypeBounds[b].isClass() || parmTypeBounds[b].getSuperclass() != null) {
                    Type newBound = this.fImportRewriter.addImport(parmTypeBounds[b], ast);
                    newParmBounds.add(newBound);
                }
                ++b;
            }
            factoryMethodTypeParms.add(newParm);
            ++i;
        }
    }

    private Type typeNodeForTypeBinding(ITypeBinding argType, int extraDims, AST ast) {
        if (extraDims > 0) {
            return ast.newArrayType(this.typeNodeForTypeBinding(argType, 0, ast), extraDims);
        }
        if (argType.isArray()) {
            Type elementType = this.typeNodeForTypeBinding(argType.getElementType(), extraDims, ast);
            return ast.newArrayType(elementType, argType.getDimensions());
        }
        return this.fImportRewriter.addImport(argType, ast);
    }

    private void createFactoryMethodConstructorArgs(AST ast, ClassInstanceCreation newCtorCall) {
        List argList = newCtorCall.arguments();
        int i = 0;
        while (i < this.fArgTypes.length) {
            SimpleName ctorArg = ast.newSimpleName(this.fFormalArgNames[i]);
            argList.add(ctorArg);
            ++i;
        }
    }

    private void rewriteFactoryMethodCall(ClassInstanceCreation ctorCall, ASTRewrite unitRewriter, TextEditGroup gd) {
        AbstractTypeDeclaration callOwner;
        ITypeBinding callOwnerBinding;
        AST ast = unitRewriter.getAST();
        MethodInvocation factoryMethodCall = ast.newMethodInvocation();
        ASTNode ctorCallParent = ctorCall.getParent();
        StructuralPropertyDescriptor ctorCallLocation = ctorCall.getLocationInParent();
        if (ctorCallLocation instanceof ChildListPropertyDescriptor) {
            ListRewrite ctorCallParentListRewrite = unitRewriter.getListRewrite(ctorCallParent, (ChildListPropertyDescriptor)ctorCallLocation);
            int index = ctorCallParentListRewrite.getOriginalList().indexOf(ctorCall);
            ctorCall = (ClassInstanceCreation)ctorCallParentListRewrite.getRewrittenList().get(index);
        } else {
            ctorCall = (ClassInstanceCreation)unitRewriter.get(ctorCallParent, ctorCallLocation);
        }
        ListRewrite actualFactoryArgs = unitRewriter.getListRewrite((ASTNode)factoryMethodCall, MethodInvocation.ARGUMENTS_PROPERTY);
        ListRewrite actualCtorArgs = unitRewriter.getListRewrite((ASTNode)ctorCall, ClassInstanceCreation.ARGUMENTS_PROPERTY);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((callOwnerBinding = (callOwner = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)ctorCall, clazz)).resolveBinding()) == null || !Bindings.equals((IBinding)callOwner.resolveBinding(), (IBinding)this.fFactoryOwningClass.resolveBinding())) {
            String qualifier = this.fImportRewriter.addImport(this.fFactoryOwningClass.resolveBinding());
            factoryMethodCall.setExpression((Expression)ASTNodeFactory.newName(ast, qualifier));
        }
        factoryMethodCall.setName(ast.newSimpleName(this.fNewMethodName));
        int i = 0;
        while (i < actualCtorArgs.getRewrittenList().size()) {
            ASTNode movedArg;
            Expression actualCtorArg = (Expression)actualCtorArgs.getRewrittenList().get(i);
            if (ASTNodes.isExistingNode((ASTNode)actualCtorArg)) {
                movedArg = unitRewriter.createMoveTarget((ASTNode)actualCtorArg);
            } else {
                unitRewriter.remove((ASTNode)actualCtorArg, null);
                movedArg = actualCtorArg;
            }
            actualFactoryArgs.insertLast(movedArg, gd);
            ++i;
        }
        unitRewriter.replace((ASTNode)ctorCall, (ASTNode)factoryMethodCall, gd);
    }

    private boolean isConstructorUnit(ICompilationUnit unit) {
        return unit.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
    }

    private boolean shouldProtectConstructor() {
        return this.fProtectConstructor && this.fCtorOwningClass != null;
    }

    private boolean protectConstructor(CompilationUnit unitAST, ASTRewrite unitRewriter, TextEditGroup declGD) {
        MethodDeclaration constructor = (MethodDeclaration)unitAST.findDeclaringNode(this.fCtorBinding.getKey());
        if (constructor == null || JdtFlags.getVisibilityCode((BodyDeclaration)constructor) == this.fConstructorVisibility) {
            return false;
        }
        ModifierRewrite.create(unitRewriter, (ASTNode)constructor).setVisibility(this.fConstructorVisibility, declGD);
        return true;
    }

    private boolean addAllChangesFor(SearchResultGroup rg, ICompilationUnit unitHandle, CompilationUnitChange unitChange) throws CoreException {
        TextEditGroup declGD;
        Assert.isTrue((rg == null || rg.getCompilationUnit() == unitHandle ? 1 : 0) != 0);
        CompilationUnit unit = this.getASTFor(unitHandle);
        ASTRewrite unitRewriter = ASTRewrite.create((AST)unit.getAST());
        MultiTextEdit root = new MultiTextEdit();
        boolean someChange = false;
        unitChange.setEdit((TextEdit)root);
        this.fImportRewriter = StubUtility.createImportRewrite(unit, true);
        if (unitHandle.equals(this.fFactoryUnitHandle)) {
            TextEditGroup factoryGD = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_addFactoryMethod);
            this.createFactoryChange(unitRewriter, unit, factoryGD);
            unitChange.addTextEditGroup(factoryGD);
            someChange = true;
        }
        if (rg != null && this.replaceConstructorCalls(rg, unit, unitRewriter, unitChange)) {
            someChange = true;
        }
        if (this.shouldProtectConstructor() && this.isConstructorUnit(unitHandle) && this.protectConstructor(unit, unitRewriter, declGD = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_protectConstructor))) {
            unitChange.addTextEditGroup(declGD);
            someChange = true;
        }
        if (someChange) {
            root.addChild(unitRewriter.rewriteAST());
            root.addChild(this.fImportRewriter.rewriteImports(null));
        }
        return someChange;
    }

    private CompilationUnit getASTFor(ICompilationUnit unitHandle) {
        if (unitHandle.equals(this.fCUHandle)) {
            if (this.fCU == null) {
                this.fCU = ASTCreator.createAST(unitHandle, null);
                if (this.fCU.equals((Object)this.fFactoryUnitHandle)) {
                    this.fFactoryCU = this.fCU;
                }
            }
            return this.fCU;
        }
        if (unitHandle.equals(this.fFactoryUnitHandle)) {
            if (this.fFactoryCU == null) {
                this.fFactoryCU = ASTCreator.createAST(unitHandle, null);
            }
            return this.fFactoryCU;
        }
        return ASTCreator.createAST(unitHandle, null);
    }

    private boolean replaceConstructorCalls(SearchResultGroup rg, CompilationUnit unit, ASTRewrite unitRewriter, CompilationUnitChange unitChange) throws CoreException {
        Assert.isTrue((boolean)ASTCreator.getCu((ASTNode)unit).equals(rg.getCompilationUnit()));
        SearchMatch[] hits = rg.getSearchResults();
        Arrays.sort(hits, new Comparator(){

            public int compare(Object o1, Object o2) {
                SearchMatch m1 = (SearchMatch)o1;
                SearchMatch m2 = (SearchMatch)o2;
                return m2.getOffset() - m1.getOffset();
            }
        });
        boolean someCallPatched = false;
        int i = 0;
        while (i < hits.length) {
            TextEditGroup gd;
            ASTNode ctrCall = this.getCtorCallAt(hits[i].getOffset(), hits[i].getLength(), unit);
            if (ctrCall instanceof ClassInstanceCreation) {
                gd = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_replaceCalls);
                this.rewriteFactoryMethodCall((ClassInstanceCreation)ctrCall, unitRewriter, gd);
                unitChange.addTextEditGroup(gd);
                someCallPatched = true;
            } else if (ctrCall instanceof MethodRef) {
                gd = new TextEditGroup(RefactoringCoreMessages.IntroduceFactoryRefactoring_replaceJavadocReference);
                this.rewriteJavadocReference((MethodRef)ctrCall, unitRewriter, gd);
                unitChange.addTextEditGroup(gd);
                someCallPatched = true;
            }
            ++i;
        }
        return someCallPatched;
    }

    private void rewriteJavadocReference(MethodRef javadocRef, ASTRewrite unitRewriter, TextEditGroup gd) {
        AST ast = unitRewriter.getAST();
        unitRewriter.replace((ASTNode)javadocRef.getName(), (ASTNode)ast.newSimpleName(this.fNewMethodName), gd);
    }

    private ASTNode getCtorCallAt(int start, int length, CompilationUnit unitAST) throws CoreException {
        ICompilationUnit unitHandle = ASTCreator.getCu((ASTNode)unitAST);
        ASTNode node = NodeFinder.perform((ASTNode)unitAST, start, length);
        if (node == null) {
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_noASTNodeForConstructorSearchHit, new Object[]{Integer.toString(start), Integer.toString(start + length), BasicElementLabels.getJavaCodeString(unitHandle.getSource().substring(start, start + length)), BasicElementLabels.getFileName((ITypeRoot)unitHandle)}), null));
        }
        if (node instanceof ClassInstanceCreation) {
            if (((ClassInstanceCreation)node).getAnonymousClassDeclaration() != null) {
                this.fConstructorVisibility = 4;
                return null;
            }
            return node;
        }
        if (node instanceof VariableDeclaration) {
            Expression init = ((VariableDeclaration)node).getInitializer();
            if (init instanceof ClassInstanceCreation) {
                return init;
            }
            if (init != null) {
                throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedInitializerNodeType, new Object[]{BasicElementLabels.getJavaCodeString(init.toString()), BasicElementLabels.getFileName((ITypeRoot)unitHandle)}), null));
            }
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_noConstructorCallNodeInsideFoundVarbleDecl, BasicElementLabels.getJavaCodeString(node.toString())), null));
        }
        if (node instanceof ConstructorInvocation) {
            return null;
        }
        if (node instanceof SuperConstructorInvocation) {
            this.fConstructorVisibility = 4;
            return null;
        }
        if (node instanceof ExpressionStatement) {
            Expression expr = ((ExpressionStatement)node).getExpression();
            if (expr instanceof ClassInstanceCreation) {
                return expr;
            }
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedASTNodeTypeForConstructorSearchHit, new Object[]{BasicElementLabels.getJavaCodeString(expr.toString()), BasicElementLabels.getFileName((ITypeRoot)unitHandle)}), null));
        }
        if (node instanceof SimpleName && (node.getParent() instanceof MethodDeclaration || node.getParent() instanceof AbstractTypeDeclaration)) {
            this.fConstructorVisibility = 4;
            return null;
        }
        if (node instanceof MethodRef) {
            return node;
        }
        throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedASTNodeTypeForConstructorSearchHit, new Object[]{BasicElementLabels.getJavaElementName(String.valueOf(node.getClass().getName()) + "('" + node.toString() + "')"), BasicElementLabels.getFileName((ITypeRoot)unitHandle)}), null));
    }

    private void createFactoryChange(ASTRewrite unitRewriter, CompilationUnit unit, TextEditGroup gd) {
        AST ast = unit.getAST();
        this.fFactoryMethod = this.createFactoryMethod(ast, this.fCtorBinding, unitRewriter);
        AbstractTypeDeclaration factoryOwner = (AbstractTypeDeclaration)unit.findDeclaringNode(this.fFactoryOwningClass.resolveBinding().getKey());
        this.fImportRewriter.addImport(this.fCtorOwningClass.resolveBinding());
        int idx = ASTNodes.getInsertionIndex((BodyDeclaration)this.fFactoryMethod, factoryOwner.bodyDeclarations());
        if (idx < 0) {
            idx = 0;
        }
        unitRewriter.getListRewrite((ASTNode)factoryOwner, factoryOwner.getBodyDeclarationsProperty()).insertAt((ASTNode)this.fFactoryMethod, idx, gd);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceFactory_createChanges, this.fAllCallsTo.length);
            ITypeBinding binding = this.fFactoryOwningClass.resolveBinding();
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCUHandle.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            if (binding.isNested() && !binding.isMember()) {
                flags |= 0x40000;
            }
            String description = Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fCtorOwningClass.getName().getIdentifier()));
            String header = Messages.format(RefactoringCoreMessages.IntroduceFactory_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fNewMethodName), BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)this.fCtorBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fCtorBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_factory_pattern, BasicElementLabels.getJavaElementName(this.fNewMethodName)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_owner_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            if (this.fProtectConstructor) {
                comment.addSetting(RefactoringCoreMessages.IntroduceFactoryRefactoring_declare_private);
            }
            IntroduceFactoryDescriptor descriptor = RefactoringSignatureDescriptorFactory.createIntroduceFactoryDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCUHandle));
            arguments.put("name", this.fNewMethodName);
            arguments.put("element1", JavaRefactoringDescriptorUtil.elementToHandle(project, binding.getJavaElement()));
            arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            arguments.put(ATTRIBUTE_PROTECT, Boolean.valueOf(this.fProtectConstructor).toString());
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.IntroduceFactory_name);
            boolean hitInFactoryClass = false;
            boolean hitInCtorClass = false;
            int i = 0;
            while (i < this.fAllCallsTo.length) {
                CompilationUnitChange cuChange;
                SearchResultGroup rg = this.fAllCallsTo[i];
                ICompilationUnit unitHandle = rg.getCompilationUnit();
                if (this.addAllChangesFor(rg, unitHandle, cuChange = new CompilationUnitChange(this.getName(), unitHandle))) {
                    result.add((Change)cuChange);
                }
                if (unitHandle.equals(this.fFactoryUnitHandle)) {
                    hitInFactoryClass = true;
                }
                if (unitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                    hitInCtorClass = true;
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            if (!hitInFactoryClass) {
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), this.fFactoryUnitHandle);
                this.addAllChangesFor(null, this.fFactoryUnitHandle, cuChange);
                result.add((Change)cuChange);
            }
            if (!hitInCtorClass && !this.fFactoryUnitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
                this.addAllChangesFor(null, ASTCreator.getCu((ASTNode)this.fCtorOwningClass), cuChange);
                result.add((Change)cuChange);
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceFactory_name;
    }

    public String getNewMethodName() {
        return this.fNewMethodName;
    }

    public RefactoringStatus setNewMethodName(String newMethodName) {
        Assert.isNotNull((Object)newMethodName);
        this.fNewMethodName = newMethodName;
        RefactoringStatus stat = Checks.checkMethodName(newMethodName, (IJavaElement)this.fCUHandle);
        stat.merge(this.isUniqueMethodName(newMethodName));
        return stat;
    }

    private RefactoringStatus isUniqueMethodName(String methodName) {
        ITypeBinding declaringClass = this.fCtorBinding.getDeclaringClass();
        if (Bindings.findMethodInType(declaringClass, methodName, this.fCtorBinding.getParameterTypes()) != null) {
            String format = Messages.format(RefactoringCoreMessages.IntroduceFactory_duplicateMethodName, BasicElementLabels.getJavaElementName(methodName));
            return RefactoringStatus.createErrorStatus((String)format);
        }
        return new RefactoringStatus();
    }

    public boolean canProtectConstructor() {
        return !this.fCtorBinding.isSynthetic() && this.fFactoryCU.findDeclaringNode(this.fCtorBinding.getKey()) != null;
    }

    public void setProtectConstructor(boolean protectConstructor) {
        this.fProtectConstructor = protectConstructor;
    }

    public IJavaProject getProject() {
        return this.fCUHandle.getJavaProject();
    }

    public RefactoringStatus setFactoryClass(String fullyQualifiedTypeName) {
        IType factoryType;
        try {
            factoryType = this.findFactoryClass(fullyQualifiedTypeName);
            if (factoryType == null) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceFactory_noSuchClass, BasicElementLabels.getJavaElementName(fullyQualifiedTypeName)));
            }
            if (factoryType.isAnnotation()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryMethodOnAnnotation);
            }
            if (factoryType.isInterface()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryMethodOnInterface);
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantCheckForInterface);
        }
        ICompilationUnit factoryUnitHandle = factoryType.getCompilationUnit();
        if (factoryType.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryInBinaryClass);
        }
        try {
            String ctorPkg;
            if (!this.fFactoryUnitHandle.equals(factoryUnitHandle)) {
                this.fFactoryCU = this.getASTFor(factoryUnitHandle);
                this.fFactoryUnitHandle = factoryUnitHandle;
            }
            ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fFactoryCU, factoryType.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fFactoryOwningClass = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
            String factoryPkg = factoryType.getPackageFragment().getElementName();
            if (!factoryPkg.equals(ctorPkg = this.fCtorOwningClass.resolveBinding().getPackage().getName())) {
                this.fConstructorVisibility = 1;
            } else if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
            if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
        }
        catch (JavaModelException e) {
            return RefactoringStatus.createFatalErrorStatus((String)e.getMessage());
        }
        return new RefactoringStatus();
    }

    private IType findFactoryClass(String fullyQualifiedTypeName) throws JavaModelException {
        IType factoryType = this.getProject().findType(fullyQualifiedTypeName);
        if (factoryType == null) {
            factoryType = this.findNonPrimaryType(fullyQualifiedTypeName, (IProgressMonitor)new NullProgressMonitor(), new RefactoringStatus());
        }
        return factoryType;
    }

    public String getFactoryClassName() {
        return this.fFactoryOwningClass.resolveBinding().getQualifiedName();
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.factory");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCUHandle = (ICompilationUnit)element;
        this.initialize();
        handle = arguments.getAttribute("element1");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.factory");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        IType type = (IType)element;
        this.fFactoryClassName = type.getFullyQualifiedName();
        String name = arguments.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.fNewMethodName = name;
        String protect = arguments.getAttribute(ATTRIBUTE_PROTECT);
        if (protect == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PROTECT));
        }
        this.fProtectConstructor = Boolean.valueOf(protect);
        return new RefactoringStatus();
    }
}

