/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.net.URL;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;

public class OpenExternalBrowserAction
extends Action
implements ISelectionChangedListener {
    private final Display fDisplay;
    private final ISelectionProvider fSelectionProvider;

    public OpenExternalBrowserAction(Display display, ISelectionProvider selectionProvider) {
        this.fDisplay = display;
        this.fSelectionProvider = selectionProvider;
        this.setText(ActionMessages.OpenExternalBrowserAction_javadoc_label);
        this.setToolTipText(ActionMessages.OpenExternalBrowserAction_javadoc_toolTip);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_EXTERNAL_BROWSER);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_EXTERNAL_BROWSER);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (this.canEnable(structuredSelection)) {
            this.setEnabled(true);
            Object element = structuredSelection.getFirstElement();
            if (element instanceof URL) {
                this.setText(ActionMessages.OpenExternalBrowserAction_url_label);
                this.setToolTipText(ActionMessages.OpenExternalBrowserAction_url_toolTip);
            } else {
                this.setText(ActionMessages.OpenExternalBrowserAction_javadoc_label);
                this.setToolTipText(ActionMessages.OpenExternalBrowserAction_javadoc_toolTip);
            }
        } else {
            this.setEnabled(false);
            this.setText(ActionMessages.OpenExternalBrowserAction_javadoc_label);
            this.setToolTipText(ActionMessages.OpenExternalBrowserAction_javadoc_toolTip);
        }
    }

    public void run() {
        URL url;
        ISelection selection = this.fSelectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object element = structuredSelection.getFirstElement();
        if (element instanceof IJavaElement) {
            try {
                url = JavaUI.getJavadocLocation((IJavaElement)element, true);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return;
            }
        } else {
            url = (URL)element;
        }
        OpenBrowserUtil.open(url, this.fDisplay, null);
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof URL) {
            return true;
        }
        if (!(element instanceof IJavaElement)) {
            return false;
        }
        IJavaElement input = (IJavaElement)element;
        try {
            URL url = JavaUI.getJavadocLocation(input, true);
            return url != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

