/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class MoveStaticMembersAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public MoveStaticMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.RefactoringGroup_move_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.move_action");
    }

    public MoveStaticMembersAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveStaticMembersAvailable(MoveStaticMembersAction.getSelectedMembers(selection)));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveStaticAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember[] members = MoveStaticMembersAction.getSelectedMembers(selection);
            int index = 0;
            while (index < members.length) {
                if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)members[index])) {
                    return;
                }
                ++index;
            }
            if (RefactoringAvailabilityTester.isMoveStaticMembersAvailable(members)) {
                RefactoringExecutionStarter.startMoveStaticMembersRefactoring(members, this.getShell());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IMember member = this.getSelectedMemberFromEditor();
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)member)) {
                return;
            }
            IMember[] array = new IMember[]{member};
            if (member != null && RefactoringAvailabilityTester.isMoveStaticMembersAvailable(array)) {
                RefactoringExecutionStarter.startMoveStaticMembersRefactoring(array, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.MoveMembersAction_unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof IMember) continue;
            return null;
        }
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(selection.toArray()));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private IMember getSelectedMemberFromEditor() throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IMember)) {
            return null;
        }
        return (IMember)element;
    }
}

