/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.viewers.StyledString;

public class MethodDeclarationCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IType fType;
    private final String fReturnTypeSig;
    private final String fMethodName;

    public static void evaluateProposals(IType type, String prefix, int offset, int length, int relevance, Set suggestedMethods, Collection result) throws CoreException {
        String constructorName;
        IMethod[] methods = type.getMethods();
        if (!type.isInterface() && (constructorName = type.getElementName()).length() > 0 && constructorName.startsWith(prefix) && !MethodDeclarationCompletionProposal.hasMethod(methods, constructorName) && suggestedMethods.add(constructorName)) {
            result.add(new MethodDeclarationCompletionProposal(type, constructorName, null, offset, length, relevance + 500));
        }
        if (prefix.length() > 0 && !"main".equals(prefix) && !MethodDeclarationCompletionProposal.hasMethod(methods, prefix) && suggestedMethods.add(prefix) && !JavaConventionsUtil.validateMethodName(prefix, (IJavaElement)type).matches(4)) {
            result.add(new MethodDeclarationCompletionProposal(type, prefix, "V", offset, length, relevance));
        }
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            IMethod curr = methods[i];
            if (curr.getElementName().equals(name) && curr.getParameterTypes().length == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MethodDeclarationCompletionProposal(IType type, String methodName, String returnTypeSig, int start, int length, int relevance) {
        super("", type.getCompilationUnit(), start, length, null, MethodDeclarationCompletionProposal.getDisplayName(methodName, returnTypeSig), relevance);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)methodName);
        this.fType = type;
        this.fMethodName = methodName;
        this.fReturnTypeSig = returnTypeSig;
        if (returnTypeSig == null) {
            this.setProposalInfo(new ProposalInfo((IMember)type));
            JavaElementImageDescriptor desc = new JavaElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE);
            this.setImage(JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc));
        } else {
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.methpri_obj.gif"));
        }
    }

    private static StyledString getDisplayName(String methodName, String returnTypeSig) {
        StyledString buf = new StyledString();
        buf.append(methodName);
        buf.append('(');
        buf.append(')');
        if (returnTypeSig != null) {
            buf.append(" : ");
            buf.append(Signature.toString((String)returnTypeSig));
            buf.append(" - ", StyledString.QUALIFIER_STYLER);
            buf.append(JavaTextMessages.MethodCompletionProposal_method_label, StyledString.QUALIFIER_STYLER);
        } else {
            buf.append(" - ", StyledString.QUALIFIER_STYLER);
            buf.append(JavaTextMessages.MethodCompletionProposal_constructor_label, StyledString.QUALIFIER_STYLER);
        }
        return buf;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String comment;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaProject());
        boolean addComments = settings.createComments;
        String[] empty = new String[]{};
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String declTypeName = this.fType.getTypeQualifiedName('.');
        boolean isInterface = this.fType.isInterface();
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), declTypeName, this.fMethodName, empty, empty, this.fReturnTypeSig, empty, null, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        if (this.fReturnTypeSig != null) {
            if (!isInterface) {
                buf.append("private ");
            }
        } else if (this.fType.isEnum()) {
            buf.append("private ");
        } else {
            buf.append("public ");
        }
        if (this.fReturnTypeSig != null) {
            buf.append(Signature.toString((String)this.fReturnTypeSig));
        }
        buf.append(' ');
        buf.append(this.fMethodName);
        if (isInterface) {
            buf.append("();");
            buf.append(lineDelim);
        } else {
            buf.append("() {");
            buf.append(lineDelim);
            String body = CodeGeneration.getMethodBodyContent(this.fType.getCompilationUnit(), declTypeName, this.fMethodName, this.fReturnTypeSig == null, "", lineDelim);
            if (body != null) {
                buf.append(body);
                buf.append(lineDelim);
            }
            buf.append("}");
            buf.append(lineDelim);
        }
        String stub = buf.toString();
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int lineStart = region.getOffset();
        int indent = Strings.computeIndentUnits(document.get(lineStart, this.getReplacementOffset() - lineStart), settings.tabWidth, settings.indentWidth);
        String replacement = CodeFormatterUtil.format(4, stub, indent, lineDelim, this.fType.getJavaProject());
        if (replacement.endsWith(lineDelim)) {
            replacement = replacement.substring(0, replacement.length() - lineDelim.length());
        }
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(replacement));
        return true;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return new String();
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

