/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;

public class TraditionalHierarchyViewer
extends TypeHierarchyViewer {
    public TraditionalHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle) {
        super(parent, (IContentProvider)new TraditionalHierarchyContentProvider(lifeCycle), lifeCycle);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.TraditionalHierarchyViewer_filtered_title;
        }
        return TypeHierarchyMessages.TraditionalHierarchyViewer_title;
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            TraditionalHierarchyContentProvider contentProvider = (TraditionalHierarchyContentProvider)this.getContentProvider();
            int expandLevel = contentProvider.getExpandLevel();
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    public static class TraditionalHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public TraditionalHierarchyContentProvider(TypeHierarchyLifeCycle provider) {
            super(provider);
        }

        public int getExpandLevel() {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input != null) {
                    return this.getDepth(hierarchy, input) + 2;
                }
                return 5;
            }
            return 2;
        }

        private int getDepth(ITypeHierarchy hierarchy, IType input) {
            int count = 0;
            IType superType = hierarchy.getSuperclass(input);
            while (superType != null) {
                ++count;
                superType = hierarchy.getSuperclass(superType);
            }
            return count;
        }

        protected final void getRootTypes(List res) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input == null) {
                    IType[] classes = hierarchy.getRootClasses();
                    int i = 0;
                    while (i < classes.length) {
                        res.add(classes[i]);
                        ++i;
                    }
                    IType[] interfaces = hierarchy.getRootInterfaces();
                    int i2 = 0;
                    while (i2 < interfaces.length) {
                        res.add(interfaces[i2]);
                        ++i2;
                    }
                } else if (Flags.isInterface((int)hierarchy.getCachedFlags(input))) {
                    res.add(input);
                } else if (this.isAnonymousFromInterface(input)) {
                    res.add(hierarchy.getSuperInterfaces(input)[0]);
                } else {
                    IType[] roots = hierarchy.getRootClasses();
                    int i = 0;
                    while (i < roots.length) {
                        if (this.isObject(roots[i])) {
                            res.add(roots[i]);
                            return;
                        }
                        ++i;
                    }
                    res.addAll(Arrays.asList(roots));
                }
            }
        }

        protected final void getTypesInHierarchy(IType type, List res) {
            block9: {
                ITypeHierarchy hierarchy = this.getHierarchy();
                if (hierarchy == null) break block9;
                IType[] types = hierarchy.getSubtypes(type);
                if (this.isObject(type)) {
                    int i = 0;
                    while (i < types.length) {
                        IType curr = types[i];
                        if (!this.isAnonymousFromInterface(curr)) {
                            res.add(curr);
                        }
                        ++i;
                    }
                } else {
                    boolean isClass;
                    boolean isHierarchyOnType = hierarchy.getType() != null;
                    boolean bl = isClass = !Flags.isInterface((int)hierarchy.getCachedFlags(type));
                    if (isClass || isHierarchyOnType) {
                        int i = 0;
                        while (i < types.length) {
                            res.add(types[i]);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < types.length) {
                            IType curr = types[i];
                            if (Flags.isInterface((int)hierarchy.getCachedFlags(curr)) || this.isAnonymous(curr)) {
                                res.add(curr);
                            }
                            ++i;
                        }
                    }
                }
            }
        }

        protected IType getParentType(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSuperclass(type);
            }
            return null;
        }
    }
}

