/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractLocalEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.SummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.util.AbstractRetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskContainerComparator;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class AttributePart
extends AbstractLocalEditorPart {
    private ImageHyperlink fetchUrlLink;
    private RichTextEditor urlEditor;
    private CCombo categoryChooser;
    protected AbstractTaskCategory category;
    private Label categoryLabel;
    private List<AbstractTaskCategory> categories;

    public AttributePart() {
        super(Messages.TaskPlanningEditor_Attributes);
    }

    public void commit(boolean onSave) {
        if (this.category != null) {
            TasksUiPlugin.getTaskList().addTask((ITask)this.getTask(), (AbstractTaskContainer)this.category);
            this.category = null;
            this.clearState((Control)this.categoryChooser);
        }
        this.getTask().setUrl(this.urlEditor.getText());
        this.clearState(this.urlEditor.getControl());
        super.commit(onSave);
    }

    public Control createControl(Composite parent, FormToolkit toolkit) {
        int style = 258;
        if (this.getTask().getUrl() != null && this.getTask().getUrl().length() > 0) {
            style |= 0x40;
        }
        Section section = this.createSection(parent, toolkit, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        section.setText(Messages.TaskPlanningEditor_Attributes);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        this.createSectionClient(section, toolkit);
        this.setSection(toolkit, section);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        Label label = toolkit.createLabel(composite, Messages.AttributePart_Category_);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.createCategoryChooser(composite, toolkit);
        label = toolkit.createLabel(composite, Messages.TaskPlanningEditor_URL);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.defaultsFor((Control)label).indent(20, 0).applyTo((Control)label);
        Composite urlComposite = toolkit.createComposite(composite);
        GridLayout urlLayout = new GridLayout(2, false);
        urlLayout.verticalSpacing = 0;
        urlLayout.marginWidth = 1;
        urlComposite.setLayout((Layout)urlLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)urlComposite);
        this.urlEditor = new RichTextEditor(this.getRepository(), 0x800004){

            protected void valueChanged(String value) {
                AttributePart.this.updateButtons();
                AttributePart.this.markDirty(AttributePart.this.urlEditor.getControl());
            }
        };
        this.urlEditor.setMode(RepositoryTextViewerConfiguration.Mode.URL);
        this.urlEditor.createControl(urlComposite, toolkit);
        this.urlEditor.getControl().setLayoutData((Object)new GridData(768));
        this.urlEditor.getViewer().getControl().setMenu(parent.getMenu());
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.urlEditor.getControl());
        this.fetchUrlLink = toolkit.createImageHyperlink(urlComposite, 0);
        this.fetchUrlLink.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_RETRIEVE));
        this.fetchUrlLink.setToolTipText(Messages.TaskPlanningEditor_Retrieve_task_description_from_URL);
        this.fetchUrlLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AttributePart.this.featchUrl(AttributePart.this.urlEditor.getText());
            }
        });
        toolkit.paintBordersFor(urlComposite);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        return section;
    }

    private void createSectionClient(Section section, FormToolkit toolkit) {
        if (section.getTextClient() == null) {
            final Composite textClient = toolkit.createComposite((Composite)section);
            textClient.setBackground(null);
            RowLayout rowLayout = new RowLayout();
            EditorUtil.center(rowLayout);
            rowLayout.marginLeft = 20;
            rowLayout.marginTop = 1;
            rowLayout.marginBottom = 1;
            textClient.setLayout((Layout)rowLayout);
            Label label = toolkit.createLabel(textClient, Messages.AttributePart_Category_);
            label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            label.setBackground(null);
            this.categoryLabel = toolkit.createLabel(textClient, "");
            this.categoryLabel.setBackground(null);
            toolkit.paintBordersFor(textClient);
            section.setTextClient((Control)textClient);
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    textClient.setVisible(!e.getState());
                }
            });
            textClient.setVisible(!section.isExpanded());
        }
    }

    private void featchUrl(String url) {
        AbstractRetrieveTitleFromUrlJob job = new AbstractRetrieveTitleFromUrlJob(this.urlEditor.getText()){

            protected void titleRetrieved(String pageTitle) {
                IFormPart[] parts;
                IFormPart[] iFormPartArray = parts = AttributePart.this.getManagedForm().getParts();
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    IFormPart part = iFormPartArray[n2];
                    if (part instanceof SummaryPart) {
                        ((SummaryPart)part).setSummary(pageTitle);
                    }
                    ++n2;
                }
            }
        };
        job.schedule();
    }

    private void updateButtons() {
        String value = this.urlEditor.getText();
        this.fetchUrlLink.setEnabled(value.startsWith("http://") || value.startsWith("https://"));
    }

    public void refresh(boolean discardChanges) {
        if (this.shouldRefresh((Control)this.categoryChooser, discardChanges)) {
            ITaskList taskList = TasksUiInternal.getTaskList();
            this.categories = new ArrayList<AbstractTaskCategory>(taskList.getCategories());
            Collections.sort(this.categories, new TaskContainerComparator());
            AbstractTaskCategory selectedCategory = this.category;
            if (selectedCategory == null) {
                selectedCategory = TaskCategory.getParentTaskCategory((ITask)this.getTask());
            }
            this.categoryChooser.removeAll();
            int selectedIndex = 0;
            int i = 0;
            while (i < this.categories.size()) {
                AbstractTaskCategory category = this.categories.get(i);
                this.categoryChooser.add(category.getSummary());
                if (category.equals((Object)selectedCategory)) {
                    selectedIndex = i;
                }
                ++i;
            }
            this.categoryChooser.select(selectedIndex);
            this.updateCategoryLabel();
        }
        if (this.shouldRefresh(this.urlEditor.getControl(), discardChanges)) {
            String url = this.getTask().getUrl();
            this.urlEditor.setText(url != null ? url : "");
        }
        this.updateButtons();
    }

    private void updateCategoryLabel() {
        if (this.category == null) {
            AbstractTaskCategory parentTaskCategory = TaskCategory.getParentTaskCategory((ITask)this.getTask());
            this.categoryLabel.setText(parentTaskCategory != null ? parentTaskCategory.getSummary() : "");
        } else {
            this.categoryLabel.setText(this.category.getSummary());
        }
        if (!this.getSection().isExpanded()) {
            this.getSection().layout(true, true);
        }
    }

    private void createCategoryChooser(Composite buttonComposite, FormToolkit toolkit) {
        this.categoryChooser = new CCombo(buttonComposite, 0x800008);
        this.categoryChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        toolkit.adapt((Control)this.categoryChooser, false, false);
        this.categoryChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AttributePart.this.categoryChooser.getSelectionIndex() != -1) {
                    AttributePart.this.category = (AbstractTaskCategory)AttributePart.this.categories.get(AttributePart.this.categoryChooser.getSelectionIndex());
                    AttributePart.this.updateCategoryLabel();
                    AttributePart.this.markDirty((Control)AttributePart.this.categoryChooser);
                }
            }
        });
    }
}

