/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.Section;

class FillWidthLayout
extends Layout
implements ILayoutExtension {
    private final int marginLeft;
    private final int marginRight;
    private final int marginTop;
    private final int marginBottom;
    private final int widthHintMargin;
    private Composite layoutAdvisor;
    private int lastWidthHint;
    private Point lastComputedSize;

    public FillWidthLayout() {
        this(0, 0, 0, 0);
    }

    public FillWidthLayout(int marginLeft, int marginRight, int marginTop, int marginBottom) {
        this(null, marginLeft, marginRight, marginTop, marginBottom);
    }

    public FillWidthLayout(Composite layoutAdvisor, int marginLeft, int marginRight, int marginTop, int marginBottom) {
        this.layoutAdvisor = layoutAdvisor;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        this.widthHintMargin = "macosx".equals(Platform.getOS()) ? 15 : 18;
    }

    private int calculateWidthHint(Composite container) {
        return this.calculateWidthHint(container, this.layoutAdvisor == null);
    }

    private int calculateWidthHint(Composite container, boolean layoutAdvisorHit) {
        ScrolledComposite composite;
        ScrollBar verticalBar;
        Layout bodyLayout;
        if (container == this.layoutAdvisor) {
            layoutAdvisorHit = true;
        }
        Rectangle clientArea = container.getClientArea();
        int horizontalMargin = 0;
        if (clientArea.width <= 1 || !layoutAdvisorHit) {
            clientArea.width = this.calculateWidthHint(container.getParent(), layoutAdvisorHit);
        }
        if ((bodyLayout = container.getLayout()) instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)bodyLayout;
            horizontalMargin = gridLayout.marginWidth * 2 + gridLayout.marginLeft + gridLayout.marginRight;
        } else if (bodyLayout instanceof FillLayout) {
            FillLayout fillLayout = (FillLayout)bodyLayout;
            horizontalMargin = fillLayout.marginWidth * 2;
        } else if (container instanceof Section) {
            horizontalMargin = ((Section)container).marginWidth * 2;
        } else if (container instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)container;
            horizontalMargin = folder.marginWidth * 2;
        }
        if (container instanceof ScrolledComposite && (verticalBar = (composite = (ScrolledComposite)container).getVerticalBar()) != null) {
            int verticalBarWidth = verticalBar.getSize().x;
            horizontalMargin += Math.max(15, verticalBarWidth);
        }
        return clientArea.width - horizontalMargin;
    }

    protected Point computeSize(Composite composite, int widthHint, int heightHint, boolean flushCache) {
        int horizontalMargin;
        Control[] children = composite.getChildren();
        if (children.length == 0) {
            return new Point(0, 0);
        }
        if (widthHint <= 0) {
            widthHint = this.calculateWidthHint(composite);
            widthHint -= this.widthHintMargin;
        }
        if (widthHint < (horizontalMargin = this.marginLeft + this.marginRight)) {
            widthHint = horizontalMargin;
        }
        if (this.lastComputedSize == null || widthHint != this.lastWidthHint) {
            int resultX = 1;
            int resultY = 1;
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                Point sz = control.computeSize(widthHint - horizontalMargin, -1, flushCache);
                resultX = Math.max(resultX, sz.x);
                resultY = Math.max(resultY, sz.y);
                ++n2;
            }
            this.lastWidthHint = widthHint;
            this.lastComputedSize = new Point(resultX + horizontalMargin, resultY + this.marginTop + this.marginBottom);
        }
        return new Point(this.lastComputedSize.x, this.lastComputedSize.y + 1);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children;
        Rectangle area = composite.getClientArea();
        if (area.width == 0) {
            area.width = this.calculateWidthHint(composite);
        }
        area.x += this.marginLeft;
        area.y += this.marginTop;
        area.width -= this.marginRight + this.marginLeft;
        area.height -= this.marginBottom + this.marginTop;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setBounds(area);
            ++n2;
        }
    }

    public Composite getLayoutAdvisor() {
        return this.layoutAdvisor;
    }

    public void setLayoutAdvisor(Composite layoutAdvisor) {
        this.layoutAdvisor = layoutAdvisor;
    }

    public void flush() {
        this.lastComputedSize = null;
    }

    public int computeMaximumWidth(Composite parent, boolean changed) {
        Control[] children;
        int width = this.marginLeft + this.marginRight;
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            width = Math.max(control.computeSize((int)-1, (int)0, (boolean)changed).x + this.marginLeft + this.marginRight, width);
            ++n2;
        }
        return width;
    }

    public int computeMinimumWidth(Composite parent, boolean changed) {
        int width = this.marginLeft + this.marginRight;
        return width;
    }
}

