/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonFormUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.ui.commands.ViewSourceHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractHyperlinkTextPresentationManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.BrowserPreviewViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.FillWidthLayout;
import org.eclipse.mylyn.internal.tasks.ui.editors.HighlightingHyperlinkTextPresentationManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkTextPresentationManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

public class RichTextEditor {
    private static final String KEY_TEXT_VERSION = "org.eclipse.mylyn.tasks.ui.textVersion";
    private BrowserPreviewViewer browserViewer;
    private IContextActivation contextActivation;
    private final IContextService contextService;
    private Control control;
    private SourceViewer defaultViewer;
    private Composite editorComposite;
    private StackLayout editorLayout;
    private SourceViewer editorViewer;
    private final AbstractTaskEditorExtension extension;
    private RepositoryTextViewerConfiguration.Mode mode;
    private SourceViewer previewViewer;
    boolean readOnly;
    private AbstractRenderingEngine renderingEngine;
    private final TaskRepository repository;
    private boolean spellCheckingEnabled;
    private final int style;
    private FormToolkit toolkit;
    private final IAction viewSourceAction;
    private String text;
    private int textVersion;

    public RichTextEditor(TaskRepository repository, int style) {
        this(repository, style, null, null);
    }

    public RichTextEditor(TaskRepository repository, int style, IContextService contextService, AbstractTaskEditorExtension extension) {
        this.repository = repository;
        this.style = style;
        this.contextService = contextService;
        this.extension = extension;
        this.text = "";
        this.viewSourceAction = new ViewSourceAction();
        this.setMode(RepositoryTextViewerConfiguration.Mode.DEFAULT);
    }

    private SourceViewer configure(SourceViewer viewer, Document document, boolean readOnly) {
        RichTextEditor.installHyperlinkPresenter((ISourceViewer)viewer, this.repository, this.getMode());
        this.updateDocument(viewer, document, readOnly);
        if (readOnly) {
            if (this.extension != null) {
                viewer.getControl().setData("viewSourceAction", (Object)this.viewSourceAction);
                viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        ViewSourceHandler.setChecked(RichTextEditor.this.getViewer() == RichTextEditor.this.defaultViewer);
                    }
                });
            }
        } else {
            this.installListeners(viewer);
            viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        CommonTextSupport.setTextViewer((Widget)viewer.getTextWidget(), (TextViewer)viewer);
        viewer.setEditable(!readOnly);
        viewer.getTextWidget().setFont(this.getFont());
        if (this.toolkit != null) {
            this.toolkit.adapt(viewer.getControl(), false, false);
        }
        return viewer;
    }

    private void updateDocument(SourceViewer viewer, Document document, boolean readOnly) {
        if (new Integer(this.textVersion).equals(viewer.getData(KEY_TEXT_VERSION))) {
            return;
        }
        if (readOnly) {
            viewer.setDocument((IDocument)document);
        } else {
            AnnotationModel annotationModel = new AnnotationModel();
            viewer.showAnnotations(false);
            viewer.showAnnotationsOverview(false);
            DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
            final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
            Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
            while (e.hasNext()) {
                support.setAnnotationPreference((AnnotationPreference)e.next());
            }
            support.install(EditorsUI.getPreferenceStore());
            viewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    support.uninstall();
                }
            });
            viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        }
        viewer.setData(KEY_TEXT_VERSION, (Object)this.textVersion);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        int style = this.style;
        if (!this.isReadOnly() && (style & 0x10) == 0) {
            style |= 0x200;
        }
        if (this.extension != null || this.renderingEngine != null) {
            this.editorComposite = new Composite(parent, 0);
            this.editorLayout = new StackLayout(){

                protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
                    return this.topControl.computeSize(hint, hint2, flushCache);
                }
            };
            this.editorComposite.setLayout((Layout)this.editorLayout);
            this.setControl((Control)this.editorComposite);
            if (this.extension != null) {
                if (this.isReadOnly()) {
                    this.editorViewer = this.extension.createViewer(this.repository, this.editorComposite, style);
                } else {
                    this.editorViewer = this.extension.createEditor(this.repository, this.editorComposite, style);
                    this.editorViewer.getTextWidget().addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            RichTextEditor.this.setContext();
                        }

                        public void focusLost(FocusEvent e) {
                            RichTextEditor.this.unsetContext();
                        }
                    });
                    this.editorViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            RichTextEditor.this.unsetContext();
                        }
                    });
                }
                this.configure(this.editorViewer, new Document(this.getText()), this.isReadOnly());
                this.show(this.editorViewer.getControl());
            } else {
                this.defaultViewer = this.createDefaultEditor(this.editorComposite, style);
                this.configure(this.defaultViewer, new Document(this.getText()), this.isReadOnly());
                this.show(this.defaultViewer.getControl());
            }
            if (!this.isReadOnly() && (style & 0x10) == 0) {
                this.editorComposite.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            }
            this.viewSourceAction.setEnabled(true);
        } else {
            this.defaultViewer = this.createDefaultEditor(parent, style);
            this.configure(this.defaultViewer, new Document(this.getText()), this.isReadOnly());
            this.setControl(this.defaultViewer.getControl());
            this.viewSourceAction.setEnabled(false);
        }
    }

    private SourceViewer createDefaultEditor(Composite parent, int styles) {
        SourceViewer defaultEditor = new SourceViewer(parent, null, styles | 0x40);
        RepositoryTextViewerConfiguration viewerConfig = new RepositoryTextViewerConfiguration(this.repository, this.isSpellCheckingEnabled() && !this.isReadOnly());
        viewerConfig.setMode(this.getMode());
        defaultEditor.configure((SourceViewerConfiguration)viewerConfig);
        return defaultEditor;
    }

    private BrowserPreviewViewer getBrowserViewer() {
        if (this.editorComposite == null || this.renderingEngine == null) {
            return null;
        }
        if (this.browserViewer == null) {
            this.browserViewer = new BrowserPreviewViewer(this.getRepository(), this.renderingEngine);
            this.browserViewer.createControl(this.editorComposite, this.toolkit);
        }
        return this.browserViewer;
    }

    public Control getControl() {
        return this.control;
    }

    public SourceViewer getDefaultViewer() {
        if (this.defaultViewer == null) {
            this.defaultViewer = this.createDefaultEditor(this.editorComposite, this.style);
            this.configure(this.defaultViewer, new Document(this.getText()), this.isReadOnly());
            this.defaultViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
            this.defaultViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
            this.installMenu(this.defaultViewer.getControl(), this.editorViewer.getControl().getMenu());
        }
        return this.defaultViewer;
    }

    public SourceViewer getEditorViewer() {
        return this.editorViewer;
    }

    private Font getFont() {
        if (this.mode == RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
            return font;
        }
        return EditorUtil.TEXT_FONT;
    }

    public RepositoryTextViewerConfiguration.Mode getMode() {
        return this.mode;
    }

    private SourceViewer getPreviewViewer() {
        if (this.extension == null) {
            return null;
        }
        if (this.previewViewer == null) {
            int previewViewerStyle = this.style;
            if (this.getEditorViewer() != null) {
                previewViewerStyle |= 0x200;
            }
            this.previewViewer = this.extension.createViewer(this.repository, this.editorComposite, previewViewerStyle);
            this.configure(this.previewViewer, new Document(this.getText()), true);
            this.previewViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
        }
        return this.previewViewer;
    }

    public AbstractRenderingEngine getRenderingEngine() {
        return this.renderingEngine;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public String getText() {
        return this.text;
    }

    public SourceViewer getViewer() {
        if (this.editorLayout == null) {
            return this.defaultViewer;
        }
        if (this.defaultViewer != null && this.editorLayout.topControl == this.defaultViewer.getControl()) {
            return this.defaultViewer;
        }
        if (this.previewViewer != null && this.editorLayout.topControl == this.previewViewer.getControl()) {
            return this.previewViewer;
        }
        return this.editorViewer;
    }

    public IAction getViewSourceAction() {
        return this.viewSourceAction;
    }

    public boolean hasBrowser() {
        return this.renderingEngine != null;
    }

    public boolean hasPreview() {
        return this.extension != null && !this.isReadOnly();
    }

    public static RepositoryTextViewerConfiguration installHyperlinkPresenter(ISourceViewer viewer, TaskRepository repository, RepositoryTextViewerConfiguration.Mode mode) {
        RepositoryTextViewerConfiguration configuration = new RepositoryTextViewerConfiguration(repository, false);
        configuration.setMode(mode);
        if (mode == RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            AbstractHyperlinkTextPresentationManager manager = new HighlightingHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors(viewer, null));
            manager.install((ITextViewer)viewer);
            manager = new TaskHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors(viewer, RepositoryTextViewerConfiguration.Mode.TASK));
            manager.install((ITextViewer)viewer);
        } else if (mode == RepositoryTextViewerConfiguration.Mode.TASK_RELATION) {
            TaskHyperlinkTextPresentationManager manager = new TaskHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors(viewer, RepositoryTextViewerConfiguration.Mode.TASK_RELATION));
            manager.install((ITextViewer)viewer);
        }
        return configuration;
    }

    private void installListeners(final SourceViewer viewer) {
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                String value = viewer.getTextWidget().getText();
                if (!RichTextEditor.this.text.equals(value)) {
                    RichTextEditor.this.text = value;
                    RichTextEditor richTextEditor = RichTextEditor.this;
                    richTextEditor.textVersion = richTextEditor.textVersion + 1;
                    viewer.setData(RichTextEditor.KEY_TEXT_VERSION, (Object)RichTextEditor.this.textVersion);
                    RichTextEditor.this.valueChanged(value);
                    CommonFormUtil.ensureVisible((Control)viewer.getTextWidget());
                }
            }
        });
        if ((this.style & 2) != 0 && this.mode != RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            viewer.getTextWidget().addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 8: 
                        case 16: {
                            event.doit = true;
                        }
                    }
                }
            });
        }
    }

    private void installMenu(final Control control, Menu menu) {
        if (menu != null) {
            control.setMenu(menu);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    control.setMenu(null);
                }
            });
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSpellCheckingEnabled() {
        return this.spellCheckingEnabled;
    }

    private void setContext() {
        if (this.contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.contextService != null && this.extension.getEditorContextId() != null) {
            this.contextActivation = this.contextService.activateContext(this.extension.getEditorContextId());
        }
    }

    private void setControl(Control control) {
        this.control = control;
    }

    public void setMode(RepositoryTextViewerConfiguration.Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRenderingEngine(AbstractRenderingEngine renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    public void setSpellCheckingEnabled(boolean spellCheckingEnabled) {
        this.spellCheckingEnabled = spellCheckingEnabled;
    }

    public void setText(String value) {
        this.text = value;
        ++this.textVersion;
        SourceViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.getDocument().set(value);
        }
    }

    private void show(Control control) {
        if (this.editorComposite == null) {
            return;
        }
        this.editorLayout.topControl = control;
        if (this.editorComposite.getParent().getLayout() instanceof FillWidthLayout) {
            ((FillWidthLayout)this.editorComposite.getParent().getLayout()).flush();
        }
        this.editorComposite.layout();
        control.setFocus();
    }

    private void show(SourceViewer viewer) {
        this.updateDocument(viewer, new Document(this.getText()), !viewer.isEditable());
        this.show(viewer.getControl());
    }

    public void showBrowser() {
        BrowserPreviewViewer viewer = this.getBrowserViewer();
        viewer.update(this.getText());
        if (viewer != null) {
            this.show((Control)viewer.getControl());
        }
    }

    public void showDefault() {
        this.show(this.getDefaultViewer());
    }

    public void showEditor() {
        if (this.getEditorViewer() != null) {
            this.show(this.getEditorViewer());
        } else {
            this.show(this.getDefaultViewer());
        }
    }

    public void showPreview() {
        if (!this.isReadOnly()) {
            this.show(this.getPreviewViewer());
        }
    }

    private void unsetContext() {
        if (this.contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }

    protected void valueChanged(String value) {
    }

    public class ViewSourceAction
    extends Action {
        public ViewSourceAction() {
            super(Messages.RichTextAttributeEditor_Viewer_Source, 2);
            this.setChecked(false);
            this.setEnabled(false);
        }

        public void run() {
            if (this.isChecked()) {
                RichTextEditor.this.showDefault();
            } else {
                RichTextEditor.this.showEditor();
            }
            if (RichTextEditor.this.editorLayout != null) {
                EditorUtil.reflow(((RichTextEditor)RichTextEditor.this).editorLayout.topControl);
            }
            ViewSourceHandler.setChecked(this.isChecked());
        }
    }
}

