/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.widgets.ToolBar;

public class PlatformUtil {
    private static ByteArrayTransfer urlTransfer;

    static {
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.dnd.URLTransfer");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            if (method != null) {
                urlTransfer = (ByteArrayTransfer)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
        if (urlTransfer == null) {
            urlTransfer = new ByteArrayTransfer(){
                private static final String TYPE = "dummy";
                private final int TYPE_ID = 1.registerType((String)"dummy");

                protected int[] getTypeIds() {
                    return new int[]{this.TYPE_ID};
                }

                protected String[] getTypeNames() {
                    return new String[]{TYPE};
                }
            };
        }
    }

    public static String[] getFilterExtensions(String ... extensions) {
        int i = 0;
        while (i < extensions.length) {
            int j;
            String extension = extensions[i];
            if ("macosx".equals(Platform.getOS()) && (j = extension.lastIndexOf(46)) != -1) {
                extension = extension.substring(j);
            }
            extensions[i] = "*" + extension;
            ++i;
        }
        return extensions;
    }

    public static int getToolTipXShift() {
        if ("gtk".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform())) {
            return -26;
        }
        return -23;
    }

    public static int getTreeImageOffset() {
        if ("carbon".equals(SWT.getPlatform())) {
            return 16;
        }
        if ("cocoa".equals(SWT.getPlatform())) {
            return 13;
        }
        return 20;
    }

    public static int getIncomingImageOffset() {
        if ("carbon".equals(SWT.getPlatform())) {
            return 5;
        }
        if ("cocoa".equals(SWT.getPlatform())) {
            return 2;
        }
        return 6;
    }

    public static int getTreeItemSquish() {
        if ("gtk".equals(SWT.getPlatform())) {
            return 8;
        }
        if (PlatformUtil.isMac()) {
            return 3;
        }
        return 0;
    }

    private static boolean isMac() {
        return "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
    }

    public static boolean isPaintItemClippingRequired() {
        return "gtk".equals(SWT.getPlatform());
    }

    public static ByteArrayTransfer getUrlTransfer() {
        return urlTransfer;
    }

    public static boolean isToolBarHeightBroken(ToolBar toolBar) {
        return "gtk".equals(SWT.getPlatform()) && toolBar.computeSize((int)-1, (int)-1, (boolean)false).y == 0;
    }

    public static boolean spinnerHasNativeBorder() {
        return PlatformUtil.isMac();
    }

    public static boolean hasNarrowToolBar() {
        return "win32".equals(SWT.getPlatform());
    }
}

