/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.Comparator;
import java.util.Date;
import org.eclipse.mylyn.internal.tasks.ui.util.SortCriterion;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskComparator
implements Comparator<ITask> {
    private final SortCriterion[] sortCriteria;
    public static final int DEFAULT_SORT_DIRECTION = 1;
    private static final SortCriterion.SortKey DEFAULT_SORT_INDEX = SortCriterion.SortKey.PRIORITY;
    private static final SortCriterion.SortKey DEFAULT_SORT_INDEX2 = SortCriterion.SortKey.DATE_CREATED;
    private static final String MEMENTO_KEY_SORT = "sort";
    private final TaskKeyComparator taskKeyComparator = new TaskKeyComparator();
    public static final int CRITERIA_COUNT = SortCriterion.SortKey.values().length - 1;

    public static String[] getSortableFromElement(IRepositoryElement element) {
        ITask task1;
        String[] stringArray = new String[3];
        stringArray[0] = "";
        stringArray[2] = element.getSummary();
        String[] a = stringArray;
        if (element instanceof ITask && (task1 = (ITask)element).getTaskKey() != null) {
            a[1] = task1.getTaskKey();
        }
        return a;
    }

    public TaskComparator() {
        this.sortCriteria = new SortCriterion[CRITERIA_COUNT];
        int index = 0;
        while (index < CRITERIA_COUNT) {
            this.sortCriteria[index] = new SortCriterion();
            ++index;
        }
        this.sortCriteria[0].setKey(DEFAULT_SORT_INDEX);
        this.sortCriteria[1].setKey(DEFAULT_SORT_INDEX2);
    }

    @Override
    public int compare(ITask element1, ITask element2) {
        SortCriterion[] sortCriterionArray = this.sortCriteria;
        int n = this.sortCriteria.length;
        int n2 = 0;
        while (n2 < n) {
            int result;
            SortCriterion key = sortCriterionArray[n2];
            switch (key.getKey()) {
                case DATE_CREATED: {
                    result = this.sortByDate(element1, element2, key.getDirection());
                    break;
                }
                case PRIORITY: {
                    result = this.sortByPriority(element1, element2, key.getDirection());
                    break;
                }
                case SUMMARY: {
                    result = this.sortBySummary(element1, element2, key.getDirection());
                    break;
                }
                case TASK_ID: {
                    result = this.sortByID(element1, element2, key.getDirection());
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (result != 0) {
                return result;
            }
            ++n2;
        }
        return 0;
    }

    public SortCriterion getSortCriterion(int index) {
        return this.sortCriteria[index];
    }

    public void restoreState(IMemento memento) {
        if (memento != null) {
            int index = 0;
            while (index < CRITERIA_COUNT) {
                IMemento child = memento.getChild(MEMENTO_KEY_SORT + index);
                if (child != null && this.sortCriteria[index] != null) {
                    this.sortCriteria[index].restoreState(child);
                }
                ++index;
            }
        }
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            int index = 0;
            while (index < CRITERIA_COUNT) {
                IMemento child = memento.createChild(MEMENTO_KEY_SORT + index);
                if (child != null && this.sortCriteria[index] != null) {
                    this.sortCriteria[index].saveState(child);
                }
                ++index;
            }
        }
    }

    private int sortByDate(ITask element1, ITask element2, int sortDirection) {
        Date date1 = element1.getCreationDate();
        Date date2 = element2.getCreationDate();
        if (date1 == null) {
            return date2 != null ? sortDirection : 0;
        }
        if (date2 == null) {
            return -sortDirection;
        }
        return sortDirection * date1.compareTo(date2);
    }

    private int sortByID(ITask element1, ITask element2, int sortDirection) {
        String key1 = element1.getTaskKey();
        String key2 = element2.getTaskKey();
        if (key1 == null) {
            return key2 != null ? sortDirection : 0;
        }
        if (key2 == null) {
            return -sortDirection;
        }
        return sortDirection * this.taskKeyComparator.compare2(key1, key2);
    }

    private int sortByPriority(ITask element1, ITask element2, int sortDirection) {
        return sortDirection * element1.getPriority().compareToIgnoreCase(element2.getPriority());
    }

    private int sortBySummary(ITask element1, ITask element2, int sortDirection) {
        String key1 = element1.getSummary();
        String key2 = element2.getSummary();
        if (key1 == null) {
            return key2 != null ? sortDirection : 0;
        }
        if (key2 == null) {
            return -sortDirection;
        }
        return sortDirection * key1.compareToIgnoreCase(key2);
    }
}

